/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-08-18 11:43:01 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=832 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=20291 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=2468 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=59477 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=7077 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1570 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=134 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_navigations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_sliders` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_smush_dir_images` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `path` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `path_hash` char(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `resize` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lossy` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `error` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `image_size` int unsigned DEFAULT NULL,
  `orig_size` int unsigned DEFAULT NULL,
  `file_time` int unsigned DEFAULT NULL,
  `last_scan` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  `meta` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `path_hash` (`path_hash`),
  KEY `image_size` (`image_size`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=280 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=203 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=63533 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=132 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `address_type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` text COLLATE utf8mb4_unicode_520_ci,
  `last_name` text COLLATE utf8mb4_unicode_520_ci,
  `company` text COLLATE utf8mb4_unicode_520_ci,
  `address_1` text COLLATE utf8mb4_unicode_520_ci,
  `address_2` text COLLATE utf8mb4_unicode_520_ci,
  `city` text COLLATE utf8mb4_unicode_520_ci,
  `state` text COLLATE utf8mb4_unicode_520_ci,
  `postcode` text COLLATE utf8mb4_unicode_520_ci,
  `country` text COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_via` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `woocommerce_version` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint unsigned NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `billing_email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint unsigned DEFAULT NULL,
  `payment_method` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method_title` text COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci,
  `customer_note` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`),
  KEY `billing_email` (`billing_email`),
  KEY `type_status` (`type`,`status`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`,`meta_value`(100)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`,`meta_value`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint NOT NULL,
  `product_or_parent_id` bigint NOT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `global_unique_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint unsigned NOT NULL,
  `rate_limit_remaining` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=1700 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woodmart_wishlist_products` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `wishlist_id` int DEFAULT NULL,
  `date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `on_sale` tinyint(1) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_woodmart_wishlists` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `wishlist_group` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'My wishlist',
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("10", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "failed", "2023-09-06 16:25:50", "2023-09-06 16:25:50", "10", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-09-06 16:25:55", "2023-09-06 19:55:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("75", "action_scheduler/migration_hook", "failed", "2023-09-08 11:41:22", "2023-09-08 11:41:22", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1694173282;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1694173282;}", "1", "1", "2023-09-08 11:43:22", "2023-09-08 11:43:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("77", "action_scheduler/migration_hook", "failed", "2023-09-08 15:23:32", "2023-09-08 15:23:32", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1694186612;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1694186612;}", "1", "1", "2023-09-08 15:25:32", "2023-09-08 15:25:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("743", "woocommerce_refresh_order_count_cache", "complete", "2025-07-18 19:55:21", "2025-07-18 19:55:21", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752868521;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752868521;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-07-19 02:12:44", "2025-07-19 02:12:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("744", "woocommerce_cleanup_draft_orders", "complete", "2025-07-19 09:50:09", "2025-07-19 09:50:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752918609;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752918609;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-07-19 14:14:11", "2025-07-19 14:14:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("745", "woocommerce_refresh_order_count_cache", "complete", "2025-07-19 14:12:44", "2025-07-19 14:12:44", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752934364;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752934364;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-07-19 14:14:11", "2025-07-19 14:14:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("746", "woocommerce_cleanup_draft_orders", "complete", "2025-07-20 14:14:11", "2025-07-20 14:14:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753020851;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753020851;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-07-20 14:24:04", "2025-07-20 14:24:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("747", "woocommerce_refresh_order_count_cache", "complete", "2025-07-20 02:14:11", "2025-07-20 02:14:11", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1752977651;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1752977651;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-07-20 05:25:24", "2025-07-20 05:25:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("748", "woocommerce_refresh_order_count_cache", "complete", "2025-07-20 17:25:24", "2025-07-20 17:25:24", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753032324;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753032324;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-07-20 18:20:08", "2025-07-20 18:20:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("749", "woocommerce_cleanup_draft_orders", "complete", "2025-07-21 14:24:04", "2025-07-21 14:24:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753107844;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753107844;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-07-21 15:24:30", "2025-07-21 15:24:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("750", "woocommerce_refresh_order_count_cache", "complete", "2025-07-21 06:20:08", "2025-07-21 06:20:08", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753078808;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753078808;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-07-21 08:05:04", "2025-07-21 08:05:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("751", "woocommerce_refresh_order_count_cache", "complete", "2025-07-21 20:05:04", "2025-07-21 20:05:04", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753128304;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753128304;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-07-21 20:58:07", "2025-07-21 20:58:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("752", "woocommerce_cleanup_draft_orders", "complete", "2025-07-22 15:24:30", "2025-07-22 15:24:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753197870;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753197870;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-07-22 18:07:15", "2025-07-22 18:07:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("753", "woocommerce_refresh_order_count_cache", "complete", "2025-07-22 08:58:07", "2025-07-22 08:58:07", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753174687;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753174687;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-07-22 13:01:34", "2025-07-22 13:01:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("754", "woocommerce_refresh_order_count_cache", "complete", "2025-07-23 01:01:34", "2025-07-23 01:01:34", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753232494;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753232494;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-07-23 08:57:48", "2025-07-23 08:57:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("755", "woocommerce_cleanup_draft_orders", "complete", "2025-07-23 18:07:15", "2025-07-23 18:07:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753294035;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753294035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-07-23 18:28:44", "2025-07-23 18:28:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("756", "woocommerce_refresh_order_count_cache", "complete", "2025-07-23 20:57:48", "2025-07-23 20:57:48", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753304268;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753304268;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-07-24 06:38:17", "2025-07-24 06:38:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("757", "woocommerce_cleanup_draft_orders", "complete", "2025-07-24 18:28:44", "2025-07-24 18:28:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753381724;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753381724;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-07-24 18:53:12", "2025-07-24 18:53:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("758", "woocommerce_refresh_order_count_cache", "complete", "2025-07-24 18:38:17", "2025-07-24 18:38:17", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753382297;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753382297;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-07-24 18:53:12", "2025-07-24 18:53:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("759", "woocommerce_cleanup_draft_orders", "complete", "2025-07-25 18:53:12", "2025-07-25 18:53:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753469592;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753469592;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-07-25 18:56:15", "2025-07-25 18:56:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("760", "woocommerce_refresh_order_count_cache", "complete", "2025-07-25 06:53:12", "2025-07-25 06:53:12", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753426392;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753426392;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-07-25 12:16:02", "2025-07-25 12:16:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("761", "woocommerce_refresh_order_count_cache", "complete", "2025-07-26 00:16:02", "2025-07-26 00:16:02", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753488962;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753488962;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-07-26 06:24:39", "2025-07-26 06:24:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("762", "woocommerce_cleanup_draft_orders", "complete", "2025-07-26 18:56:15", "2025-07-26 18:56:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753556175;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753556175;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-07-27 08:31:06", "2025-07-27 08:31:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("763", "woocommerce_refresh_order_count_cache", "complete", "2025-07-26 18:24:39", "2025-07-26 18:24:39", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753554279;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753554279;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-07-27 08:31:06", "2025-07-27 08:31:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("764", "woocommerce_refresh_order_count_cache", "complete", "2025-07-27 20:31:06", "2025-07-27 20:31:06", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753648266;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753648266;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-07-28 04:32:59", "2025-07-28 04:32:59", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("765", "woocommerce_cleanup_draft_orders", "complete", "2025-07-28 08:31:06", "2025-07-28 08:31:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753691466;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753691466;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-07-28 09:36:17", "2025-07-28 09:36:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("766", "woocommerce_refresh_order_count_cache", "complete", "2025-07-28 16:32:59", "2025-07-28 16:32:59", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753720379;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753720379;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-07-28 17:25:34", "2025-07-28 17:25:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("767", "woocommerce_cleanup_draft_orders", "complete", "2025-07-29 09:36:17", "2025-07-29 09:36:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753781777;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753781777;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-07-29 15:31:18", "2025-07-29 15:31:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("768", "woocommerce_refresh_order_count_cache", "complete", "2025-07-29 05:25:34", "2025-07-29 05:25:34", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753766734;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753766734;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-07-29 08:43:43", "2025-07-29 08:43:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("769", "woocommerce_refresh_order_count_cache", "complete", "2025-07-29 20:43:43", "2025-07-29 20:43:43", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753821823;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753821823;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-07-30 05:37:05", "2025-07-30 05:37:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("770", "woocommerce_cleanup_draft_orders", "complete", "2025-07-30 15:31:18", "2025-07-30 15:31:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753889478;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753889478;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-07-30 18:30:35", "2025-07-30 18:30:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("771", "woocommerce_refresh_order_count_cache", "complete", "2025-07-30 17:37:05", "2025-07-30 17:37:05", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753897025;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753897025;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-07-30 18:30:35", "2025-07-30 18:30:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("772", "woocommerce_cleanup_draft_orders", "complete", "2025-07-31 18:30:35", "2025-07-31 18:30:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753986635;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753986635;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-07-31 18:47:12", "2025-07-31 18:47:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("773", "woocommerce_refresh_order_count_cache", "complete", "2025-07-31 06:30:35", "2025-07-31 06:30:35", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753943435;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753943435;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-07-31 08:49:59", "2025-07-31 08:49:59", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("774", "woocommerce_refresh_order_count_cache", "complete", "2025-07-31 20:49:59", "2025-07-31 20:49:59", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753994999;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753994999;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-01 08:27:47", "2025-08-01 08:27:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("775", "woocommerce_cleanup_draft_orders", "complete", "2025-08-01 18:47:12", "2025-08-01 18:47:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754074032;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754074032;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-01 20:19:08", "2025-08-01 20:19:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("776", "woocommerce_refresh_order_count_cache", "complete", "2025-08-01 20:27:47", "2025-08-01 20:27:47", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754080067;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754080067;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-01 22:35:19", "2025-08-01 22:35:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("777", "woocommerce_cleanup_draft_orders", "complete", "2025-08-02 20:19:08", "2025-08-02 20:19:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754165948;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754165948;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-02 20:29:28", "2025-08-02 20:29:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("778", "woocommerce_refresh_order_count_cache", "complete", "2025-08-02 10:35:19", "2025-08-02 10:35:19", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754130919;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754130919;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-02 11:50:32", "2025-08-02 11:50:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("779", "woocommerce_refresh_order_count_cache", "complete", "2025-08-02 23:50:32", "2025-08-02 23:50:32", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754178632;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754178632;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-03 03:15:17", "2025-08-03 03:15:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("780", "woocommerce_cleanup_draft_orders", "complete", "2025-08-03 20:29:28", "2025-08-03 20:29:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754252968;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754252968;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-03 21:46:37", "2025-08-03 21:46:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("781", "woocommerce_refresh_order_count_cache", "complete", "2025-08-03 15:15:17", "2025-08-03 15:15:17", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754234117;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754234117;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-03 21:46:37", "2025-08-03 21:46:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("782", "woocommerce_refresh_order_count_cache", "complete", "2025-08-04 09:46:37", "2025-08-04 09:46:37", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754300797;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754300797;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-04 10:15:37", "2025-08-04 10:15:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("783", "woocommerce_cleanup_draft_orders", "complete", "2025-08-04 21:46:37", "2025-08-04 21:46:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754343997;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754343997;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-04 22:41:11", "2025-08-04 22:41:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("784", "woocommerce_refresh_order_count_cache", "complete", "2025-08-04 22:15:37", "2025-08-04 22:15:37", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754345737;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754345737;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-04 22:41:11", "2025-08-04 22:41:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("785", "woocommerce_cleanup_draft_orders", "complete", "2025-08-05 22:41:11", "2025-08-05 22:41:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754433671;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754433671;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-06 02:18:12", "2025-08-06 02:18:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("786", "woocommerce_refresh_order_count_cache", "complete", "2025-08-05 10:41:11", "2025-08-05 10:41:11", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754390471;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754390471;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-05 11:06:28", "2025-08-05 11:06:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("787", "woocommerce_refresh_order_count_cache", "complete", "2025-08-05 23:06:28", "2025-08-05 23:06:28", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754435188;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754435188;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-06 02:18:12", "2025-08-06 02:18:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("788", "woocommerce_cleanup_draft_orders", "complete", "2025-08-07 02:18:12", "2025-08-07 02:18:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754533092;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754533092;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-07 09:26:35", "2025-08-07 09:26:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("789", "woocommerce_refresh_order_count_cache", "complete", "2025-08-06 14:18:12", "2025-08-06 14:18:12", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754489892;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754489892;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-06 15:23:11", "2025-08-06 15:23:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("790", "woocommerce_refresh_order_count_cache", "complete", "2025-08-07 03:23:12", "2025-08-07 03:23:12", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754536992;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754536992;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-07 09:26:35", "2025-08-07 09:26:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("791", "woocommerce_cleanup_draft_orders", "complete", "2025-08-08 09:26:35", "2025-08-08 09:26:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754645195;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754645195;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-08 09:50:58", "2025-08-08 09:50:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("792", "woocommerce_refresh_order_count_cache", "complete", "2025-08-07 21:26:35", "2025-08-07 21:26:35", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754601995;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754601995;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-08 02:33:02", "2025-08-08 02:33:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("793", "woocommerce_refresh_order_count_cache", "complete", "2025-08-08 14:33:02", "2025-08-08 14:33:02", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754663582;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754663582;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-09 03:52:58", "2025-08-09 03:52:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("794", "woocommerce_cleanup_draft_orders", "complete", "2025-08-09 09:50:58", "2025-08-09 09:50:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754733058;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754733058;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-09 10:51:10", "2025-08-09 10:51:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("795", "woocommerce_refresh_order_count_cache", "complete", "2025-08-09 15:52:58", "2025-08-09 15:52:58", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754754778;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754754778;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-09 16:05:51", "2025-08-09 16:05:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("796", "woocommerce_cleanup_draft_orders", "complete", "2025-08-10 10:51:10", "2025-08-10 10:51:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754823070;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754823070;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-10 13:09:51", "2025-08-10 13:09:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("797", "woocommerce_refresh_order_count_cache", "complete", "2025-08-10 04:05:51", "2025-08-10 04:05:51", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754798751;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754798751;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-10 08:01:29", "2025-08-10 08:01:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("798", "woocommerce_refresh_order_count_cache", "complete", "2025-08-10 20:01:29", "2025-08-10 20:01:29", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754856089;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754856089;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-10 21:16:31", "2025-08-10 21:16:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("799", "woocommerce_cleanup_draft_orders", "complete", "2025-08-11 13:09:51", "2025-08-11 13:09:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754917791;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754917791;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-11 13:36:21", "2025-08-11 13:36:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("800", "woocommerce_refresh_order_count_cache", "complete", "2025-08-11 09:16:31", "2025-08-11 09:16:31", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754903791;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754903791;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-11 09:40:10", "2025-08-11 09:40:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("801", "woocommerce_refresh_order_count_cache", "complete", "2025-08-11 21:40:10", "2025-08-11 21:40:10", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754948410;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754948410;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-12 08:49:31", "2025-08-12 08:49:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("802", "woocommerce_cleanup_draft_orders", "complete", "2025-08-12 13:36:21", "2025-08-12 13:36:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755005781;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755005781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-12 15:30:48", "2025-08-12 15:30:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("803", "woocommerce_refresh_order_count_cache", "complete", "2025-08-12 20:49:31", "2025-08-12 20:49:31", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755031771;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755031771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-12 21:49:11", "2025-08-12 21:49:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("804", "woocommerce_cleanup_draft_orders", "complete", "2025-08-13 15:30:48", "2025-08-13 15:30:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755099048;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755099048;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-13 20:27:47", "2025-08-13 20:27:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("805", "woocommerce_refresh_order_count_cache", "complete", "2025-08-13 09:49:11", "2025-08-13 09:49:11", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755078551;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755078551;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-13 10:16:38", "2025-08-13 10:16:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("806", "woocommerce_refresh_order_count_cache", "complete", "2025-08-13 22:16:38", "2025-08-13 22:16:38", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755123398;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755123398;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-14 00:16:26", "2025-08-14 00:16:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("807", "woocommerce_cleanup_draft_orders", "complete", "2025-08-14 20:27:47", "2025-08-14 20:27:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755203267;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755203267;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-14 21:42:04", "2025-08-14 21:42:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("808", "woocommerce_refresh_order_count_cache", "complete", "2025-08-14 12:16:26", "2025-08-14 12:16:26", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755173786;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755173786;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-14 13:57:24", "2025-08-14 13:57:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("809", "woocommerce_refresh_order_count_cache", "complete", "2025-08-15 01:57:24", "2025-08-15 01:57:24", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755223044;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755223044;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-15 06:25:59", "2025-08-15 06:25:59", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("810", "woocommerce_cleanup_draft_orders", "complete", "2025-08-15 21:42:04", "2025-08-15 21:42:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755294124;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755294124;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-15 22:35:40", "2025-08-15 22:35:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("811", "woocommerce_refresh_order_count_cache", "complete", "2025-08-15 18:25:59", "2025-08-15 18:25:59", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755282359;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755282359;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-15 19:02:48", "2025-08-15 19:02:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("812", "woocommerce_refresh_order_count_cache", "complete", "2025-08-16 07:02:48", "2025-08-16 07:02:48", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755327768;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755327768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-16 07:20:45", "2025-08-16 07:20:45", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("813", "woocommerce_cleanup_draft_orders", "complete", "2025-08-16 22:35:40", "2025-08-16 22:35:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755383740;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755383740;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-17 04:15:57", "2025-08-17 04:15:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("814", "woocommerce_refresh_order_count_cache", "complete", "2025-08-16 19:20:45", "2025-08-16 19:20:45", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755372045;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755372045;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-17 04:15:57", "2025-08-17 04:15:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("815", "woocommerce_refresh_order_count_cache", "complete", "2025-08-17 16:15:57", "2025-08-17 16:15:57", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755447357;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755447357;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-17 17:18:40", "2025-08-17 17:18:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("816", "woocommerce_cleanup_draft_orders", "complete", "2025-08-18 04:15:57", "2025-08-18 04:15:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755490557;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755490557;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-18 06:03:30", "2025-08-18 06:03:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("817", "woocommerce_refresh_order_count_cache", "complete", "2025-08-18 05:18:40", "2025-08-18 05:18:40", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755494320;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755494320;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-08-18 06:03:31", "2025-08-18 06:03:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("818", "woocommerce_cleanup_draft_orders", "pending", "2025-08-19 06:03:30", "2025-08-19 06:03:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755583410;s:18:\"\0*\0first_timestamp\";i:1694017492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755583410;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("819", "woocommerce_refresh_order_count_cache", "pending", "2025-08-18 18:03:31", "2025-08-18 18:03:31", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755540211;s:18:\"\0*\0first_timestamp\";i:1751406426;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755540211;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("820", "fetch_patterns", "complete", "2025-08-18 11:06:55", "2025-08-18 11:06:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755515215;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755515215;}", "2", "1", "2025-08-18 11:07:17", "2025-08-18 11:07:17", "20256", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("821", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2025-08-18 11:07:17", "2025-08-18 11:07:17", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755515237;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755515237;}", "6", "1", "2025-08-18 11:07:18", "2025-08-18 11:07:18", "20256", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("822", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-18 11:28:18", "2025-08-18 11:28:18", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755516498;s:18:\"\0*\0first_timestamp\";i:1755516498;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755516498;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-18 11:28:19", "2025-08-18 11:28:19", "20270", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("823", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2025-08-19 11:28:19", "2025-08-19 11:28:19", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755602899;s:18:\"\0*\0first_timestamp\";i:1755516498;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755602899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("824", "image-optimization/database/migration", "complete", "2025-08-18 11:35:52", "2025-08-18 11:35:52", "0", "{\"name\":\"fix_optimized_size_keys\"}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "9", "1", "2025-08-18 11:36:52", "2025-08-18 11:36:52", "20275", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("825", "image-optimization/cleanup/stuck-operation", "complete", "2025-08-18 11:35:52", "2025-08-18 11:35:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755516952;s:18:\"\0*\0first_timestamp\";i:1755516952;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755516952;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "10", "1", "2025-08-18 11:36:52", "2025-08-18 11:36:52", "20275", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("826", "image-optimization/cleanup/stuck-operation", "failed", "2025-08-18 11:41:52", "2025-08-18 11:41:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755517312;s:18:\"\0*\0first_timestamp\";i:1755516952;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755517312;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "10", "1", "2025-08-18 11:41:58", "2025-08-18 11:41:58", "20288", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("827", "image-optimization/database/migration", "complete", "2025-08-18 11:36:56", "2025-08-18 11:36:56", "0", "{\"name\":\"fix_mime_type\"}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "9", "1", "2025-08-18 11:36:58", "2025-08-18 11:36:58", "20277", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("828", "image-optimization/database/migration", "complete", "2025-08-18 11:36:59", "2025-08-18 11:36:59", "0", "{\"name\":\"fix_avif_with_zero_dimensions\"}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "9", "1", "2025-08-18 11:37:04", "2025-08-18 11:37:04", "20279", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("829", "action_scheduler/migration_hook", "complete", "2025-08-18 11:38:20", "2025-08-18 11:38:20", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755517100;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755517100;}", "1", "1", "2025-08-18 11:38:54", "2025-08-18 11:38:54", "20282", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("830", "action_scheduler/migration_hook", "complete", "2025-08-18 11:40:31", "2025-08-18 11:40:31", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1755517231;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1755517231;}", "1", "1", "2025-08-18 11:40:34", "2025-08-18 11:40:34", "20285", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("831", "image-optimization/cleanup/stuck-operation", "pending", "2025-08-18 11:46:58", "2025-08-18 11:46:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755517618;s:18:\"\0*\0first_timestamp\";i:1755516952;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755517618;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "10", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "wc_update_product_lookup_tables");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "wc_update_product_default_cat");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "count");
INSERT INTO `wp_actionscheduler_groups` VALUES("8", "ActionScheduler");
INSERT INTO `wp_actionscheduler_groups` VALUES("9", "image-optimization/migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("10", "image-optimization/cleanup");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("6", "10", "ایجاد فعالیت", "2023-09-06 16:25:50", "2023-09-06 16:25:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("8", "10", "عملیات توسط Async Request شروع شد", "2023-09-06 16:25:55", "2023-09-06 16:25:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("9", "10", "اقدام از طریق Async Request انجام نشد: Scheduled action for woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications will not be executed as no callbacks are registered.", "2023-09-06 16:25:55", "2023-09-06 16:25:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("203", "75", "ایجاد فعالیت", "2023-09-08 11:40:22", "2023-09-08 11:40:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("204", "75", "عملیات توسط WP Cron شروع شد", "2023-09-08 11:43:22", "2023-09-08 11:43:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("205", "75", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-09-08 11:43:22", "2023-09-08 11:43:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("209", "77", "ایجاد فعالیت", "2023-09-08 15:22:32", "2023-09-08 15:22:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("210", "77", "عملیات توسط WP Cron شروع شد", "2023-09-08 15:25:32", "2023-09-08 15:25:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("211", "77", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-09-08 15:25:32", "2023-09-08 15:25:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2207", "743", "ایجاد فعالیت", "2025-07-18 07:55:21", "2025-07-18 07:55:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2210", "744", "ایجاد فعالیت", "2025-07-18 09:50:09", "2025-07-18 09:50:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2211", "743", "عملیات توسط WP Cron شروع شد", "2025-07-19 02:12:44", "2025-07-19 02:12:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2212", "743", "عملیات توسط WP Cron کامل شد", "2025-07-19 02:12:44", "2025-07-19 02:12:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2213", "745", "ایجاد فعالیت", "2025-07-19 02:12:44", "2025-07-19 02:12:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2214", "744", "عملیات توسط WP Cron شروع شد", "2025-07-19 14:14:11", "2025-07-19 14:14:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2215", "744", "عملیات توسط WP Cron کامل شد", "2025-07-19 14:14:11", "2025-07-19 14:14:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2216", "746", "ایجاد فعالیت", "2025-07-19 14:14:11", "2025-07-19 14:14:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2217", "745", "عملیات توسط WP Cron شروع شد", "2025-07-19 14:14:11", "2025-07-19 14:14:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2218", "745", "عملیات توسط WP Cron کامل شد", "2025-07-19 14:14:11", "2025-07-19 14:14:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2219", "747", "ایجاد فعالیت", "2025-07-19 14:14:11", "2025-07-19 14:14:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2220", "747", "عملیات توسط WP Cron شروع شد", "2025-07-20 05:25:24", "2025-07-20 05:25:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2221", "747", "عملیات توسط WP Cron کامل شد", "2025-07-20 05:25:24", "2025-07-20 05:25:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2222", "748", "ایجاد فعالیت", "2025-07-20 05:25:24", "2025-07-20 05:25:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2223", "746", "عملیات توسط WP Cron شروع شد", "2025-07-20 14:24:04", "2025-07-20 14:24:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2224", "746", "عملیات توسط WP Cron کامل شد", "2025-07-20 14:24:04", "2025-07-20 14:24:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2225", "749", "ایجاد فعالیت", "2025-07-20 14:24:04", "2025-07-20 14:24:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2226", "748", "عملیات توسط WP Cron شروع شد", "2025-07-20 18:20:08", "2025-07-20 18:20:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2227", "748", "عملیات توسط WP Cron کامل شد", "2025-07-20 18:20:08", "2025-07-20 18:20:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2228", "750", "ایجاد فعالیت", "2025-07-20 18:20:08", "2025-07-20 18:20:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2229", "750", "عملیات توسط WP Cron شروع شد", "2025-07-21 08:05:04", "2025-07-21 08:05:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2230", "750", "عملیات توسط WP Cron کامل شد", "2025-07-21 08:05:04", "2025-07-21 08:05:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2231", "751", "ایجاد فعالیت", "2025-07-21 08:05:04", "2025-07-21 08:05:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2232", "749", "عملیات توسط WP Cron شروع شد", "2025-07-21 15:24:30", "2025-07-21 15:24:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2233", "749", "عملیات توسط WP Cron کامل شد", "2025-07-21 15:24:30", "2025-07-21 15:24:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2234", "752", "ایجاد فعالیت", "2025-07-21 15:24:30", "2025-07-21 15:24:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2235", "751", "عملیات توسط WP Cron شروع شد", "2025-07-21 20:58:07", "2025-07-21 20:58:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("2236", "751", "عملیات توسط WP Cron کامل شد", "2025-07-21 20:58:07", "2025-07-21 20:58:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("2237", "753", "ایجاد فعالیت", "2025-07-21 20:58:07", "2025-07-21 20:58:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("2238", "753", "عملیات توسط WP Cron شروع شد", "2025-07-22 13:01:34", "2025-07-22 13:01:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2239", "753", "عملیات توسط WP Cron کامل شد", "2025-07-22 13:01:34", "2025-07-22 13:01:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2240", "754", "ایجاد فعالیت", "2025-07-22 13:01:34", "2025-07-22 13:01:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2241", "752", "عملیات توسط WP Cron شروع شد", "2025-07-22 18:07:15", "2025-07-22 18:07:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2242", "752", "عملیات توسط WP Cron کامل شد", "2025-07-22 18:07:15", "2025-07-22 18:07:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2243", "755", "ایجاد فعالیت", "2025-07-22 18:07:15", "2025-07-22 18:07:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2244", "754", "عملیات توسط WP Cron شروع شد", "2025-07-23 08:57:48", "2025-07-23 08:57:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2245", "754", "عملیات توسط WP Cron کامل شد", "2025-07-23 08:57:48", "2025-07-23 08:57:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2246", "756", "ایجاد فعالیت", "2025-07-23 08:57:48", "2025-07-23 08:57:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2247", "755", "عملیات توسط WP Cron شروع شد", "2025-07-23 18:28:44", "2025-07-23 18:28:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2248", "755", "عملیات توسط WP Cron کامل شد", "2025-07-23 18:28:44", "2025-07-23 18:28:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2249", "757", "ایجاد فعالیت", "2025-07-23 18:28:44", "2025-07-23 18:28:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2250", "756", "عملیات توسط WP Cron شروع شد", "2025-07-24 06:38:17", "2025-07-24 06:38:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2251", "756", "عملیات توسط WP Cron کامل شد", "2025-07-24 06:38:17", "2025-07-24 06:38:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2252", "758", "ایجاد فعالیت", "2025-07-24 06:38:17", "2025-07-24 06:38:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2253", "757", "عملیات توسط WP Cron شروع شد", "2025-07-24 18:53:12", "2025-07-24 18:53:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2254", "757", "عملیات توسط WP Cron کامل شد", "2025-07-24 18:53:12", "2025-07-24 18:53:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2255", "759", "ایجاد فعالیت", "2025-07-24 18:53:12", "2025-07-24 18:53:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2256", "758", "عملیات توسط WP Cron شروع شد", "2025-07-24 18:53:12", "2025-07-24 18:53:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2257", "758", "عملیات توسط WP Cron کامل شد", "2025-07-24 18:53:12", "2025-07-24 18:53:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2258", "760", "ایجاد فعالیت", "2025-07-24 18:53:12", "2025-07-24 18:53:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2259", "760", "عملیات توسط WP Cron شروع شد", "2025-07-25 12:16:02", "2025-07-25 12:16:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("2260", "760", "عملیات توسط WP Cron کامل شد", "2025-07-25 12:16:02", "2025-07-25 12:16:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("2261", "761", "ایجاد فعالیت", "2025-07-25 12:16:02", "2025-07-25 12:16:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("2262", "759", "عملیات توسط WP Cron شروع شد", "2025-07-25 18:56:15", "2025-07-25 18:56:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2263", "759", "عملیات توسط WP Cron کامل شد", "2025-07-25 18:56:15", "2025-07-25 18:56:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2264", "762", "ایجاد فعالیت", "2025-07-25 18:56:15", "2025-07-25 18:56:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2265", "761", "عملیات توسط WP Cron شروع شد", "2025-07-26 06:24:39", "2025-07-26 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2266", "761", "عملیات توسط WP Cron کامل شد", "2025-07-26 06:24:39", "2025-07-26 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2267", "763", "ایجاد فعالیت", "2025-07-26 06:24:39", "2025-07-26 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2268", "763", "عملیات توسط WP Cron شروع شد", "2025-07-27 08:31:06", "2025-07-27 08:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("2269", "763", "عملیات توسط WP Cron کامل شد", "2025-07-27 08:31:06", "2025-07-27 08:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("2270", "764", "ایجاد فعالیت", "2025-07-27 08:31:06", "2025-07-27 08:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("2271", "762", "عملیات توسط WP Cron شروع شد", "2025-07-27 08:31:06", "2025-07-27 08:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("2272", "762", "عملیات توسط WP Cron کامل شد", "2025-07-27 08:31:06", "2025-07-27 08:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("2273", "765", "ایجاد فعالیت", "2025-07-27 08:31:06", "2025-07-27 08:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("2274", "764", "عملیات توسط WP Cron شروع شد", "2025-07-28 04:32:59", "2025-07-28 04:32:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2275", "764", "عملیات توسط WP Cron کامل شد", "2025-07-28 04:32:59", "2025-07-28 04:32:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2276", "766", "ایجاد فعالیت", "2025-07-28 04:32:59", "2025-07-28 04:32:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2277", "765", "عملیات توسط WP Cron شروع شد", "2025-07-28 09:36:17", "2025-07-28 09:36:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2278", "765", "عملیات توسط WP Cron کامل شد", "2025-07-28 09:36:17", "2025-07-28 09:36:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2279", "767", "ایجاد فعالیت", "2025-07-28 09:36:17", "2025-07-28 09:36:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2280", "766", "عملیات توسط WP Cron شروع شد", "2025-07-28 17:25:34", "2025-07-28 17:25:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2281", "766", "عملیات توسط WP Cron کامل شد", "2025-07-28 17:25:34", "2025-07-28 17:25:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2282", "768", "ایجاد فعالیت", "2025-07-28 17:25:34", "2025-07-28 17:25:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2283", "768", "عملیات توسط WP Cron شروع شد", "2025-07-29 08:43:42", "2025-07-29 08:43:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("2284", "768", "عملیات توسط WP Cron کامل شد", "2025-07-29 08:43:43", "2025-07-29 08:43:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2285", "769", "ایجاد فعالیت", "2025-07-29 08:43:43", "2025-07-29 08:43:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2286", "767", "عملیات توسط WP Cron شروع شد", "2025-07-29 15:31:18", "2025-07-29 15:31:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2287", "767", "عملیات توسط WP Cron کامل شد", "2025-07-29 15:31:18", "2025-07-29 15:31:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2288", "770", "ایجاد فعالیت", "2025-07-29 15:31:18", "2025-07-29 15:31:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2289", "769", "عملیات توسط WP Cron شروع شد", "2025-07-30 05:37:05", "2025-07-30 05:37:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2290", "769", "عملیات توسط WP Cron کامل شد", "2025-07-30 05:37:05", "2025-07-30 05:37:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2291", "771", "ایجاد فعالیت", "2025-07-30 05:37:05", "2025-07-30 05:37:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2292", "770", "عملیات توسط WP Cron شروع شد", "2025-07-30 18:30:35", "2025-07-30 18:30:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2293", "770", "عملیات توسط WP Cron کامل شد", "2025-07-30 18:30:35", "2025-07-30 18:30:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2294", "772", "ایجاد فعالیت", "2025-07-30 18:30:35", "2025-07-30 18:30:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2295", "771", "عملیات توسط WP Cron شروع شد", "2025-07-30 18:30:35", "2025-07-30 18:30:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2296", "771", "عملیات توسط WP Cron کامل شد", "2025-07-30 18:30:35", "2025-07-30 18:30:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2297", "773", "ایجاد فعالیت", "2025-07-30 18:30:35", "2025-07-30 18:30:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2298", "773", "عملیات توسط WP Cron شروع شد", "2025-07-31 08:49:59", "2025-07-31 08:49:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2299", "773", "عملیات توسط WP Cron کامل شد", "2025-07-31 08:49:59", "2025-07-31 08:49:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2300", "774", "ایجاد فعالیت", "2025-07-31 08:49:59", "2025-07-31 08:49:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2301", "772", "عملیات توسط WP Cron شروع شد", "2025-07-31 18:47:12", "2025-07-31 18:47:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2302", "772", "عملیات توسط WP Cron کامل شد", "2025-07-31 18:47:12", "2025-07-31 18:47:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2303", "775", "ایجاد فعالیت", "2025-07-31 18:47:12", "2025-07-31 18:47:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2304", "774", "عملیات توسط WP Cron شروع شد", "2025-08-01 08:27:47", "2025-08-01 08:27:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2305", "774", "عملیات توسط WP Cron کامل شد", "2025-08-01 08:27:47", "2025-08-01 08:27:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2306", "776", "ایجاد فعالیت", "2025-08-01 08:27:47", "2025-08-01 08:27:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2307", "775", "عملیات توسط WP Cron شروع شد", "2025-08-01 20:19:08", "2025-08-01 20:19:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2308", "775", "عملیات توسط WP Cron کامل شد", "2025-08-01 20:19:08", "2025-08-01 20:19:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2309", "777", "ایجاد فعالیت", "2025-08-01 20:19:08", "2025-08-01 20:19:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2310", "776", "عملیات توسط WP Cron شروع شد", "2025-08-01 22:35:19", "2025-08-01 22:35:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2311", "776", "عملیات توسط WP Cron کامل شد", "2025-08-01 22:35:19", "2025-08-01 22:35:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2312", "778", "ایجاد فعالیت", "2025-08-01 22:35:19", "2025-08-01 22:35:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2313", "778", "عملیات توسط WP Cron شروع شد", "2025-08-02 11:50:32", "2025-08-02 11:50:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2314", "778", "عملیات توسط WP Cron کامل شد", "2025-08-02 11:50:32", "2025-08-02 11:50:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2315", "779", "ایجاد فعالیت", "2025-08-02 11:50:32", "2025-08-02 11:50:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2316", "777", "عملیات توسط WP Cron شروع شد", "2025-08-02 20:29:28", "2025-08-02 20:29:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2317", "777", "عملیات توسط WP Cron کامل شد", "2025-08-02 20:29:28", "2025-08-02 20:29:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2318", "780", "ایجاد فعالیت", "2025-08-02 20:29:28", "2025-08-02 20:29:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2319", "779", "عملیات توسط WP Cron شروع شد", "2025-08-03 03:15:17", "2025-08-03 03:15:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2320", "779", "عملیات توسط WP Cron کامل شد", "2025-08-03 03:15:17", "2025-08-03 03:15:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2321", "781", "ایجاد فعالیت", "2025-08-03 03:15:17", "2025-08-03 03:15:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2322", "781", "عملیات توسط WP Cron شروع شد", "2025-08-03 21:46:37", "2025-08-03 21:46:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2323", "781", "عملیات توسط WP Cron کامل شد", "2025-08-03 21:46:37", "2025-08-03 21:46:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2324", "782", "ایجاد فعالیت", "2025-08-03 21:46:37", "2025-08-03 21:46:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2325", "780", "عملیات توسط WP Cron شروع شد", "2025-08-03 21:46:37", "2025-08-03 21:46:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2326", "780", "عملیات توسط WP Cron کامل شد", "2025-08-03 21:46:37", "2025-08-03 21:46:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2327", "783", "ایجاد فعالیت", "2025-08-03 21:46:37", "2025-08-03 21:46:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2328", "782", "عملیات توسط WP Cron شروع شد", "2025-08-04 10:15:37", "2025-08-04 10:15:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2329", "782", "عملیات توسط WP Cron کامل شد", "2025-08-04 10:15:37", "2025-08-04 10:15:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2330", "784", "ایجاد فعالیت", "2025-08-04 10:15:37", "2025-08-04 10:15:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2331", "783", "عملیات توسط WP Cron شروع شد", "2025-08-04 22:41:11", "2025-08-04 22:41:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2332", "783", "عملیات توسط WP Cron کامل شد", "2025-08-04 22:41:11", "2025-08-04 22:41:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2333", "785", "ایجاد فعالیت", "2025-08-04 22:41:11", "2025-08-04 22:41:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2334", "784", "عملیات توسط WP Cron شروع شد", "2025-08-04 22:41:11", "2025-08-04 22:41:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2335", "784", "عملیات توسط WP Cron کامل شد", "2025-08-04 22:41:11", "2025-08-04 22:41:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2336", "786", "ایجاد فعالیت", "2025-08-04 22:41:11", "2025-08-04 22:41:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2337", "786", "عملیات توسط WP Cron شروع شد", "2025-08-05 11:06:28", "2025-08-05 11:06:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2338", "786", "عملیات توسط WP Cron کامل شد", "2025-08-05 11:06:28", "2025-08-05 11:06:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2339", "787", "ایجاد فعالیت", "2025-08-05 11:06:28", "2025-08-05 11:06:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2340", "785", "عملیات توسط WP Cron شروع شد", "2025-08-06 02:18:12", "2025-08-06 02:18:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2341", "785", "عملیات توسط WP Cron کامل شد", "2025-08-06 02:18:12", "2025-08-06 02:18:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2342", "788", "ایجاد فعالیت", "2025-08-06 02:18:12", "2025-08-06 02:18:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2343", "787", "عملیات توسط WP Cron شروع شد", "2025-08-06 02:18:12", "2025-08-06 02:18:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2344", "787", "عملیات توسط WP Cron کامل شد", "2025-08-06 02:18:12", "2025-08-06 02:18:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2345", "789", "ایجاد فعالیت", "2025-08-06 02:18:12", "2025-08-06 02:18:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2346", "789", "عملیات توسط WP Cron شروع شد", "2025-08-06 15:23:11", "2025-08-06 15:23:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2347", "789", "عملیات توسط WP Cron کامل شد", "2025-08-06 15:23:11", "2025-08-06 15:23:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2348", "790", "ایجاد فعالیت", "2025-08-06 15:23:12", "2025-08-06 15:23:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2349", "788", "عملیات توسط WP Cron شروع شد", "2025-08-07 09:26:35", "2025-08-07 09:26:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2350", "788", "عملیات توسط WP Cron کامل شد", "2025-08-07 09:26:35", "2025-08-07 09:26:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2351", "791", "ایجاد فعالیت", "2025-08-07 09:26:35", "2025-08-07 09:26:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2352", "790", "عملیات توسط WP Cron شروع شد", "2025-08-07 09:26:35", "2025-08-07 09:26:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2353", "790", "عملیات توسط WP Cron کامل شد", "2025-08-07 09:26:35", "2025-08-07 09:26:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2354", "792", "ایجاد فعالیت", "2025-08-07 09:26:35", "2025-08-07 09:26:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2355", "792", "عملیات توسط WP Cron شروع شد", "2025-08-08 02:33:01", "2025-08-08 02:33:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2356", "792", "عملیات توسط WP Cron کامل شد", "2025-08-08 02:33:02", "2025-08-08 02:33:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("2357", "793", "ایجاد فعالیت", "2025-08-08 02:33:02", "2025-08-08 02:33:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("2358", "791", "عملیات توسط WP Cron شروع شد", "2025-08-08 09:50:58", "2025-08-08 09:50:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2359", "791", "عملیات توسط WP Cron کامل شد", "2025-08-08 09:50:58", "2025-08-08 09:50:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2360", "794", "ایجاد فعالیت", "2025-08-08 09:50:58", "2025-08-08 09:50:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2361", "793", "عملیات توسط WP Cron شروع شد", "2025-08-09 03:52:58", "2025-08-09 03:52:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2362", "793", "عملیات توسط WP Cron کامل شد", "2025-08-09 03:52:58", "2025-08-09 03:52:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2363", "795", "ایجاد فعالیت", "2025-08-09 03:52:58", "2025-08-09 03:52:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2364", "794", "عملیات توسط WP Cron شروع شد", "2025-08-09 10:51:10", "2025-08-09 10:51:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2365", "794", "عملیات توسط WP Cron کامل شد", "2025-08-09 10:51:10", "2025-08-09 10:51:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2366", "796", "ایجاد فعالیت", "2025-08-09 10:51:10", "2025-08-09 10:51:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2367", "795", "عملیات توسط WP Cron شروع شد", "2025-08-09 16:05:51", "2025-08-09 16:05:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2368", "795", "عملیات توسط WP Cron کامل شد", "2025-08-09 16:05:51", "2025-08-09 16:05:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2369", "797", "ایجاد فعالیت", "2025-08-09 16:05:51", "2025-08-09 16:05:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2370", "797", "عملیات توسط WP Cron شروع شد", "2025-08-10 08:01:29", "2025-08-10 08:01:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2371", "797", "عملیات توسط WP Cron کامل شد", "2025-08-10 08:01:29", "2025-08-10 08:01:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2372", "798", "ایجاد فعالیت", "2025-08-10 08:01:29", "2025-08-10 08:01:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2373", "796", "عملیات توسط WP Cron شروع شد", "2025-08-10 13:09:51", "2025-08-10 13:09:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2374", "796", "عملیات توسط WP Cron کامل شد", "2025-08-10 13:09:51", "2025-08-10 13:09:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2375", "799", "ایجاد فعالیت", "2025-08-10 13:09:51", "2025-08-10 13:09:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2376", "798", "عملیات توسط WP Cron شروع شد", "2025-08-10 21:16:31", "2025-08-10 21:16:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2377", "798", "عملیات توسط WP Cron کامل شد", "2025-08-10 21:16:31", "2025-08-10 21:16:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2378", "800", "ایجاد فعالیت", "2025-08-10 21:16:31", "2025-08-10 21:16:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2379", "800", "عملیات توسط WP Cron شروع شد", "2025-08-11 09:40:10", "2025-08-11 09:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2380", "800", "عملیات توسط WP Cron کامل شد", "2025-08-11 09:40:10", "2025-08-11 09:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2381", "801", "ایجاد فعالیت", "2025-08-11 09:40:10", "2025-08-11 09:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2382", "799", "عملیات توسط WP Cron شروع شد", "2025-08-11 13:36:21", "2025-08-11 13:36:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2383", "799", "عملیات توسط WP Cron کامل شد", "2025-08-11 13:36:21", "2025-08-11 13:36:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2384", "802", "ایجاد فعالیت", "2025-08-11 13:36:21", "2025-08-11 13:36:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2385", "801", "عملیات توسط WP Cron شروع شد", "2025-08-12 08:49:31", "2025-08-12 08:49:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2386", "801", "عملیات توسط WP Cron کامل شد", "2025-08-12 08:49:31", "2025-08-12 08:49:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2387", "803", "ایجاد فعالیت", "2025-08-12 08:49:31", "2025-08-12 08:49:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2388", "802", "عملیات توسط WP Cron شروع شد", "2025-08-12 15:30:48", "2025-08-12 15:30:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2389", "802", "عملیات توسط WP Cron کامل شد", "2025-08-12 15:30:48", "2025-08-12 15:30:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2390", "804", "ایجاد فعالیت", "2025-08-12 15:30:48", "2025-08-12 15:30:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2391", "803", "عملیات توسط WP Cron شروع شد", "2025-08-12 21:49:11", "2025-08-12 21:49:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2392", "803", "عملیات توسط WP Cron کامل شد", "2025-08-12 21:49:11", "2025-08-12 21:49:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2393", "805", "ایجاد فعالیت", "2025-08-12 21:49:11", "2025-08-12 21:49:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2394", "805", "عملیات توسط WP Cron شروع شد", "2025-08-13 10:16:38", "2025-08-13 10:16:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2395", "805", "عملیات توسط WP Cron کامل شد", "2025-08-13 10:16:38", "2025-08-13 10:16:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2396", "806", "ایجاد فعالیت", "2025-08-13 10:16:38", "2025-08-13 10:16:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2397", "804", "عملیات توسط WP Cron شروع شد", "2025-08-13 20:27:47", "2025-08-13 20:27:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2398", "804", "عملیات توسط WP Cron کامل شد", "2025-08-13 20:27:47", "2025-08-13 20:27:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2399", "807", "ایجاد فعالیت", "2025-08-13 20:27:47", "2025-08-13 20:27:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2400", "806", "عملیات توسط WP Cron شروع شد", "2025-08-14 00:16:26", "2025-08-14 00:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2401", "806", "عملیات توسط WP Cron کامل شد", "2025-08-14 00:16:26", "2025-08-14 00:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2402", "808", "ایجاد فعالیت", "2025-08-14 00:16:26", "2025-08-14 00:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2403", "808", "عملیات توسط WP Cron شروع شد", "2025-08-14 13:57:24", "2025-08-14 13:57:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2404", "808", "عملیات توسط WP Cron کامل شد", "2025-08-14 13:57:24", "2025-08-14 13:57:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2405", "809", "ایجاد فعالیت", "2025-08-14 13:57:24", "2025-08-14 13:57:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2406", "807", "عملیات توسط WP Cron شروع شد", "2025-08-14 21:42:04", "2025-08-14 21:42:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2407", "807", "عملیات توسط WP Cron کامل شد", "2025-08-14 21:42:04", "2025-08-14 21:42:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2408", "810", "ایجاد فعالیت", "2025-08-14 21:42:04", "2025-08-14 21:42:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2409", "809", "عملیات توسط WP Cron شروع شد", "2025-08-15 06:25:59", "2025-08-15 06:25:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2410", "809", "عملیات توسط WP Cron کامل شد", "2025-08-15 06:25:59", "2025-08-15 06:25:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2411", "811", "ایجاد فعالیت", "2025-08-15 06:25:59", "2025-08-15 06:25:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2412", "811", "عملیات توسط WP Cron شروع شد", "2025-08-15 19:02:48", "2025-08-15 19:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2413", "811", "عملیات توسط WP Cron کامل شد", "2025-08-15 19:02:48", "2025-08-15 19:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2414", "812", "ایجاد فعالیت", "2025-08-15 19:02:48", "2025-08-15 19:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2415", "810", "عملیات توسط WP Cron شروع شد", "2025-08-15 22:35:40", "2025-08-15 22:35:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2416", "810", "عملیات توسط WP Cron کامل شد", "2025-08-15 22:35:40", "2025-08-15 22:35:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2417", "813", "ایجاد فعالیت", "2025-08-15 22:35:40", "2025-08-15 22:35:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2418", "812", "عملیات توسط WP Cron شروع شد", "2025-08-16 07:20:45", "2025-08-16 07:20:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2419", "812", "عملیات توسط WP Cron کامل شد", "2025-08-16 07:20:45", "2025-08-16 07:20:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2420", "814", "ایجاد فعالیت", "2025-08-16 07:20:45", "2025-08-16 07:20:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2421", "814", "عملیات توسط WP Cron شروع شد", "2025-08-17 04:15:57", "2025-08-17 04:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2422", "814", "عملیات توسط WP Cron کامل شد", "2025-08-17 04:15:57", "2025-08-17 04:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2423", "815", "ایجاد فعالیت", "2025-08-17 04:15:57", "2025-08-17 04:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2424", "813", "عملیات توسط WP Cron شروع شد", "2025-08-17 04:15:57", "2025-08-17 04:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2425", "813", "عملیات توسط WP Cron کامل شد", "2025-08-17 04:15:57", "2025-08-17 04:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2426", "816", "ایجاد فعالیت", "2025-08-17 04:15:57", "2025-08-17 04:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2427", "815", "عملیات توسط WP Cron شروع شد", "2025-08-17 17:18:40", "2025-08-17 17:18:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2428", "815", "عملیات توسط WP Cron کامل شد", "2025-08-17 17:18:40", "2025-08-17 17:18:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2429", "817", "ایجاد فعالیت", "2025-08-17 17:18:40", "2025-08-17 17:18:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2430", "816", "عملیات توسط WP Cron شروع شد", "2025-08-18 06:03:30", "2025-08-18 06:03:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2431", "816", "عملیات توسط WP Cron کامل شد", "2025-08-18 06:03:30", "2025-08-18 06:03:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2432", "818", "ایجاد فعالیت", "2025-08-18 06:03:31", "2025-08-18 06:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2433", "817", "عملیات توسط WP Cron شروع شد", "2025-08-18 06:03:31", "2025-08-18 06:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2434", "817", "عملیات توسط WP Cron کامل شد", "2025-08-18 06:03:31", "2025-08-18 06:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2435", "819", "ایجاد فعالیت", "2025-08-18 06:03:31", "2025-08-18 06:03:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2436", "820", "ایجاد فعالیت", "2025-08-18 11:06:55", "2025-08-18 11:06:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2437", "821", "ایجاد فعالیت", "2025-08-18 11:07:17", "2025-08-18 11:07:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2438", "820", "عملیات توسط WP Cron شروع شد", "2025-08-18 11:07:17", "2025-08-18 11:07:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2439", "820", "عملیات توسط WP Cron کامل شد", "2025-08-18 11:07:17", "2025-08-18 11:07:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2440", "821", "عملیات توسط WP Cron شروع شد", "2025-08-18 11:07:17", "2025-08-18 11:07:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2441", "821", "عملیات توسط WP Cron کامل شد", "2025-08-18 11:07:18", "2025-08-18 11:07:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2442", "822", "ایجاد فعالیت", "2025-08-18 11:28:18", "2025-08-18 11:28:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2443", "822", "عملیات توسط WP Cron شروع شد", "2025-08-18 11:28:19", "2025-08-18 11:28:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2444", "822", "عملیات توسط WP Cron کامل شد", "2025-08-18 11:28:19", "2025-08-18 11:28:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2445", "823", "ایجاد فعالیت", "2025-08-18 11:28:19", "2025-08-18 11:28:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2446", "824", "ایجاد فعالیت", "2025-08-18 11:35:52", "2025-08-18 11:35:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2447", "825", "ایجاد فعالیت", "2025-08-18 11:35:52", "2025-08-18 11:35:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2448", "824", "عملیات توسط WP Cron شروع شد", "2025-08-18 11:36:52", "2025-08-18 11:36:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2449", "824", "عملیات توسط WP Cron کامل شد", "2025-08-18 11:36:52", "2025-08-18 11:36:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2450", "825", "عملیات توسط WP Cron شروع شد", "2025-08-18 11:36:52", "2025-08-18 11:36:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2451", "825", "عملیات توسط WP Cron کامل شد", "2025-08-18 11:36:52", "2025-08-18 11:36:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2452", "826", "ایجاد فعالیت", "2025-08-18 11:36:52", "2025-08-18 11:36:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2453", "827", "ایجاد فعالیت", "2025-08-18 11:36:56", "2025-08-18 11:36:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2454", "827", "عملیات توسط Async Request شروع شد", "2025-08-18 11:36:58", "2025-08-18 11:36:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2455", "827", "عملیات توسط Async Request کامل شد", "2025-08-18 11:36:58", "2025-08-18 11:36:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2456", "828", "ایجاد فعالیت", "2025-08-18 11:36:59", "2025-08-18 11:36:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2457", "828", "عملیات توسط Async Request شروع شد", "2025-08-18 11:37:04", "2025-08-18 11:37:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2458", "828", "عملیات توسط Async Request کامل شد", "2025-08-18 11:37:04", "2025-08-18 11:37:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2459", "829", "ایجاد فعالیت", "2025-08-18 11:37:20", "2025-08-18 11:37:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2460", "829", "عملیات توسط WP Cron شروع شد", "2025-08-18 11:38:54", "2025-08-18 11:38:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("2461", "829", "عملیات توسط WP Cron کامل شد", "2025-08-18 11:38:54", "2025-08-18 11:38:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("2462", "830", "ایجاد فعالیت", "2025-08-18 11:39:31", "2025-08-18 11:39:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2463", "830", "عملیات توسط Async Request شروع شد", "2025-08-18 11:40:34", "2025-08-18 11:40:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2464", "830", "عملیات توسط Async Request کامل شد", "2025-08-18 11:40:34", "2025-08-18 11:40:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2465", "826", "عملیات توسط WP Cron شروع شد", "2025-08-18 11:41:58", "2025-08-18 11:41:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2466", "826", "اقدام از طریق WP Cron انجام نشد: اقدام زمان‌بندی‌شده برای image-optimization/cleanup/stuck-operation اجرا نخواهد شد زیرا هیچ فراخوانی برگشتی ثبت نشده است.", "2025-08-18 11:41:58", "2025-08-18 11:41:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2467", "831", "ایجاد فعالیت", "2025-08-18 11:41:58", "2025-08-18 11:41:58");

/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("1", "2", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("2", "2", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("3", "2", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("4", "2", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("5", "2", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("6", "3", "rating", "4");
INSERT INTO `wp_commentmeta` VALUES("7", "3", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("8", "3", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("9", "3", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("10", "3", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("11", "4", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("12", "4", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("13", "4", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("14", "4", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("15", "4", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("21", "6", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("22", "6", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("23", "6", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("24", "6", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("25", "6", "wd_total_vote", "0");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("2", "498", "Mr. Mackay", "zak@asda.as", "", "176.98.71.57", "2023-06-05 12:45:38", "2023-06-05 12:45:38", "If that’s what you think how bout the other way around? How can you evaluate content without design? No typography, no colors, no layout, no styles, all those things that convey the important signals that go beyond the mere textual, hierarchies of information, weight, emphasis, oblique stresses, priorities, all those subtle cues that also have visual and emotional appeal to the reader.", "0", "1", "", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("3", "371", "Mr. Mackay", "zak@asda.as", "", "176.98.71.57", "2023-06-05 12:45:43", "2023-06-05 12:45:43", "If that’s what you think how bout the other way around? How can you evaluate content without design? No typography, no colors, no layout, no styles, all those things that convey the important signals that go beyond the mere textual, hierarchies of information, weight, emphasis, oblique stresses, priorities, all those subtle cues that also have visual and emotional appeal to the reader.", "0", "1", "", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("4", "380", "Mr. Mackay", "zak@asda.as", "", "176.98.71.57", "2023-06-05 12:45:49", "2023-06-05 12:45:49", "If that’s what you think how bout the other way around? How can you evaluate content without design? No typography, no colors, no layout, no styles, all those things that convey the important signals that go beyond the mere textual, hierarchies of information, weight, emphasis, oblique stresses, priorities, all those subtle cues that also have visual and emotional appeal to the reader.", "0", "1", "", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("6", "421", "سیسی", "admin@gmail.com", "", "5.126.50.119", "2024-11-14 10:12:27", "2024-11-14 11:12:27", "سلام", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36", "review", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("4", "furniture2", "995c1815e414745b3436_20250818114248", "20", "2025-08-18 11:43:01", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-08-18 11:42:48\";s:7:\"Version\";s:8:\"1.5.13.1\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:6:\"8.0.35\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:4;s:4:\"Name\";s:10:\"furniture2\";s:4:\"Hash\";s:35:\"995c1815e414745b3436_20250818114248\";s:8:\"NameHash\";s:46:\"furniture2_995c1815e414745b3436_20250818114248\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:56:\"furniture2_995c1815e414745b3436_20250818114248_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.9\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:58:\"furniture2_995c1815e414745b3436_20250818114248_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:37:\"/home/demoiran/public_html/furniture2\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2838;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:16172;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-08-18 11:42:48\";s:7:\"Version\";s:8:\"1.5.13.1\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:6:\"8.0.35\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:10:\"furniture2\";s:4:\"Hash\";s:35:\"995c1815e414745b3436_20250818114248\";s:8:\"NameHash\";s:46:\"furniture2_995c1815e414745b3436_20250818114248\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:64:\"furniture2_995c1815e414745b3436_20250818114248_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:51:\"/home/demoiran/public_html/furniture2/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:59:\"furniture2_995c1815e414745b3436_20250818114248_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:129:\"/home/demoiran/public_html/furniture2/wp-content/backups-dup-lite/tmp/furniture2_995c1815e414745b3436_20250818114248_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:46:\"/home/demoiran/public_html/furniture2/wp-admin\";i:1;s:49:\"/home/demoiran/public_html/furniture2/wp-includes\";i:2;s:58:\"/home/demoiran/public_html/furniture2/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:37:\"/home/demoiran/public_html/furniture2\";i:1;s:37:\"/home/demoiran/public_html/furniture2\";i:2;s:48:\"/home/demoiran/public_html/furniture2/wp-content\";i:3;s:56:\"/home/demoiran/public_html/furniture2/wp-content/uploads\";i:4;s:56:\"/home/demoiran/public_html/furniture2/wp-content/plugins\";i:5;s:59:\"/home/demoiran/public_html/furniture2/wp-content/mu-plugins\";i:6;s:55:\"/home/demoiran/public_html/furniture2/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:69:\"/home/demoiran/public_html/furniture2/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://demo.iran-woodmart.ir/furniture2/", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://demo.iran-woodmart.ir/furniture2/", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "دمو مبلمان 2 ایران وودمارت", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "info@iran-woodmart.ir", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:348:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:12:\"portfolio/?$\";s:29:\"index.php?post_type=portfolio\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:15:\"^checkout-link$\";s:28:\"index.php?checkout-link=true\";s:31:\"^wishlist/([^/]*)/page/([^/]*)?\";s:62:\"index.php?page_id=21&wishlist_id=$matches[1]&paged=$matches[2]\";s:23:\"^wishlist/page/([^/]*)?\";s:38:\"index.php?page_id=21&paged=$matches[1]\";s:19:\"^wishlist/([^/]*)/?\";s:44:\"index.php?page_id=21&wishlist_id=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:43:\"woodmart_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_layout/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_layout=$matches[1]&embed=true\";s:36:\"woodmart_layout/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_layout=$matches[1]&tb=1\";s:44:\"woodmart_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&cpage=$matches[2]\";s:52:\"woodmart_layout/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?woodmart_layout=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"woodmart_layout/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_layout=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"woodmart_layout/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"woodmart_layout/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_layout=$matches[1]&page=$matches[2]\";s:32:\"woodmart_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_woo_lv/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_woo_lv=$matches[1]&embed=true\";s:36:\"woodmart_woo_lv/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_woo_lv=$matches[1]&tb=1\";s:44:\"woodmart_woo_lv/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_woo_lv=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_woo_lv/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_woo_lv=$matches[1]&cpage=$matches[2]\";s:52:\"woodmart_woo_lv/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?woodmart_woo_lv=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"woodmart_woo_lv/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_woo_lv=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_woo_lv/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"woodmart_woo_lv/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"woodmart_woo_lv/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_woo_lv=$matches[1]&page=$matches[2]\";s:32:\"woodmart_woo_lv/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_woo_lv/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_woo_lv/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_woo_lv/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_woo_lv/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_woo_lv/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"woodmart_woo_fbt/([^/]+)/embed/?$\";s:49:\"index.php?woodmart_woo_fbt=$matches[1]&embed=true\";s:37:\"woodmart_woo_fbt/([^/]+)/trackback/?$\";s:43:\"index.php?woodmart_woo_fbt=$matches[1]&tb=1\";s:45:\"woodmart_woo_fbt/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&paged=$matches[2]\";s:52:\"woodmart_woo_fbt/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&cpage=$matches[2]\";s:53:\"woodmart_woo_fbt/([^/]+)/wc/file/transient(/(.*))?/?$\";s:68:\"index.php?woodmart_woo_fbt=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"woodmart_woo_fbt/([^/]+)/wc-api(/(.*))?/?$\";s:57:\"index.php?woodmart_woo_fbt=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:70:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:48:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:41:\"woodmart_woo_fbt/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?woodmart_woo_fbt=$matches[1]&page=$matches[2]\";s:33:\"woodmart_woo_fbt/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"woodmart_woo_fbt/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"woodmart_woo_fbt/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"woodmart_woo_fbt/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"cms_block_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:49:\"cms_block_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:30:\"cms_block_cat/([^/]+)/embed/?$\";s:46:\"index.php?cms_block_cat=$matches[1]&embed=true\";s:42:\"cms_block_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?cms_block_cat=$matches[1]&paged=$matches[2]\";s:24:\"cms_block_cat/([^/]+)/?$\";s:35:\"index.php?cms_block_cat=$matches[1]\";s:42:\"woodmart_slide/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"woodmart_slide/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"woodmart_slide/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"woodmart_slide/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"woodmart_slide/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"woodmart_slide/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"woodmart_slide/([^/]+)/embed/?$\";s:47:\"index.php?woodmart_slide=$matches[1]&embed=true\";s:35:\"woodmart_slide/([^/]+)/trackback/?$\";s:41:\"index.php?woodmart_slide=$matches[1]&tb=1\";s:43:\"woodmart_slide/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?woodmart_slide=$matches[1]&paged=$matches[2]\";s:50:\"woodmart_slide/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?woodmart_slide=$matches[1]&cpage=$matches[2]\";s:51:\"woodmart_slide/([^/]+)/wc/file/transient(/(.*))?/?$\";s:66:\"index.php?woodmart_slide=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"woodmart_slide/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?woodmart_slide=$matches[1]&wc-api=$matches[3]\";s:57:\"woodmart_slide/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:68:\"woodmart_slide/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:46:\"woodmart_slide/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"woodmart_slide/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:39:\"woodmart_slide/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?woodmart_slide=$matches[1]&page=$matches[2]\";s:31:\"woodmart_slide/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"woodmart_slide/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"woodmart_slide/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"woodmart_slide/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"woodmart_slide/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"woodmart_slide/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"woodmart_slider/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&feed=$matches[2]\";s:51:\"woodmart_slider/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&feed=$matches[2]\";s:32:\"woodmart_slider/([^/]+)/embed/?$\";s:62:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&embed=true\";s:44:\"woodmart_slider/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&paged=$matches[2]\";s:26:\"woodmart_slider/([^/]+)/?$\";s:51:\"index.php?taxonomy=woodmart_slider&term=$matches[1]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:50:\"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:45:\"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:46:\"portfolio/([^/]+)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?portfolio=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"portfolio/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?portfolio=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:63:\"portfolio/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"portfolio/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:50:\"project-cat/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project-cat=$matches[1]&feed=$matches[2]\";s:45:\"project-cat/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project-cat=$matches[1]&feed=$matches[2]\";s:26:\"project-cat/(.+?)/embed/?$\";s:44:\"index.php?project-cat=$matches[1]&embed=true\";s:38:\"project-cat/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project-cat=$matches[1]&paged=$matches[2]\";s:20:\"project-cat/(.+?)/?$\";s:33:\"index.php?project-cat=$matches[1]\";s:47:\"برند/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:42:\"برند/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:23:\"برند/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:35:\"برند/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:17:\"برند/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"mc4wp-form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"mc4wp-form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"mc4wp-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"mc4wp-form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"mc4wp-form/([^/]+)/embed/?$\";s:43:\"index.php?mc4wp-form=$matches[1]&embed=true\";s:31:\"mc4wp-form/([^/]+)/trackback/?$\";s:37:\"index.php?mc4wp-form=$matches[1]&tb=1\";s:39:\"mc4wp-form/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&paged=$matches[2]\";s:46:\"mc4wp-form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&cpage=$matches[2]\";s:47:\"mc4wp-form/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?mc4wp-form=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"mc4wp-form/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?mc4wp-form=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:64:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"mc4wp-form/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"mc4wp-form/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?mc4wp-form=$matches[1]&page=$matches[2]\";s:27:\"mc4wp-form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"mc4wp-form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"mc4wp-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"mc4wp-form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=15&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:27:\"(.?.+?)/waitlist(/(.*))?/?$\";s:51:\"index.php?pagename=$matches[1]&waitlist=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:6:{i:0;s:36:\"contact-form-7/wp-contact-form-7.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:23:\"elementor/elementor.php\";i:3;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:4;s:27:\"woocommerce/woocommerce.php\";i:5;s:31:\"woodmart-core/woodmart-core.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("40", "template", "woodmart", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "woodmart-child", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "60421", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "0", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:1:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "Atlantic/Azores", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "18", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "15", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1768300655", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "53496", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:115:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:16:\"create_customers\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:93:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:16:\"create_customers\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("102", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("103", "user_count", "6", "off");
INSERT INTO `wp_options` VALUES("104", "widget_block", "a:7:{i:2;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:3;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;i:1;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}}", "yes");
INSERT INTO `wp_options` VALUES("105", "sidebars_widgets", "a:15:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:7:\"block-6\";}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-1\";i:1;s:7:\"block-2\";i:2;s:7:\"block-3\";i:3;s:7:\"block-4\";i:4;s:7:\"block-5\";}s:22:\"portfolio-widgets-area\";a:0:{}s:12:\"sidebar-shop\";a:5:{i:0;s:26:\"woocommerce_price_filter-6\";i:1;s:34:\"woodmart-woocommerce-layered-nav-7\";i:2;s:34:\"woodmart-woocommerce-layered-nav-8\";i:3;s:34:\"woodmart-woocommerce-layered-nav-9\";i:4;s:25:\"wd-widget-stock-status-10\";}s:12:\"filters-area\";a:0:{}s:22:\"sidebar-product-single\";a:0:{}s:18:\"sidebar-my-account\";a:0:{}s:24:\"sidebar-full-screen-menu\";a:0:{}s:19:\"mobile-menu-widgets\";a:0:{}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:0:{}s:8:\"footer-3\";a:0:{}s:8:\"footer-4\";a:0:{}s:8:\"footer-5\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("106", "cron", "a:18:{i:1755517428;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1755519751;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1755519891;a:3:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:40:\"woodmart_wishlist_send_promotional_email\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1755519909;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1755534151;a:4:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1755534167;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1755534170;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1755534225;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1755534288;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1755534291;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1755541716;a:1:{s:37:\"puc_cron_check_updates_theme-woodmart\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1755560152;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1755561600;a:1:{s:22:\"wdev_logger_clear_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1755707007;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1755793351;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1756007582;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1756130400;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("122", "theme_mods_twentytwentythree", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1694017387;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "no");
INSERT INTO `wp_options` VALUES("123", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("124", "https_detection_errors", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("140", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("152", "current_theme", "Woodmart Child", "yes");
INSERT INTO `wp_options` VALUES("153", "theme_mods_woodmart-child", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:9:\"main-menu\";s:2:\"66\";s:11:\"mobile-menu\";s:2:\"67\";}s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO `wp_options` VALUES("154", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("155", "woodmart_token", "1", "yes");
INSERT INTO `wp_options` VALUES("156", "woodmart_is_activated", "1", "yes");
INSERT INTO `wp_options` VALUES("157", "woodmart_purchase_code", "********************************", "yes");
INSERT INTO `wp_options` VALUES("158", "woodmart-generated-wpbcss-file", "", "yes");
INSERT INTO `wp_options` VALUES("160", "xts-options-presets", "a:1:{i:2;a:4:{s:2:\"id\";i:2;s:4:\"name\";s:20:\"Checkout Furniture 2\";s:9:\"condition\";a:2:{s:8:\"relation\";s:2:\"OR\";s:5:\"rules\";a:1:{i:0;a:7:{s:4:\"type\";s:7:\"post_id\";s:10:\"comparison\";s:6:\"equals\";s:9:\"post_type\";s:4:\"post\";s:8:\"taxonomy\";s:8:\"category\";s:6:\"custom\";s:6:\"search\";s:8:\"value_id\";s:2:\"10\";s:9:\"user_role\";s:13:\"administrator\";}}}s:8:\"priority\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("161", "xts-woodmart-options", "a:800:{s:12:\"last_message\";s:4:\"save\";s:14:\"default_header\";s:13:\"header_937146\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:157:\"<h4 class=\"text-center\">Are you over 18?</h4>\r\n<p class=\"text-center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:120:\"<h4 class=\"text-center\">Access forbidden</h4>\r\n<p class=\"text-center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"1\";s:24:\"promo_popup_content_type\";s:10:\"html_block\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:4:\"1388\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:15:\"rgb(245,154,87)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:5:\"light\";s:11:\"popup_width\";s:3:\"480\";s:13:\"popup_padding\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:116:\"We use cookies to improve your experience on our website. By browsing this website, you agree to our use of cookies.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"0\";s:18:\"header_banner_link\";s:0:\"\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:0:\"\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"40\";s:27:\"header_banner_mobile_height\";s:2:\"40\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:13:\"search_by_sku\";s:1:\"1\";s:17:\"relevanssi_search\";s:1:\"0\";s:16:\"popular_requests\";s:0:\"\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:23:\"ajax_fullscreen_content\";s:1:\"1\";s:10:\"site_width\";s:6:\"custom\";s:17:\"site_custom_width\";s:4:\"1400\";s:11:\"main_layout\";s:13:\"sidebar-right\";s:13:\"sidebar_width\";s:1:\"3\";s:17:\"hide_main_sidebar\";s:1:\"0\";s:24:\"hide_main_sidebar_tablet\";s:1:\"1\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:11:\"insta_token\";s:0:\"\";s:28:\"insta_delete_outdated_images\";s:1:\"0\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:5:\"after\";s:14:\"products_hover\";s:16:\"buttons-on-hover\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"0\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:1:\"1\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:16:\"rgb(255,255,255)\";}s:15:\"products_shadow\";s:1:\"0\";s:23:\"stretch_product_desktop\";s:1:\"1\";s:22:\"stretch_product_tablet\";s:1:\"1\";s:22:\"stretch_product_mobile\";s:1:\"1\";s:25:\"product_title_lines_limit\";s:4:\"none\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";s:1:\"1\";s:20:\"grid_gallery_control\";s:6:\"arrows\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:27:\"show_stock_quantity_on_grid\";s:1:\"0\";s:23:\"grid_stock_progress_bar\";s:1:\"0\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"1\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:18:\"show_reviews_count\";s:1:\"0\";s:17:\"categories_design\";s:8:\"zoom-out\";s:19:\"categories_rounding\";s:6:\"custom\";s:31:\"custom_categories_rounding_size\";s:68:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidW5pdCI6IiUiLCJ2YWx1ZSI6IjUwIn19fQ==\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_subcategories\";s:1:\"0\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"0\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:24:\"mobile_categories_layout\";s:9:\"accordion\";s:29:\"mobile_categories_menu_layout\";s:8:\"dropdown\";s:37:\"mobile_categories_drilldown_animation\";s:5:\"slide\";s:40:\"mobile_categories_submenu_opening_action\";s:10:\"only_arrow\";s:26:\"mobile_categories_position\";s:4:\"left\";s:30:\"mobile_categories_color_scheme\";s:7:\"default\";s:27:\"mobile_categories_close_btn\";s:1:\"0\";s:9:\"shop_view\";s:9:\"grid_list\";s:16:\"products_columns\";s:1:\"3\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:23:\"products_spacing_tablet\";s:0:\"\";s:23:\"products_spacing_mobile\";s:0:\"\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:2:{i:0;s:1:\"3\";i:1;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"12\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:10:\"9,12,18,24\";s:15:\"shop_pagination\";s:10:\"pagination\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"223\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_columns\";s:0:\"\";s:27:\"shop_filters_columns_tablet\";s:4:\"auto\";s:27:\"shop_filters_columns_mobile\";s:4:\"auto\";s:20:\"shop_filters_spacing\";s:2:\"30\";s:27:\"shop_filters_spacing_tablet\";s:0:\"\";s:27:\"shop_filters_spacing_mobile\";s:0:\"\";s:12:\"hide_sort_by\";s:1:\"0\";s:17:\"hide_price_filter\";s:1:\"0\";s:20:\"shop_filters_content\";s:0:\"\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:17:\"page-title-design\";s:7:\"default\";s:15:\"page-title-size\";s:5:\"large\";s:16:\"title-background\";a:7:{s:5:\"color\";s:16:\"rgb(174,182,161)\";s:3:\"url\";s:91:\"https://demo.iran-woodmart.ir/furniture2/wp-content/uploads/2023/04/wd-furniture-pt-def.jpg\";s:2:\"id\";s:3:\"137\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:10:\"center top\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:10:\"html_block\";s:13:\"footer-layout\";s:2:\"13\";s:17:\"footer_html_block\";s:3:\"688\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:13:\"rgb(15,15,15)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:5:\"light\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"1\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"1\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:67:\"طراحی و توسعه توسط  تیم ایران وودمارت\";s:11:\"copyrights2\";s:114:\"<img src=\"https://iran-woodmart.ir/demo/furniture2/wp-content/themes/woodmart/images/payments.png\" alt=\"payments\">\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#777777\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:19:\"rgb(51 51 51 / 65%)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"16\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:4:\"#333\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:10:\"capitalize\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:5:{i:0;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:23:\"mobile_menu_first_level\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:10:\"capitalize\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}i:1;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:27:\"secondary_navigation_topbar\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"13\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}i:2;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"800\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}i:3;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:10:\"blog_title\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"18\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:3:{i:0;a:4:{s:9:\"font-name\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:97:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/09/IRANYekanXFaNum-Regular.woff2\";s:2:\"id\";s:4:\"1427\";}}i:1;a:4:{s:9:\"font-name\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:99:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/09/IRANYekanXFaNum-ExtraBold.woff2\";s:2:\"id\";s:4:\"1428\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"2\";s:6:\"weight\";s:3:\"400\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:6:\"custom\";s:20:\"custom_rounding_size\";s:68:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidW5pdCI6InB4IiwidmFsdWUiOiIxMCJ9fX0=\";s:12:\"dark_version\";s:1:\"0\";s:13:\"primary-color\";a:1:{s:4:\"idle\";s:15:\"rgb(245,154,87)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:16:\"rgb(224,234,240)\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:7:\"#242424\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://demo.iran-woodmart.ir/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://demo.iran-woodmart.ir/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://demo.iran-woodmart.ir/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://demo.iran-woodmart.ir/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://demo.iran-woodmart.ir/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:7:\"rounded\";s:23:\"btns_default_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:7:\"#f7f7f7\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:7:\"#efefef\";}s:25:\"btns_default_color_scheme\";s:4:\"dark\";s:31:\"btns_default_color_scheme_hover\";s:4:\"dark\";s:32:\"btns_default_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"btns_default_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"btns_shop_style\";s:7:\"rounded\";s:20:\"btns_shop_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:15:\"rgb(245,154,87)\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:15:\"rgb(223,140,79)\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:35:\"btns_shop_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"advanced_typography_button\";a:3:{i:0;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:11:\"all_buttons\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}i:1;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:14:\"single_buy_now\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:16:\"rgb(255,255,255)\";s:5:\"hover\";a:2:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:10:\"background\";s:13:\"rgb(51,51,51)\";}s:10:\"background\";s:18:\"rgba(16,16,16,0.9)\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:7:\"rounded\";s:17:\"form_border_width\";s:1:\"1\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:16:\"rgb(119,119,119)\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:17:\"rgb(119,119,119)7\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:16:\"rgb(255,255,255)\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:24:\"carousel_arrows_position\";s:3:\"sep\";s:25:\"carousel_arrows_icon_type\";s:1:\"1\";s:27:\"carousel_arrows_hover_style\";s:1:\"1\";s:24:\"carousel_arrows_sep_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:29:\"carousel_arrows_sep_icon_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:28:\"carousel_arrows_sep_offset_h\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:28:\"carousel_arrows_sep_offset_v\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:25:\"carousel_arrows_sep_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:31:\"carousel_arrows_sep_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:29:\"carousel_arrows_sep_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:28:\"carousel_arrows_sep_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_arrows_sep_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:32:\"carousel_arrows_sep_bg_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_arrows_sep_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:32:\"carousel_arrows_sep_border_style\";s:0:\"\";s:32:\"carousel_arrows_sep_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:32:\"carousel_arrows_sep_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_arrows_sep_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_sep_border_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_sep_box_shadow_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:39:\"carousel_arrows_sep_box_shadow_offset_x\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:39:\"carousel_arrows_sep_box_shadow_offset_y\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:35:\"carousel_arrows_sep_box_shadow_blur\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_sep_box_shadow_spread\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:28:\"carousel_arrows_together_gap\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:29:\"carousel_arrows_together_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:34:\"carousel_arrows_together_icon_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:33:\"carousel_arrows_together_offset_h\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:33:\"carousel_arrows_together_offset_v\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:30:\"carousel_arrows_together_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_together_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_arrows_together_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_arrows_together_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:39:\"carousel_arrows_together_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:37:\"carousel_arrows_together_bg_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_arrows_together_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_together_border_style\";s:0:\"\";s:37:\"carousel_arrows_together_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_together_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:43:\"carousel_arrows_together_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:41:\"carousel_arrows_together_border_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:41:\"carousel_arrows_together_box_shadow_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:44:\"carousel_arrows_together_box_shadow_offset_x\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:44:\"carousel_arrows_together_box_shadow_offset_y\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:40:\"carousel_arrows_together_box_shadow_blur\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:42:\"carousel_arrows_together_box_shadow_spread\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:19:\"carousel_pagin_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:23:\"carousel_pagin_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:29:\"carousel_pagin_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:30:\"carousel_pagin_bg_color_active\";a:1:{s:4:\"idle\";s:0:\"\";}s:28:\"carousel_pagin_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"carousel_pagin_border_style\";s:0:\"\";s:27:\"carousel_pagin_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"carousel_pagin_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_pagin_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_pagin_border_color_active\";a:1:{s:4:\"idle\";s:0:\"\";}s:25:\"carousel_scrollbar_height\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:24:\"carousel_scrollbar_width\";s:152:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9LCJ0YWJsZXQiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9LCJtb2JpbGUiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9fX0=\";s:27:\"carousel_scrollbar_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:32:\"carousel_scrollbar_drag_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_scrollbar_drag_bg_hover_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:17:\"blog_hide_sidebar\";s:1:\"0\";s:24:\"blog_hide_sidebar_tablet\";s:1:\"1\";s:24:\"blog_hide_sidebar_mobile\";s:1:\"1\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:11:\"blog_design\";s:10:\"meta-image\";s:10:\"blog_style\";s:6:\"shadow\";s:16:\"blog_with_shadow\";s:1:\"0\";s:12:\"blog_columns\";s:1:\"4\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:19:\"blog_spacing_tablet\";s:0:\"\";s:19:\"blog_spacing_mobile\";s:0:\"\";s:15:\"blog_pagination\";s:10:\"pagination\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"100\";s:11:\"parts_title\";s:1:\"1\";s:10:\"parts_meta\";s:1:\"1\";s:10:\"parts_text\";s:1:\"1\";s:9:\"parts_btn\";s:1:\"1\";s:20:\"parts_published_date\";s:1:\"1\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:19:\"blog_published_date\";s:1:\"1\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:1:\"0\";s:24:\"portfolio_spacing_tablet\";s:0:\"\";s:24:\"portfolio_spacing_mobile\";s:0:\"\";s:18:\"portoflio_per_page\";s:1:\"6\";s:20:\"portfolio_pagination\";s:9:\"load_more\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"0\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";s:1:\"0\";s:16:\"show_sku_in_cart\";s:1:\"0\";s:25:\"show_sku_in_checkout_page\";s:1:\"0\";s:26:\"show_sku_in_thank_you_page\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"0\";s:16:\"show_sku_on_ajax\";s:1:\"0\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:1:\"0\";s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:8:\"pa_color\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"single_product_swatches_limit\";s:1:\"0\";s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"0\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"new\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:29:\"show_filtered_variation_image\";s:1:\"0\";s:17:\"hide_larger_price\";s:1:\"0\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:10:\"rounded-sm\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:8:\"pa_brand\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:14:\"brand_tab_name\";s:1:\"0\";s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:2:\"23\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:12:\"availability\";}s:18:\"empty_compare_text\";s:150:\"No products added in the compare list. You must add some products to compare them.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:15:\"compare_on_grid\";s:1:\"1\";s:25:\"compare_save_button_state\";s:1:\"0\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:18:\"cart_totals_layout\";s:8:\"layout-1\";s:27:\"update_cart_quantity_change\";s:1:\"1\";s:15:\"empty_cart_text\";s:144:\"Before proceed to checkout you must add some products to your shopping cart.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:27:\"single_product_hide_sidebar\";s:1:\"0\";s:34:\"single_product_hide_sidebar_tablet\";s:1:\"1\";s:34:\"single_product_hide_sidebar_mobile\";s:1:\"1\";s:20:\"single_product_style\";s:1:\"2\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:12:\"image_action\";s:5:\"popup\";s:15:\"photoswipe_icon\";s:1:\"0\";s:26:\"product_slider_auto_height\";s:1:\"0\";s:23:\"pagination_main_gallery\";s:1:\"0\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:13:\"bottom_column\";s:31:\"single_product_grid_columns_gap\";s:164:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidW5pdCI6InB4IiwidmFsdWUiOiIyMCJ9LCJ0YWJsZXQiOnsidW5pdCI6InB4IiwidmFsdWUiOiIyMCJ9LCJtb2JpbGUiOnsidW5pdCI6InB4IiwidmFsdWUiOiIxMCJ9fX0=\";s:34:\"single_product_grid_column_desktop\";s:1:\"2\";s:33:\"single_product_grid_column_tablet\";s:1:\"2\";s:33:\"single_product_grid_column_mobile\";s:1:\"2\";s:37:\"single_product_gallery_column_desktop\";s:1:\"1\";s:36:\"single_product_gallery_column_tablet\";s:0:\"\";s:36:\"single_product_gallery_column_mobile\";s:0:\"\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:22:\"main_gallery_on_tablet\";s:1:\"0\";s:22:\"main_gallery_on_mobile\";s:1:\"0\";s:24:\"main_gallery_center_mode\";s:1:\"0\";s:48:\"single_product_thumbnails_wrap_in_mobile_devices\";s:1:\"1\";s:39:\"single_product_thumbnails_gallery_width\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:40:\"single_product_thumbnails_gallery_height\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"0\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"0\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:7:\"default\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"0\";s:17:\"product_countdown\";s:1:\"0\";s:23:\"sale_countdown_variable\";s:1:\"0\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:18:\"show_product_brand\";s:1:\"0\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"4\";s:30:\"related_product_columns_tablet\";s:4:\"auto\";s:30:\"related_product_columns_mobile\";s:4:\"auto\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:20:\"additional_tab_title\";s:22:\"خرید و تحویل\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:8:\"Register\";s:8:\"reg_text\";s:258:\"Registering for this site allows you to access your order status and history. Just fill in the fields below, and we\'ll get a new account set up for you in no time. We will only ask you for information necessary to make the purchase process faster and easier.\";s:11:\"login_title\";s:5:\"Login\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:66:\"span.woocommerce-Price-currencySymbol {\r\n    margin-right: 3px;\r\n}\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:12:\"bluesky_link\";s:0:\"\";s:14:\"isntagram_link\";s:1:\"#\";s:12:\"threads_link\";s:0:\"\";s:14:\"pinterest_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:10:\"skype_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:10:\"viber_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:12:\"discord_link\";s:0:\"\";s:9:\"yelp_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:14:\"share_whatsapp\";s:1:\"0\";s:8:\"share_tg\";s:1:\"0\";s:11:\"share_viber\";s:1:\"0\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_ok\";s:1:\"0\";s:11:\"share_email\";s:1:\"0\";s:19:\"mobile_optimization\";s:1:\"0\";s:16:\"load_text_domain\";s:1:\"1\";s:21:\"disable_gutenberg_css\";s:1:\"0\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"0\";s:21:\"remove_jquery_migrate\";s:1:\"0\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:8:\"required\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:17:\"wd_swiper_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:22:\"lazy_loading_bg_images\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"fade\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";s:1:\"0\";s:26:\"rocket_delay_js_exclusions\";s:1:\"0\";s:6:\"cf7_js\";s:1:\"1\";s:20:\"elementor_animations\";s:1:\"1\";s:15:\"elementor_icons\";s:1:\"1\";s:24:\"elementor_dialog_library\";s:1:\"1\";s:18:\"elementor_frontend\";s:1:\"1\";s:14:\"swiper_library\";s:6:\"always\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:7:\"not_use\";s:23:\"font_icon_woff2_preload\";s:1:\"0\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:15:\"current_builder\";s:8:\"external\";s:16:\"gutenberg_blocks\";s:1:\"0\";s:29:\"enable_gutenberg_for_products\";s:1:\"0\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"0\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"1\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"1\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:16:\"maintenance_mode\";s:1:\"0\";s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";s:1:\"0\";s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"1\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:2:\"21\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:117:\"You don\'t have any products in the wishlist yet. <br> You will find a lot of interesting products on our \"Shop\" page.\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"0\";s:27:\"checkout_show_product_image\";s:1:\"1\";s:25:\"checkout_product_quantity\";s:1:\"1\";s:22:\"checkout_remove_button\";s:1:\"1\";s:24:\"checkout_link_to_product\";s:1:\"0\";s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"two-column\";s:21:\"reviews_form_location\";s:6:\"before\";s:13:\"reviews_style\";s:7:\"style-2\";s:15:\"reviews_columns\";s:1:\"2\";s:22:\"reviews_columns_tablet\";s:1:\"1\";s:22:\"reviews_columns_mobile\";s:1:\"1\";s:24:\"reviews_enable_pros_cons\";s:1:\"0\";s:20:\"reviews_enable_likes\";s:1:\"1\";s:32:\"show_reviews_purchased_indicator\";s:1:\"1\";s:15:\"reviews_sorting\";s:1:\"1\";s:29:\"single_product_comment_images\";s:1:\"0\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";s:1:\"0\";s:22:\"reviews_rating_summary\";s:1:\"1\";s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";s:1:\"1\";s:26:\"reviews_rating_by_criteria\";s:1:\"0\";s:32:\"reviews_criteria_rating_required\";s:1:\"0\";s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:0:\"\";s:23:\"sticky_navigation_title\";s:0:\"\";s:30:\"sticky_navigation_content_type\";s:4:\"text\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:0:\"\";s:33:\"single_product_main_gallery_video\";s:1:\"1\";s:23:\"checkout_fields_enabled\";s:1:\"0\";s:29:\"shipping_progress_bar_enabled\";s:1:\"1\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:4:\"1300\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"exclude\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"1\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:46:\"Add [remainder] to cart and get free shipping!\";s:37:\"shipping_progress_bar_message_success\";s:39:\"Your order qualifies for free shipping!\";s:15:\"buy_now_enabled\";s:1:\"1\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"0\";s:27:\"counter_visitor_data_source\";s:9:\"live_data\";s:38:\"counter_visitor_data_source_min_number\";s:2:\"10\";s:38:\"counter_visitor_data_source_max_number\";s:2:\"20\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:17:\"linked_variations\";s:1:\"1\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:20:\"sold_counter_enabled\";s:1:\"0\";s:23:\"sold_counter_sales_type\";s:9:\"real_data\";s:24:\"sold_counter_shown_after\";s:1:\"0\";s:22:\"sold_counter_min_count\";s:2:\"10\";s:22:\"sold_counter_max_count\";s:2:\"20\";s:31:\"sold_counter_hide_on_outofstock\";s:1:\"0\";s:22:\"sold_counter_timeframe\";s:1:\"3\";s:29:\"sold_counter_timeframe_period\";s:7:\"minutes\";s:28:\"sold_counter_transient_hours\";s:2:\"24\";s:17:\"discounts_enabled\";s:1:\"0\";s:20:\"show_discounts_table\";s:1:\"0\";s:18:\"free_gifts_enabled\";s:1:\"0\";s:16:\"free_gifts_limit\";s:1:\"5\";s:41:\"free_gifts_allow_multiple_identical_gifts\";s:1:\"0\";s:23:\"free_gifts_price_format\";s:4:\"text\";s:17:\"free_gift_on_cart\";s:1:\"1\";s:25:\"free_gifts_table_location\";s:28:\"woocommerce_after_cart_table\";s:21:\"free_gift_on_checkout\";s:1:\"0\";s:28:\"show_out_of_stock_at_the_end\";s:1:\"0\";s:16:\"waitlist_enabled\";s:1:\"0\";s:21:\"waitlist_for_loggined\";s:1:\"0\";s:19:\"waitlist_form_state\";s:13:\"current_state\";s:25:\"waitlist_fragments_enable\";s:1:\"0\";s:22:\"waitlist_wait_interval\";s:4:\"3600\";s:32:\"waitlist_enable_privacy_checkbox\";s:1:\"1\";s:30:\"waitlist_privacy_checkbox_text\";s:84:\"من <strong>[privacy_policy]</strong> را خوانده‌ام و می‌پذیرم\";s:25:\"estimate_delivery_enabled\";s:1:\"0\";s:40:\"estimate_delivery_show_on_single_product\";s:1:\"1\";s:35:\"estimate_delivery_show_on_mini_cart\";s:1:\"0\";s:35:\"estimate_delivery_show_on_cart_page\";s:1:\"1\";s:39:\"estimate_delivery_show_on_checkout_page\";s:1:\"1\";s:39:\"estimate_delivery_show_on_order_details\";s:1:\"1\";s:37:\"estimate_delivery_show_on_email_order\";s:1:\"1\";s:30:\"estimate_delivery_show_overall\";s:1:\"0\";s:29:\"estimate_delivery_date_format\";s:7:\"default\";s:34:\"estimate_delivery_fragments_enable\";s:1:\"0\";s:21:\"cart_recovery_enabled\";s:1:\"0\";s:26:\"recover_guest_cart_enabled\";s:1:\"0\";s:42:\"recover_guest_cart_enable_privacy_checkbox\";s:1:\"0\";s:40:\"recover_guest_cart_privacy_checkbox_text\";s:447:\"اگر این کادر را علامت بزنید، به ما اجازه می دهید تا برخی از جزئیات خود را در لیست مخاطبین ذخیره کنیم. ممکن است پیام های ایمیلی حاوی اطلاعات تجاری یا تبلیغاتی در مورد این فروشگاه دریافت کنید.\r\nاطلاعات شخصی جمع آوری شده: آدرس ایمیل، نام و نام خانوادگی.\";s:24:\"abandoned_cart_timeframe\";s:1:\"2\";s:31:\"abandoned_cart_timeframe_period\";s:5:\"86400\";s:31:\"abandoned_cart_delete_timeframe\";s:2:\"30\";s:38:\"abandoned_cart_delete_timeframe_period\";s:5:\"86400\";s:29:\"abandoned_cart_coupon_enabled\";s:1:\"0\";s:28:\"abandoned_cart_coupon_prefix\";s:2:\"WD\";s:28:\"abandoned_cart_coupon_amount\";s:2:\"10\";s:35:\"abandoned_cart_coupon_discount_type\";s:7:\"percent\";s:34:\"abandoned_cart_delete_used_coupons\";s:1:\"1\";s:37:\"abandoned_cart_delete_expired_coupons\";s:1:\"1\";s:31:\"abandoned_cart_coupon_timeframe\";s:1:\"1\";s:38:\"abandoned_cart_coupon_timeframe_period\";s:5:\"86400\";s:8:\"last_tab\";s:23:\"product_archive_section\";i:2;a:2:{s:16:\"pages-background\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:14:\"fields_to_save\";s:16:\"pages-background\";}}", "yes");
INSERT INTO `wp_options` VALUES("162", "woodmart_setup_status", "done", "yes");
INSERT INTO `wp_options` VALUES("163", "wd_import_theme_version", "7.3.0", "yes");
INSERT INTO `wp_options` VALUES("164", "woodmart-plugins-update-time", "1755497011", "yes");
INSERT INTO `wp_options` VALUES("165", "woodmart_js_composer_version", "8.6.1", "yes");
INSERT INTO `wp_options` VALUES("166", "woodmart_revslider_version", "6.7.35", "yes");
INSERT INTO `wp_options` VALUES("167", "wd_wishlist_installed", "1", "yes");
INSERT INTO `wp_options` VALUES("168", "woodmart_upgrade_database_wishlist", "1", "yes");
INSERT INTO `wp_options` VALUES("169", "woodmart_added_column_on_sale_in_product_db", "1", "yes");
INSERT INTO `wp_options` VALUES("179", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:21:\"info@iran-woodmart.ir\";s:7:\"version\";s:5:\"6.8.2\";s:9:\"timestamp\";i:1752655613;}", "off");
INSERT INTO `wp_options` VALUES("183", "woodmart-update-time", "1755497012", "yes");
INSERT INTO `wp_options` VALUES("184", "woodmart-update-info", "O:8:\"stdClass\":6:{s:11:\"new_version\";s:5:\"8.2.7\";s:7:\"version\";s:5:\"8.2.7\";s:5:\"theme\";s:8:\"woodmart\";s:7:\"checked\";i:1755497012;s:3:\"url\";s:41:\"https://xtemos.com/woodmart-changelog.php\";s:7:\"package\";s:65:\"https://xtemos.com/wp-json/xts/v1/download?token=1&theme=woodmart\";}", "yes");
INSERT INTO `wp_options` VALUES("189", "elementor_active_kit", "5", "yes");
INSERT INTO `wp_options` VALUES("190", "elementor_font_display", "swap", "yes");
INSERT INTO `wp_options` VALUES("193", "elementor_version", "3.31.2", "yes");
INSERT INTO `wp_options` VALUES("194", "elementor_install_history", "a:5:{s:6:\"3.15.3\";i:1694017427;s:6:\"3.24.4\";i:1727633001;s:6:\"3.30.0\";i:1751363536;s:6:\"3.30.2\";i:1752750462;s:6:\"3.31.2\";i:1755515206;}", "yes");
INSERT INTO `wp_options` VALUES("195", "elementor_events_db_version", "1.0.0", "no");
INSERT INTO `wp_options` VALUES("198", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("199", "_elementor_installed_time", "1694017427", "yes");
INSERT INTO `wp_options` VALUES("200", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "off");
INSERT INTO `wp_options` VALUES("201", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:100:\"Introducing Elementor 3.30: new Editor V4 capabilities, full Website Templates in the cloud, & more!\";s:7:\"excerpt\";s:361:\"Elementor 3.30 is here and it includes upgrades that accelerate your workflow, bring you a step closer to the full power of Editor V4, and help you deliver beautiful, accessible websites faster than ever. From advanced styling tools and smarter editing to full Website Templates in the cloud, this release enhances both the way you design and the way you scale.\";s:7:\"created\";i:1751974442;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-330-v4-alpha-website-templates/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `wp_options` VALUES("206", "widget_nav_mega_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("207", "widget_woodmart-banner", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("208", "widget_woodmart-author-information", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("209", "widget_woodmart-instagram", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("210", "widget_woodmart-html-block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("211", "widget_woodmart-recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("212", "widget_woodmart-twitter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("213", "widget_wd-mailchimp-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("216", "revslider_servers", "a:3:{i:0;s:22:\"themepunch-ext-b.tools\";i:1;s:22:\"themepunch-ext-c.tools\";i:2;s:22:\"themepunch-ext-a.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("217", "revslider_server_refresh", "1694017449", "yes");
INSERT INTO `wp_options` VALUES("218", "revslider-update-check-short", "1694017449", "yes");
INSERT INTO `wp_options` VALUES("219", "revslider-connection", "1", "yes");
INSERT INTO `wp_options` VALUES("220", "revslider-update-hash", "a676aef15f29a7583034883c5877a9e4", "yes");
INSERT INTO `wp_options` VALUES("221", "revslider-latest-version", "6.6.16", "yes");
INSERT INTO `wp_options` VALUES("222", "revslider-stable-version", "4.2.0", "yes");
INSERT INTO `wp_options` VALUES("223", "revslider-notices", "a:5:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"1.0.0\";s:4:\"text\";s:546:\"<div style=\"display: block; background: #fff;text-align: center; height: 250px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 960px; height: 250px; display: inline-block;\" muted=\"\" loop=\"\" autoplay=\"\" preload=\"auto\"><source src=\"https://sliderrevolution.com/wp-content/uploads/2021/07/adminpremiumvid4.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:12:\"TPRSV6511-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"1.9.9\";s:4:\"text\";s:556:\"<div style=\"display: block; background: #fff;text-align: center; \nheight: 300px;\"><a \nhref=\"https://www.sliderrevolution.com/slider-revolution-visual-editor-version-6-6/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=update66\"\n target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: \ncover; background-size: cover; opacity: 1; width: 920px; height: 300px; \ndisplay: inline-block;\" muted loop autoplay \npreload=\"auto\"><source src=\"//updates.themepunch.tools//banners/rs60/update66videobanner2.mp4\" type=\"video/mp4\"></video></a></div>\n\";s:4:\"code\";s:8:\"TPRSV663\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"1.0.0\";s:4:\"text\";s:531:\"<div style=\"display: block; background: #fff;text-align: center; height: 300px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium2\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 920px; height: 300px; display: inline-block;\" muted=\"\" loop=\"\" autoplay=\"\" preload=\"auto\"><source src=\"//updates.themepunch.tools//banners/videobanner_premium2.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:12:\"TPRSV6518-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:3;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:396:\"<div style=\"display: block; background:#fff;text-align: center; height: 250px;\"><a href=\"https://www.sliderrevolution.com/wordpress-hosting/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getwphosting\" target=\"_blank\" rel=\"noopener\"><img style=\"width: 960px; height: 250px; display: inline-block;\"  src=\"//updates.themepunch.tools//banners/rs60/wphostingadmin.jpg\"></a></div>\";s:4:\"code\";s:12:\"TPRSV6518-02\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"registered\";b:1;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:4;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:521:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 504px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium3\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 900px; height: 504px; display: inline-block;\" muted loop autoplay preload=\"auto\"><source src=\"//updates.themepunch.tools//banners/rs60/buypremium3.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:8:\"TPRSV668\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"registered\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("224", "revslider-additions", "O:8:\"stdClass\":2:{s:9:\"templates\";O:8:\"stdClass\":3:{s:9:\"tutorials\";a:3:{i:0;O:8:\"stdClass\":2:{s:5:\"title\";s:19:\"Rapid Fire Overview\";s:3:\"url\";s:49:\"https://www.youtube.com/watch?v=LRNTFu-MFgw&t=25s\";}i:1;O:8:\"stdClass\":2:{s:5:\"title\";s:34:\"Responsiveness in Edited Templates\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=hP4oV8SWgKY\";}i:2;O:8:\"stdClass\":2:{s:5:\"title\";s:16:\"Animation Basics\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=nn3azizwpbs\";}}s:5:\"guide\";O:8:\"stdClass\":3:{s:5:\"title\";s:78:\"Require Expert Technical Advice?<br />Submit a Ticket for Dedicated 1on1 Help.\";s:3:\"url\";s:36:\"https://support.sliderrevolution.com\";s:3:\"img\";s:61:\"//updates.themepunch.tools/banners/default_template_guide.jpg\";}s:6:\"bottom\";O:8:\"stdClass\":2:{s:5:\"title\";s:32:\"Load A Template From The Library\";s:3:\"img\";s:55:\"//updates.themepunch.tools/banners/guide_mod_banner.png\";}}s:7:\"selling\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("225", "rs-addons-counter", "34", "yes");
INSERT INTO `wp_options` VALUES("226", "revslider-addons", "O:8:\"stdClass\":34:{s:28:\"revslider-particlewave-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"380\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:28:\"revslider-particlewave-addon\";s:12:\"version_from\";s:6:\"6.5.15\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Particle Wave\";s:6:\"line_1\";s:36:\"Create 3D particle and polygon grids\";s:6:\"line_2\";s:40:\"with lots of style and animation options\";s:9:\"available\";s:5:\"1.1.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:1:\"9\";s:11:\"last_update\";s:10:\"2023-08-24\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch.tools/revslider/addons/images/addon_particlewave.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PW\";}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"424\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"3.3.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2023-07-28\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_particles.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"3.0.8\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2023-06-26\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:72:\"//updates.themepunch.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}}s:26:\"revslider-thecluster-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"481\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:26:\"revslider-thecluster-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"The Cluster\";s:6:\"line_1\";s:24:\"Cluster Particle Effects\";s:6:\"line_2\";s:27:\"with millions of Variations\";s:9:\"available\";s:6:\"1.0.10\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:11:\"last_update\";s:10:\"2023-06-26\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:68:\"//updates.themepunch.tools/revslider/addons/images/addon_cluster.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TC\";}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"369\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2023-02-23\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_transition.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"507\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"3.1.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2023-05-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:72:\"//updates.themepunch.tools/revslider/addons/images/addon_beforeafter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"418\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_typewriter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"499\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"3.0.9\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2023-06-26\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_mousetrap.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"500\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_distortion.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"420\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"3.1.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2023-06-26\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch.tools/revslider/addons/images/addon_lottie.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"411\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2023-08-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_paintbrush.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"483\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:6:\"6.5.17\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:67:\"//updates.themepunch.tools/revslider/addons/images/addon_charts.png\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2022-08-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch.tools/revslider/addons/images/addon_charts.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch.tools/revslider/addons/images/addon_slicey.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"422\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_filmstrip.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"421\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"3.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2023-07-17\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch.tools/revslider/addons/images/addon_underconstruction.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"416\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch.tools/revslider/addons/images/addon_reveal.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"423\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"3.0.9\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:69:\"//updates.themepunch.tools/revslider/addons/images/addon_panorama.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"498\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:72:\"//updates.themepunch.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:72:\"//updates.themepunch.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"407\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_exploding.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"397\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2023-07-08\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch.tools/revslider/addons/images/addon_socialsharing.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"419\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:75:\"//updates.themepunch.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_whiteboard.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"414\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:69:\"//updates.themepunch.tools/revslider/addons/images/addon_polyfold.jpg\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2022-02-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch.tools/revslider/addons/images/addon_domainswitch.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"415\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch.tools/revslider/addons/images/addon_reload.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2023-06-12\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_wprelated.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"399\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:65:\"//updates.themepunch.tools/revslider/addons/images/addon_snow.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2022-01-31\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_wpgallery.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch.tools/revslider/addons/images/addon_backup.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2022-12-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:64:\"//updates.themepunch.tools/revslider/addons/images/addon_404.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2023-08-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2023-06-12\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:66:\"//updates.themepunch.tools/revslider/addons/images/addon_login.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"402\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:68:\"//updates.themepunch.tools/revslider/addons/images/addon_weather.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"406\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:68:\"//updates.themepunch.tools/revslider/addons/images/addon_duotone.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}}}", "yes");
INSERT INTO `wp_options` VALUES("227", "revslider-library-check", "1694017453", "yes");
INSERT INTO `wp_options` VALUES("228", "revslider-library-hash", "dae3de1eb57eeeee008b70e9a23844b5", "yes");
INSERT INTO `wp_options` VALUES("229", "rs-library", "a:3:{s:4:\"hash\";s:32:\"dae3de1eb57eeeee008b70e9a23844b5\";s:7:\"objects\";a:417:{i:0;a:12:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:1;a:12:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:2;a:12:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:3;a:12:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:4;a:12:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:5;a:12:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:6;a:12:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:7;a:12:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:8;a:12:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:9;a:12:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:10;a:12:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:11;a:12:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:12;a:12:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:13;a:12:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:14;a:12:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:15;a:12:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:16;a:12:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:17;a:12:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:18;a:12:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:19;a:12:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:20;a:12:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:21;a:12:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:22;a:12:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:23;a:12:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:24;a:12:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:25;a:12:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:26;a:12:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:27;a:12:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:28;a:12:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:29;a:12:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:30;a:12:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:31;a:12:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:32;a:12:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:33;a:12:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:34;a:12:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:35;a:12:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:36;a:12:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:37;a:12:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:38;a:12:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:39;a:12:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:40;a:12:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:41;a:12:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:42;a:12:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:43;a:12:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:44;a:12:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:45;a:12:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:46;a:12:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:47;a:12:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:48;a:12:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:49;a:12:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:50;a:12:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:51;a:12:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:52;a:12:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:53;a:12:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:54;a:12:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:55;a:12:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:56;a:12:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:57;a:12:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:58;a:12:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:59;a:12:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:60;a:12:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:61;a:12:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:62;a:12:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:63;a:12:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:64;a:12:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:65;a:12:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:66;a:12:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:67;a:12:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:68;a:12:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:69;a:12:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:70;a:12:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:71;a:12:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:72;a:12:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:73;a:12:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:74;a:12:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:75;a:12:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:76;a:12:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:77;a:12:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:78;a:12:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:79;a:12:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:80;a:12:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:81;a:12:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:82;a:12:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:83;a:12:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:84;a:12:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:85;a:12:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:86;a:12:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:87;a:12:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:88;a:12:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:89;a:12:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:90;a:12:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:91;a:12:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:92;a:12:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:93;a:12:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:94;a:12:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:95;a:12:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:96;a:12:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:97;a:12:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:98;a:12:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:99;a:12:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:100;a:12:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:101;a:12:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:102;a:12:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:103;a:12:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:104;a:12:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:105;a:12:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:106;a:12:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:107;a:12:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:108;a:12:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:109;a:12:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:110;a:12:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:111;a:12:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:112;a:12:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:113;a:12:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:114;a:12:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:115;a:12:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:116;a:12:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:117;a:12:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:118;a:12:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:119;a:12:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:120;a:12:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:121;a:12:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:122;a:12:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:123;a:12:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:124;a:12:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:125;a:12:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:126;a:12:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:127;a:12:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:128;a:12:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:129;a:12:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:130;a:12:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:131;a:12:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:132;a:12:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:133;a:12:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:134;a:12:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:135;a:12:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:136;a:12:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:137;a:12:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:138;a:12:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:139;a:12:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:140;a:12:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:141;a:12:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:142;a:12:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:143;a:12:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:144;a:12:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:145;a:12:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:146;a:12:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:147;a:12:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:148;a:12:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:149;a:12:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:150;a:12:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:151;a:12:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:152;a:12:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:153;a:12:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:154;a:12:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:155;a:12:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:156;a:12:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:157;a:12:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:158;a:12:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:159;a:12:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:160;a:12:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:161;a:12:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:162;a:12:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:163;a:12:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:164;a:12:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:165;a:12:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:166;a:12:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:167;a:12:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:168;a:12:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:169;a:12:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:170;a:12:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:171;a:12:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:172;a:12:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:173;a:12:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:174;a:12:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:175;a:12:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:176;a:12:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:177;a:12:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:178;a:12:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:179;a:12:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:180;a:12:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:181;a:12:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:182;a:12:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:183;a:12:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:184;a:12:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:185;a:12:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:186;a:12:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:187;a:12:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:188;a:12:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:189;a:12:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:190;a:12:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:191;a:12:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:192;a:12:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:193;a:12:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:194;a:12:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:195;a:12:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:196;a:12:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:197;a:12:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:198;a:12:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:199;a:12:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:200;a:12:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:201;a:12:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:202;a:12:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:203;a:12:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:204;a:12:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:205;a:12:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:206;a:12:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:207;a:12:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:208;a:12:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:209;a:12:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:210;a:12:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:211;a:12:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:212;a:12:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:213;a:12:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:214;a:12:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:215;a:12:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:216;a:12:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:217;a:12:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:218;a:12:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:219;a:12:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:220;a:12:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:221;a:12:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:222;a:12:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:223;a:12:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:224;a:12:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:225;a:12:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:226;a:12:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:227;a:12:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:228;a:12:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:229;a:12:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:230;a:12:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:231;a:12:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:232;a:12:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:233;a:12:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:234;a:12:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:235;a:12:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:236;a:12:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:237;a:12:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:238;a:12:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:239;a:12:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:240;a:12:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:241;a:12:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:242;a:12:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:243;a:12:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:244;a:12:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:245;a:12:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:246;a:12:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:247;a:12:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:248;a:12:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:249;a:12:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:250;a:12:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:251;a:12:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:252;a:12:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:253;a:12:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:254;a:12:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:255;a:12:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:256;a:12:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:257;a:12:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:258;a:12:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:259;a:12:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:260;a:12:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:261;a:12:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:262;a:12:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:263;a:12:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:264;a:12:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:265;a:12:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:266;a:12:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:267;a:12:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:268;a:12:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:269;a:12:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:270;a:12:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:271;a:12:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:272;a:12:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:273;a:12:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:274;a:12:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:275;a:12:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:276;a:12:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:277;a:12:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:278;a:12:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:279;a:12:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:280;a:12:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:281;a:12:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:282;a:12:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:283;a:12:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:284;a:12:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:285;a:12:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:286;a:12:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:287;a:12:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:288;a:12:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:289;a:12:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:290;a:12:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:291;a:12:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:292;a:12:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:293;a:12:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:294;a:12:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:295;a:12:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:296;a:12:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:297;a:12:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:298;a:12:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:299;a:12:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:300;a:12:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:301;a:12:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:302;a:12:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:303;a:12:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:304;a:12:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:305;a:12:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:306;a:12:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:307;a:12:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:308;a:12:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:309;a:13:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:310;a:13:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:311;a:13:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:312;a:13:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:313;a:13:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:314;a:13:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:315;a:13:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:316;a:13:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:317;a:13:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:318;a:13:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:319;a:13:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:320;a:13:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:321;a:13:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:322;a:13:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:323;a:13:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:324;a:13:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:325;a:13:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:326;a:13:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:327;a:13:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:328;a:13:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:329;a:13:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:330;a:13:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:331;a:13:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:332;a:13:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:333;a:13:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:334;a:13:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:335;a:13:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:336;a:13:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:337;a:13:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:338;a:13:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:339;a:13:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:340;a:13:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:341;a:13:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:342;a:13:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:343;a:13:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:344;a:13:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:345;a:13:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:346;a:13:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:347;a:13:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:348;a:13:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:349;a:13:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:350;a:13:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:351;a:13:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:352;a:13:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:353;a:13:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:354;a:13:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:355;a:13:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:356;a:13:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:357;a:13:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:358;a:13:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:359;a:13:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:360;a:13:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:361;a:13:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:362;a:13:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:363;a:13:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:364;a:13:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:365;a:13:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:366;a:13:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:367;a:13:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:368;a:13:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:369;a:13:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:370;a:13:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:371;a:13:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:372;a:13:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:373;a:13:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:374;a:13:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:375;a:13:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:376;a:13:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:377;a:13:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:378;a:13:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:379;a:13:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:380;a:13:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:381;a:13:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:382;a:13:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:383;a:13:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:384;a:13:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:385;a:13:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:386;a:13:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:387;a:13:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:388;a:13:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:389;a:13:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:390;a:13:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:391;a:13:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:392;a:13:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:393;a:13:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:394;a:13:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:395;a:13:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:396;a:13:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:397;a:13:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:398;a:13:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:399;a:13:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:400;a:13:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:401;a:13:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:402;a:13:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:403;a:13:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:404;a:13:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:405;a:13:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:406;a:13:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:407;a:13:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:408;a:13:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:409;a:13:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:410;a:13:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:411;a:13:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:412;a:13:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:413;a:13:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:414;a:13:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:415;a:13:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:416;a:13:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}", "no");
INSERT INTO `wp_options` VALUES("230", "revslider-templates-check", "1694017461", "yes");
INSERT INTO `wp_options` VALUES("231", "revslider-templates-hash", "272be7a5e6673b737f3229ff10900ecb", "yes");
INSERT INTO `wp_options` VALUES("232", "rs-templates-new", "", "no");
INSERT INTO `wp_options` VALUES("233", "rs-templates", "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", "no");
INSERT INTO `wp_options` VALUES("234", "rs-templates-counter", "699", "no");
INSERT INTO `wp_options` VALUES("238", "revslider_update_version", "6.6.0", "yes");
INSERT INTO `wp_options` VALUES("241", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("242", "revslider-update-check", "1694017466", "yes");
INSERT INTO `wp_options` VALUES("243", "revslider_update_info", "O:8:\"stdClass\":0:{}", "yes");
INSERT INTO `wp_options` VALUES("248", "action_scheduler_hybrid_store_demarkation", "6", "yes");
INSERT INTO `wp_options` VALUES("249", "schema-ActionScheduler_StoreSchema", "8.0.1755515236", "yes");
INSERT INTO `wp_options` VALUES("250", "schema-ActionScheduler_LoggerSchema", "3.0.1694017488", "yes");
INSERT INTO `wp_options` VALUES("253", "woocommerce_newly_installed", "no", "yes");
INSERT INTO `wp_options` VALUES("254", "woocommerce_schema_version", "920", "yes");
INSERT INTO `wp_options` VALUES("255", "woocommerce_store_address", "", "yes");
INSERT INTO `wp_options` VALUES("256", "woocommerce_store_address_2", "", "yes");
INSERT INTO `wp_options` VALUES("257", "woocommerce_store_city", "", "yes");
INSERT INTO `wp_options` VALUES("258", "woocommerce_default_country", "IR:THR", "yes");
INSERT INTO `wp_options` VALUES("259", "woocommerce_store_postcode", "", "yes");
INSERT INTO `wp_options` VALUES("260", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `wp_options` VALUES("261", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("262", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("263", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `wp_options` VALUES("264", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("265", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `wp_options` VALUES("266", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wp_options` VALUES("267", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `wp_options` VALUES("268", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_options` VALUES("269", "woocommerce_currency", "IRT", "yes");
INSERT INTO `wp_options` VALUES("270", "woocommerce_currency_pos", "right_space", "yes");
INSERT INTO `wp_options` VALUES("271", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `wp_options` VALUES("272", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `wp_options` VALUES("273", "woocommerce_price_num_decimals", "0", "yes");
INSERT INTO `wp_options` VALUES("274", "woocommerce_shop_page_id", "1418", "yes");
INSERT INTO `wp_options` VALUES("275", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_options` VALUES("276", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("277", "woocommerce_placeholder_image", "6", "yes");
INSERT INTO `wp_options` VALUES("278", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_options` VALUES("279", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_options` VALUES("280", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wp_options` VALUES("281", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_options` VALUES("282", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wp_options` VALUES("283", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wp_options` VALUES("284", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_options` VALUES("285", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_options` VALUES("286", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_options` VALUES("287", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("288", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("289", "woocommerce_stock_email_recipient", "sasanrahmanii98@gmail.com", "no");
INSERT INTO `wp_options` VALUES("290", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_options` VALUES("291", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wp_options` VALUES("292", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_options` VALUES("293", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_options` VALUES("294", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_options` VALUES("295", "woocommerce_downloads_redirect_fallback_allowed", "no", "no");
INSERT INTO `wp_options` VALUES("296", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_options` VALUES("297", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_options` VALUES("298", "woocommerce_downloads_deliver_inline", "", "no");
INSERT INTO `wp_options` VALUES("299", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `wp_options` VALUES("301", "woocommerce_attribute_lookup_direct_updates", "no", "yes");
INSERT INTO `wp_options` VALUES("302", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_options` VALUES("303", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_options` VALUES("304", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wp_options` VALUES("305", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_options` VALUES("306", "woocommerce_tax_classes", "", "yes");
INSERT INTO `wp_options` VALUES("307", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_options` VALUES("308", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `wp_options` VALUES("309", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_options` VALUES("310", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_options` VALUES("311", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_options` VALUES("312", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `wp_options` VALUES("313", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_options` VALUES("314", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `wp_options` VALUES("315", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("316", "woocommerce_enable_checkout_login_reminder", "no", "no");
INSERT INTO `wp_options` VALUES("317", "woocommerce_enable_signup_and_login_from_checkout", "no", "no");
INSERT INTO `wp_options` VALUES("318", "woocommerce_enable_myaccount_registration", "yes", "no");
INSERT INTO `wp_options` VALUES("319", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wp_options` VALUES("320", "woocommerce_registration_generate_password", "yes", "no");
INSERT INTO `wp_options` VALUES("321", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `wp_options` VALUES("322", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `wp_options` VALUES("323", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `wp_options` VALUES("324", "woocommerce_registration_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما استفاده می‌شود، و پشتیبانی از تجربه شما در این وبسایت، و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است.", "yes");
INSERT INTO `wp_options` VALUES("325", "woocommerce_checkout_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما، پشتیبانی از تجربه شما در سراسر این وب سایت و برای اهدافی که در [privacy_policy] ذکر شده است استفاده می شود.", "yes");
INSERT INTO `wp_options` VALUES("326", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("327", "woocommerce_trash_pending_orders", "", "no");
INSERT INTO `wp_options` VALUES("328", "woocommerce_trash_failed_orders", "", "no");
INSERT INTO `wp_options` VALUES("329", "woocommerce_trash_cancelled_orders", "", "no");
INSERT INTO `wp_options` VALUES("330", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("331", "woocommerce_email_from_name", "دمو ایران وودمارت", "no");
INSERT INTO `wp_options` VALUES("332", "woocommerce_email_from_address", "sasanrahmanii98@gmail.com", "no");
INSERT INTO `wp_options` VALUES("333", "woocommerce_email_header_image", "", "no");
INSERT INTO `wp_options` VALUES("334", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `wp_options` VALUES("335", "woocommerce_email_base_color", "#720eec", "no");
INSERT INTO `wp_options` VALUES("336", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `wp_options` VALUES("337", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wp_options` VALUES("338", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `wp_options` VALUES("339", "woocommerce_merchant_email_notifications", "no", "no");
INSERT INTO `wp_options` VALUES("340", "woocommerce_cart_page_id", "8", "no");
INSERT INTO `wp_options` VALUES("341", "woocommerce_checkout_page_id", "9", "no");
INSERT INTO `wp_options` VALUES("342", "woocommerce_myaccount_page_id", "10", "no");
INSERT INTO `wp_options` VALUES("343", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wp_options` VALUES("344", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_options` VALUES("345", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_options` VALUES("346", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_options` VALUES("347", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wp_options` VALUES("348", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wp_options` VALUES("349", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wp_options` VALUES("350", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_options` VALUES("351", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wp_options` VALUES("352", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_options` VALUES("353", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_options` VALUES("354", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wp_options` VALUES("355", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_options` VALUES("356", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_options` VALUES("357", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("358", "woocommerce_allow_tracking", "no", "on");
INSERT INTO `wp_options` VALUES("359", "woocommerce_show_marketplace_suggestions", "yes", "no");
INSERT INTO `wp_options` VALUES("360", "woocommerce_analytics_enabled", "yes", "yes");
INSERT INTO `wp_options` VALUES("361", "woocommerce_navigation_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("362", "woocommerce_feature_product_block_editor_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("363", "woocommerce_custom_orders_table_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("364", "woocommerce_custom_orders_table_data_sync_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("365", "woocommerce_custom_orders_table_created", "yes", "yes");
INSERT INTO `wp_options` VALUES("366", "woocommerce_single_image_width", "1200", "yes");
INSERT INTO `wp_options` VALUES("367", "woocommerce_thumbnail_image_width", "600", "yes");
INSERT INTO `wp_options` VALUES("368", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `wp_options` VALUES("369", "woocommerce_demo_store", "no", "no");
INSERT INTO `wp_options` VALUES("370", "wc_downloads_approved_directories_mode", "enabled", "yes");
INSERT INTO `wp_options` VALUES("371", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:8:\"/product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("372", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wp_options` VALUES("373", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wp_options` VALUES("376", "default_product_cat", "29", "yes");
INSERT INTO `wp_options` VALUES("378", "woocommerce_refund_returns_page_id", "11", "yes");
INSERT INTO `wp_options` VALUES("381", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"پی‌پال\";s:11:\"description\";s:168:\"پرداخت از راه پی‌پال، اگر حساب کاربری پی‌پال ندارید، می توانید با کارت اعتباری پرداخت کنید.\";s:5:\"email\";s:25:\"sasanrahmanii98@gmail.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:25:\"sasanrahmanii98@gmail.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "yes");
INSERT INTO `wp_options` VALUES("382", "woocommerce_version", "10.1.0", "yes");
INSERT INTO `wp_options` VALUES("383", "woocommerce_db_version", "10.1.0", "yes");
INSERT INTO `wp_options` VALUES("384", "woocommerce_admin_install_timestamp", "1694017489", "yes");
INSERT INTO `wp_options` VALUES("385", "woocommerce_inbox_variant_assignment", "8", "yes");
INSERT INTO `wp_options` VALUES("390", "action_scheduler_lock_async-request-runner", "68a311b8a1fa17.62706836|1755517428", "yes");
INSERT INTO `wp_options` VALUES("391", "woocommerce_admin_notices", "a:1:{i:0;s:14:\"template_files\";}", "yes");
INSERT INTO `wp_options` VALUES("392", "wc_blocks_version", "11.8.0-dev", "yes");
INSERT INTO `wp_options` VALUES("393", "jetpack_connection_active_plugins", "a:1:{s:11:\"woocommerce\";a:1:{s:4:\"name\";s:14:\"ووکامرس\";}}", "yes");
INSERT INTO `wp_options` VALUES("394", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"sEZxR8qVwjWD7FgKPtI8CHGiyoP4AMDF\";}", "yes");
INSERT INTO `wp_options` VALUES("396", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("397", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("398", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("399", "widget_woocommerce_price_filter", "a:2:{i:6;a:1:{s:5:\"title\";s:8:\"قیمت\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("400", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("401", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("402", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("403", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("404", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("405", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("406", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("407", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("408", "widget_woodmart-user-panel", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("409", "widget_woodmart-woocommerce-layered-nav", "a:4:{i:7;a:12:{s:5:\"title\";s:8:\"برند\";s:9:\"attribute\";s:5:\"brand\";s:8:\"category\";a:1:{i:0;s:3:\"all\";}s:10:\"query_type\";s:3:\"and\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:5:\"style\";s:7:\"inherit\";s:5:\"shape\";s:7:\"inherit\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:3:\"off\";s:17:\"search_by_filters\";b:0;s:10:\"checkboxes\";s:3:\"off\";}i:8;a:12:{s:5:\"title\";s:6:\"رنگ\";s:9:\"attribute\";s:5:\"color\";s:8:\"category\";a:1:{i:0;s:3:\"all\";}s:10:\"query_type\";s:3:\"and\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:5:\"style\";s:7:\"inherit\";s:5:\"shape\";s:7:\"inherit\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:3:\"off\";s:17:\"search_by_filters\";b:0;s:10:\"checkboxes\";s:3:\"off\";}i:9;a:12:{s:5:\"title\";s:8:\"برند\";s:9:\"attribute\";s:5:\"brand\";s:8:\"category\";a:1:{i:0;s:3:\"all\";}s:10:\"query_type\";s:3:\"and\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:5:\"style\";s:7:\"inherit\";s:5:\"shape\";s:7:\"inherit\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:3:\"off\";s:17:\"search_by_filters\";b:0;s:10:\"checkboxes\";s:3:\"off\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("410", "widget_woodmart-woocommerce-sort-by", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("411", "widget_woodmart-price-filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("412", "widget_woodmart-ajax-search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("413", "widget_wd-widget-stock-status", "a:2:{i:10;a:4:{s:5:\"title\";s:30:\"محصولات کار کرده\";s:7:\"instock\";s:1:\"1\";s:6:\"onsale\";s:1:\"1\";s:11:\"onbackorder\";s:1:\"1\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("421", "wc_admin_show_legacy_coupon_menu", "0", "yes");
INSERT INTO `wp_options` VALUES("422", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `wp_options` VALUES("423", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;}", "no");
INSERT INTO `wp_options` VALUES("440", "jetpack_options", "a:1:{s:14:\"last_heartbeat\";i:1755451122;}", "yes");
INSERT INTO `wp_options` VALUES("461", "wpcf7", "a:2:{s:7:\"version\";s:5:\"6.1.1\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1694017506;s:7:\"version\";s:3:\"5.8\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("467", "widget_mc4wp_form_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("468", "mc4wp_version", "4.10.6", "yes");
INSERT INTO `wp_options` VALUES("470", "mc4wp_flash_messages", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("474", "woodmart_pa_color_swatch_size", "", "yes");
INSERT INTO `wp_options` VALUES("475", "woodmart_pa_color_swatch_style", "", "yes");
INSERT INTO `wp_options` VALUES("476", "woodmart_pa_color_swatch_dis_style", "", "yes");
INSERT INTO `wp_options` VALUES("477", "woodmart_pa_color_swatch_shape", "", "yes");
INSERT INTO `wp_options` VALUES("478", "woodmart_pa_color_show_on_product", "", "yes");
INSERT INTO `wp_options` VALUES("479", "woodmart_pa_color_thumbnail", "", "yes");
INSERT INTO `wp_options` VALUES("480", "woodmart_pa_color_hint", "", "yes");
INSERT INTO `wp_options` VALUES("481", "woodmart_pa_color_change_image", "", "yes");
INSERT INTO `wp_options` VALUES("482", "woodmart_pa_brand_swatch_size", "", "yes");
INSERT INTO `wp_options` VALUES("483", "woodmart_pa_brand_swatch_style", "", "yes");
INSERT INTO `wp_options` VALUES("484", "woodmart_pa_brand_swatch_dis_style", "", "yes");
INSERT INTO `wp_options` VALUES("485", "woodmart_pa_brand_swatch_shape", "", "yes");
INSERT INTO `wp_options` VALUES("486", "woodmart_pa_brand_show_on_product", "", "yes");
INSERT INTO `wp_options` VALUES("487", "woodmart_pa_brand_thumbnail", "", "yes");
INSERT INTO `wp_options` VALUES("488", "woodmart_pa_brand_hint", "", "yes");
INSERT INTO `wp_options` VALUES("489", "woodmart_pa_brand_change_image", "", "yes");
INSERT INTO `wp_options` VALUES("490", "woodmart_pa_size_swatch_size", "", "yes");
INSERT INTO `wp_options` VALUES("491", "woodmart_pa_size_swatch_style", "", "yes");
INSERT INTO `wp_options` VALUES("492", "woodmart_pa_size_swatch_dis_style", "", "yes");
INSERT INTO `wp_options` VALUES("493", "woodmart_pa_size_swatch_shape", "", "yes");
INSERT INTO `wp_options` VALUES("494", "woodmart_pa_size_show_on_product", "", "yes");
INSERT INTO `wp_options` VALUES("495", "woodmart_pa_size_thumbnail", "", "yes");
INSERT INTO `wp_options` VALUES("496", "woodmart_pa_size_hint", "", "yes");
INSERT INTO `wp_options` VALUES("497", "woodmart_pa_size_change_image", "", "yes");
INSERT INTO `wp_options` VALUES("498", "woodmart_import_attributes", "imported", "yes");
INSERT INTO `wp_options` VALUES("500", "wp_calendar_block_has_published_posts", "1", "yes");
INSERT INTO `wp_options` VALUES("511", "wd_imported_data_furniture2_base", "a:11:{s:9:\"all_posts\";a:261:{i:134;a:3:{s:3:\"old\";i:134;s:3:\"new\";i:134;s:9:\"post_type\";s:10:\"attachment\";}i:254;a:3:{s:3:\"old\";i:254;s:3:\"new\";i:254;s:9:\"post_type\";s:10:\"attachment\";}i:276;a:3:{s:3:\"old\";i:276;s:3:\"new\";i:276;s:9:\"post_type\";s:10:\"attachment\";}i:282;a:3:{s:3:\"old\";i:282;s:3:\"new\";i:282;s:9:\"post_type\";s:10:\"attachment\";}i:287;a:3:{s:3:\"old\";i:287;s:3:\"new\";i:287;s:9:\"post_type\";s:10:\"attachment\";}i:289;a:3:{s:3:\"old\";i:289;s:3:\"new\";i:289;s:9:\"post_type\";s:10:\"attachment\";}i:292;a:3:{s:3:\"old\";i:292;s:3:\"new\";i:292;s:9:\"post_type\";s:10:\"attachment\";}i:298;a:3:{s:3:\"old\";i:298;s:3:\"new\";i:298;s:9:\"post_type\";s:10:\"attachment\";}i:306;a:3:{s:3:\"old\";i:306;s:3:\"new\";i:306;s:9:\"post_type\";s:10:\"attachment\";}i:345;a:3:{s:3:\"old\";i:345;s:3:\"new\";i:345;s:9:\"post_type\";s:10:\"attachment\";}i:378;a:3:{s:3:\"old\";i:378;s:3:\"new\";i:378;s:9:\"post_type\";s:10:\"attachment\";}i:381;a:3:{s:3:\"old\";i:381;s:3:\"new\";i:381;s:9:\"post_type\";s:10:\"attachment\";}i:430;a:3:{s:3:\"old\";i:430;s:3:\"new\";i:430;s:9:\"post_type\";s:10:\"attachment\";}i:445;a:3:{s:3:\"old\";i:445;s:3:\"new\";i:445;s:9:\"post_type\";s:10:\"attachment\";}i:502;a:3:{s:3:\"old\";i:502;s:3:\"new\";i:502;s:9:\"post_type\";s:10:\"attachment\";}i:534;a:3:{s:3:\"old\";i:534;s:3:\"new\";i:534;s:9:\"post_type\";s:10:\"attachment\";}i:64;a:3:{s:3:\"old\";i:64;s:3:\"new\";i:64;s:9:\"post_type\";s:10:\"attachment\";}i:94;a:3:{s:3:\"old\";i:94;s:3:\"new\";i:94;s:9:\"post_type\";s:10:\"attachment\";}i:251;a:3:{s:3:\"old\";i:251;s:3:\"new\";i:251;s:9:\"post_type\";s:10:\"attachment\";}i:267;a:3:{s:3:\"old\";i:267;s:3:\"new\";i:267;s:9:\"post_type\";s:10:\"attachment\";}i:273;a:3:{s:3:\"old\";i:273;s:3:\"new\";i:273;s:9:\"post_type\";s:10:\"attachment\";}i:448;a:3:{s:3:\"old\";i:448;s:3:\"new\";i:448;s:9:\"post_type\";s:10:\"attachment\";}i:479;a:3:{s:3:\"old\";i:479;s:3:\"new\";i:479;s:9:\"post_type\";s:10:\"attachment\";}i:499;a:3:{s:3:\"old\";i:499;s:3:\"new\";i:499;s:9:\"post_type\";s:10:\"attachment\";}i:513;a:3:{s:3:\"old\";i:513;s:3:\"new\";i:513;s:9:\"post_type\";s:10:\"attachment\";}i:522;a:3:{s:3:\"old\";i:522;s:3:\"new\";i:522;s:9:\"post_type\";s:10:\"attachment\";}i:531;a:3:{s:3:\"old\";i:531;s:3:\"new\";i:531;s:9:\"post_type\";s:10:\"attachment\";}i:95;a:3:{s:3:\"old\";i:95;s:3:\"new\";i:95;s:9:\"post_type\";s:10:\"attachment\";}i:539;a:3:{s:3:\"old\";i:539;s:3:\"new\";i:539;s:9:\"post_type\";s:10:\"attachment\";}i:552;a:3:{s:3:\"old\";i:552;s:3:\"new\";i:552;s:9:\"post_type\";s:10:\"attachment\";}i:556;a:3:{s:3:\"old\";i:556;s:3:\"new\";i:556;s:9:\"post_type\";s:10:\"attachment\";}i:563;a:3:{s:3:\"old\";i:563;s:3:\"new\";i:563;s:9:\"post_type\";s:10:\"attachment\";}i:571;a:3:{s:3:\"old\";i:571;s:3:\"new\";i:571;s:9:\"post_type\";s:10:\"attachment\";}i:572;a:3:{s:3:\"old\";i:572;s:3:\"new\";i:572;s:9:\"post_type\";s:10:\"attachment\";}i:581;a:3:{s:3:\"old\";i:581;s:3:\"new\";i:581;s:9:\"post_type\";s:10:\"attachment\";}i:582;a:3:{s:3:\"old\";i:582;s:3:\"new\";i:582;s:9:\"post_type\";s:10:\"attachment\";}i:891;a:3:{s:3:\"old\";i:891;s:3:\"new\";i:891;s:9:\"post_type\";s:10:\"attachment\";}i:893;a:3:{s:3:\"old\";i:893;s:3:\"new\";i:893;s:9:\"post_type\";s:10:\"attachment\";}i:894;a:3:{s:3:\"old\";i:894;s:3:\"new\";i:894;s:9:\"post_type\";s:10:\"attachment\";}i:895;a:3:{s:3:\"old\";i:895;s:3:\"new\";i:895;s:9:\"post_type\";s:10:\"attachment\";}i:897;a:3:{s:3:\"old\";i:897;s:3:\"new\";i:897;s:9:\"post_type\";s:10:\"attachment\";}i:1126;a:3:{s:3:\"old\";i:1126;s:3:\"new\";i:1126;s:9:\"post_type\";s:10:\"attachment\";}i:1133;a:3:{s:3:\"old\";i:1133;s:3:\"new\";i:1133;s:9:\"post_type\";s:10:\"attachment\";}i:1134;a:3:{s:3:\"old\";i:1134;s:3:\"new\";i:1134;s:9:\"post_type\";s:10:\"attachment\";}i:1135;a:3:{s:3:\"old\";i:1135;s:3:\"new\";i:1135;s:9:\"post_type\";s:10:\"attachment\";}i:1136;a:3:{s:3:\"old\";i:1136;s:3:\"new\";i:1136;s:9:\"post_type\";s:10:\"attachment\";}i:1143;a:3:{s:3:\"old\";i:1143;s:3:\"new\";i:1143;s:9:\"post_type\";s:10:\"attachment\";}i:132;a:3:{s:3:\"old\";i:132;s:3:\"new\";i:132;s:9:\"post_type\";s:10:\"attachment\";}i:567;a:3:{s:3:\"old\";i:567;s:3:\"new\";i:567;s:9:\"post_type\";s:10:\"attachment\";}i:577;a:3:{s:3:\"old\";i:577;s:3:\"new\";i:577;s:9:\"post_type\";s:10:\"attachment\";}i:625;a:3:{s:3:\"old\";i:625;s:3:\"new\";i:625;s:9:\"post_type\";s:10:\"attachment\";}i:644;a:3:{s:3:\"old\";i:644;s:3:\"new\";i:644;s:9:\"post_type\";s:10:\"attachment\";}i:892;a:3:{s:3:\"old\";i:892;s:3:\"new\";i:892;s:9:\"post_type\";s:10:\"attachment\";}i:896;a:3:{s:3:\"old\";i:896;s:3:\"new\";i:896;s:9:\"post_type\";s:10:\"attachment\";}i:927;a:3:{s:3:\"old\";i:927;s:3:\"new\";i:927;s:9:\"post_type\";s:10:\"attachment\";}i:928;a:3:{s:3:\"old\";i:928;s:3:\"new\";i:928;s:9:\"post_type\";s:10:\"attachment\";}i:941;a:3:{s:3:\"old\";i:941;s:3:\"new\";i:941;s:9:\"post_type\";s:10:\"attachment\";}i:942;a:3:{s:3:\"old\";i:942;s:3:\"new\";i:942;s:9:\"post_type\";s:10:\"attachment\";}i:943;a:3:{s:3:\"old\";i:943;s:3:\"new\";i:943;s:9:\"post_type\";s:10:\"attachment\";}i:947;a:3:{s:3:\"old\";i:947;s:3:\"new\";i:947;s:9:\"post_type\";s:10:\"attachment\";}i:957;a:3:{s:3:\"old\";i:957;s:3:\"new\";i:957;s:9:\"post_type\";s:10:\"attachment\";}i:958;a:3:{s:3:\"old\";i:958;s:3:\"new\";i:958;s:9:\"post_type\";s:10:\"attachment\";}i:1157;a:3:{s:3:\"old\";i:1157;s:3:\"new\";i:1157;s:9:\"post_type\";s:10:\"attachment\";}i:133;a:3:{s:3:\"old\";i:133;s:3:\"new\";i:133;s:9:\"post_type\";s:10:\"attachment\";}i:804;a:3:{s:3:\"old\";i:804;s:3:\"new\";i:804;s:9:\"post_type\";s:10:\"attachment\";}i:811;a:3:{s:3:\"old\";i:811;s:3:\"new\";i:811;s:9:\"post_type\";s:10:\"attachment\";}i:898;a:3:{s:3:\"old\";i:898;s:3:\"new\";i:898;s:9:\"post_type\";s:10:\"attachment\";}i:899;a:3:{s:3:\"old\";i:899;s:3:\"new\";i:899;s:9:\"post_type\";s:10:\"attachment\";}i:904;a:3:{s:3:\"old\";i:904;s:3:\"new\";i:904;s:9:\"post_type\";s:10:\"attachment\";}i:905;a:3:{s:3:\"old\";i:905;s:3:\"new\";i:905;s:9:\"post_type\";s:10:\"attachment\";}i:906;a:3:{s:3:\"old\";i:906;s:3:\"new\";i:906;s:9:\"post_type\";s:10:\"attachment\";}i:907;a:3:{s:3:\"old\";i:907;s:3:\"new\";i:907;s:9:\"post_type\";s:10:\"attachment\";}i:917;a:3:{s:3:\"old\";i:917;s:3:\"new\";i:917;s:9:\"post_type\";s:10:\"attachment\";}i:918;a:3:{s:3:\"old\";i:918;s:3:\"new\";i:918;s:9:\"post_type\";s:10:\"attachment\";}i:919;a:3:{s:3:\"old\";i:919;s:3:\"new\";i:919;s:9:\"post_type\";s:10:\"attachment\";}i:920;a:3:{s:3:\"old\";i:920;s:3:\"new\";i:920;s:9:\"post_type\";s:10:\"attachment\";}i:317;a:3:{s:3:\"old\";i:317;s:3:\"new\";i:317;s:9:\"post_type\";s:10:\"attachment\";}i:363;a:3:{s:3:\"old\";i:363;s:3:\"new\";i:363;s:9:\"post_type\";s:10:\"attachment\";}i:393;a:3:{s:3:\"old\";i:393;s:3:\"new\";i:393;s:9:\"post_type\";s:10:\"attachment\";}i:396;a:3:{s:3:\"old\";i:396;s:3:\"new\";i:396;s:9:\"post_type\";s:10:\"attachment\";}i:398;a:3:{s:3:\"old\";i:398;s:3:\"new\";i:398;s:9:\"post_type\";s:10:\"attachment\";}i:400;a:3:{s:3:\"old\";i:400;s:3:\"new\";i:400;s:9:\"post_type\";s:10:\"attachment\";}i:405;a:3:{s:3:\"old\";i:405;s:3:\"new\";i:405;s:9:\"post_type\";s:10:\"attachment\";}i:419;a:3:{s:3:\"old\";i:419;s:3:\"new\";i:419;s:9:\"post_type\";s:10:\"attachment\";}i:424;a:3:{s:3:\"old\";i:424;s:3:\"new\";i:424;s:9:\"post_type\";s:10:\"attachment\";}i:451;a:3:{s:3:\"old\";i:451;s:3:\"new\";i:451;s:9:\"post_type\";s:10:\"attachment\";}i:372;a:3:{s:3:\"old\";i:372;s:3:\"new\";i:372;s:9:\"post_type\";s:10:\"attachment\";}i:375;a:3:{s:3:\"old\";i:375;s:3:\"new\";i:375;s:9:\"post_type\";s:10:\"attachment\";}i:433;a:3:{s:3:\"old\";i:433;s:3:\"new\";i:433;s:9:\"post_type\";s:10:\"attachment\";}i:487;a:3:{s:3:\"old\";i:487;s:3:\"new\";i:487;s:9:\"post_type\";s:10:\"attachment\";}i:279;a:3:{s:3:\"old\";i:279;s:3:\"new\";i:279;s:9:\"post_type\";s:10:\"attachment\";}i:354;a:3:{s:3:\"old\";i:354;s:3:\"new\";i:354;s:9:\"post_type\";s:10:\"attachment\";}i:369;a:3:{s:3:\"old\";i:369;s:3:\"new\";i:369;s:9:\"post_type\";s:10:\"attachment\";}i:427;a:3:{s:3:\"old\";i:427;s:3:\"new\";i:427;s:9:\"post_type\";s:10:\"attachment\";}i:485;a:3:{s:3:\"old\";i:485;s:3:\"new\";i:485;s:9:\"post_type\";s:10:\"attachment\";}i:264;a:3:{s:3:\"old\";i:264;s:3:\"new\";i:264;s:9:\"post_type\";s:10:\"attachment\";}i:309;a:3:{s:3:\"old\";i:309;s:3:\"new\";i:309;s:9:\"post_type\";s:10:\"attachment\";}i:342;a:3:{s:3:\"old\";i:342;s:3:\"new\";i:342;s:9:\"post_type\";s:10:\"attachment\";}i:351;a:3:{s:3:\"old\";i:351;s:3:\"new\";i:351;s:9:\"post_type\";s:10:\"attachment\";}i:439;a:3:{s:3:\"old\";i:439;s:3:\"new\";i:439;s:9:\"post_type\";s:10:\"attachment\";}i:482;a:3:{s:3:\"old\";i:482;s:3:\"new\";i:482;s:9:\"post_type\";s:10:\"attachment\";}i:516;a:3:{s:3:\"old\";i:516;s:3:\"new\";i:516;s:9:\"post_type\";s:10:\"attachment\";}i:301;a:3:{s:3:\"old\";i:301;s:3:\"new\";i:301;s:9:\"post_type\";s:10:\"attachment\";}i:303;a:3:{s:3:\"old\";i:303;s:3:\"new\";i:303;s:9:\"post_type\";s:10:\"attachment\";}i:525;a:3:{s:3:\"old\";i:525;s:3:\"new\";i:525;s:9:\"post_type\";s:10:\"attachment\";}i:493;a:3:{s:3:\"old\";i:493;s:3:\"new\";i:493;s:9:\"post_type\";s:10:\"attachment\";}i:33;a:3:{s:3:\"old\";i:33;s:3:\"new\";i:33;s:9:\"post_type\";s:10:\"attachment\";}i:35;a:3:{s:3:\"old\";i:35;s:3:\"new\";i:35;s:9:\"post_type\";s:10:\"attachment\";}i:38;a:3:{s:3:\"old\";i:38;s:3:\"new\";i:38;s:9:\"post_type\";s:10:\"attachment\";}i:40;a:3:{s:3:\"old\";i:40;s:3:\"new\";i:40;s:9:\"post_type\";s:10:\"attachment\";}i:43;a:3:{s:3:\"old\";i:43;s:3:\"new\";i:43;s:9:\"post_type\";s:10:\"attachment\";}i:45;a:3:{s:3:\"old\";i:45;s:3:\"new\";i:45;s:9:\"post_type\";s:10:\"attachment\";}i:48;a:3:{s:3:\"old\";i:48;s:3:\"new\";i:48;s:9:\"post_type\";s:10:\"attachment\";}i:50;a:3:{s:3:\"old\";i:50;s:3:\"new\";i:50;s:9:\"post_type\";s:10:\"attachment\";}i:110;a:3:{s:3:\"old\";i:110;s:3:\"new\";i:110;s:9:\"post_type\";s:10:\"attachment\";}i:120;a:3:{s:3:\"old\";i:120;s:3:\"new\";i:120;s:9:\"post_type\";s:10:\"attachment\";}i:121;a:3:{s:3:\"old\";i:121;s:3:\"new\";i:121;s:9:\"post_type\";s:10:\"attachment\";}i:124;a:3:{s:3:\"old\";i:124;s:3:\"new\";i:124;s:9:\"post_type\";s:10:\"attachment\";}i:125;a:3:{s:3:\"old\";i:125;s:3:\"new\";i:125;s:9:\"post_type\";s:10:\"attachment\";}i:126;a:3:{s:3:\"old\";i:126;s:3:\"new\";i:126;s:9:\"post_type\";s:10:\"attachment\";}i:128;a:3:{s:3:\"old\";i:128;s:3:\"new\";i:128;s:9:\"post_type\";s:10:\"attachment\";}i:129;a:3:{s:3:\"old\";i:129;s:3:\"new\";i:129;s:9:\"post_type\";s:10:\"attachment\";}i:130;a:3:{s:3:\"old\";i:130;s:3:\"new\";i:130;s:9:\"post_type\";s:10:\"attachment\";}i:131;a:3:{s:3:\"old\";i:131;s:3:\"new\";i:131;s:9:\"post_type\";s:10:\"attachment\";}i:135;a:3:{s:3:\"old\";i:135;s:3:\"new\";i:135;s:9:\"post_type\";s:10:\"attachment\";}i:65;a:3:{s:3:\"old\";i:65;s:3:\"new\";i:65;s:9:\"post_type\";s:10:\"attachment\";}i:72;a:3:{s:3:\"old\";i:72;s:3:\"new\";i:72;s:9:\"post_type\";s:10:\"attachment\";}i:136;a:3:{s:3:\"old\";i:136;s:3:\"new\";i:136;s:9:\"post_type\";s:10:\"attachment\";}i:139;a:3:{s:3:\"old\";i:139;s:3:\"new\";i:139;s:9:\"post_type\";s:10:\"attachment\";}i:140;a:3:{s:3:\"old\";i:140;s:3:\"new\";i:140;s:9:\"post_type\";s:10:\"attachment\";}i:141;a:3:{s:3:\"old\";i:141;s:3:\"new\";i:141;s:9:\"post_type\";s:10:\"attachment\";}i:142;a:3:{s:3:\"old\";i:142;s:3:\"new\";i:142;s:9:\"post_type\";s:10:\"attachment\";}i:143;a:3:{s:3:\"old\";i:143;s:3:\"new\";i:143;s:9:\"post_type\";s:10:\"attachment\";}i:144;a:3:{s:3:\"old\";i:144;s:3:\"new\";i:144;s:9:\"post_type\";s:10:\"attachment\";}i:145;a:3:{s:3:\"old\";i:145;s:3:\"new\";i:145;s:9:\"post_type\";s:10:\"attachment\";}i:146;a:3:{s:3:\"old\";i:146;s:3:\"new\";i:146;s:9:\"post_type\";s:10:\"attachment\";}i:147;a:3:{s:3:\"old\";i:147;s:3:\"new\";i:147;s:9:\"post_type\";s:10:\"attachment\";}i:148;a:3:{s:3:\"old\";i:148;s:3:\"new\";i:148;s:9:\"post_type\";s:10:\"attachment\";}i:979;a:3:{s:3:\"old\";i:979;s:3:\"new\";i:979;s:9:\"post_type\";s:10:\"attachment\";}i:993;a:3:{s:3:\"old\";i:993;s:3:\"new\";i:993;s:9:\"post_type\";s:10:\"attachment\";}i:994;a:3:{s:3:\"old\";i:994;s:3:\"new\";i:994;s:9:\"post_type\";s:10:\"attachment\";}i:1014;a:3:{s:3:\"old\";i:1014;s:3:\"new\";i:1014;s:9:\"post_type\";s:10:\"attachment\";}i:1016;a:3:{s:3:\"old\";i:1016;s:3:\"new\";i:1016;s:9:\"post_type\";s:10:\"attachment\";}i:1021;a:3:{s:3:\"old\";i:1021;s:3:\"new\";i:1044;s:9:\"post_type\";s:10:\"attachment\";}i:1217;a:3:{s:3:\"old\";i:1217;s:3:\"new\";i:1217;s:9:\"post_type\";s:10:\"attachment\";}i:1365;a:3:{s:3:\"old\";i:1365;s:3:\"new\";i:1365;s:9:\"post_type\";s:10:\"attachment\";}i:1412;a:3:{s:3:\"old\";i:1412;s:3:\"new\";i:1412;s:9:\"post_type\";s:10:\"attachment\";}i:1413;a:3:{s:3:\"old\";i:1413;s:3:\"new\";i:1413;s:9:\"post_type\";s:10:\"attachment\";}i:1414;a:3:{s:3:\"old\";i:1414;s:3:\"new\";i:1414;s:9:\"post_type\";s:10:\"attachment\";}i:1415;a:3:{s:3:\"old\";i:1415;s:3:\"new\";i:1415;s:9:\"post_type\";s:10:\"attachment\";}i:1416;a:3:{s:3:\"old\";i:1416;s:3:\"new\";i:1416;s:9:\"post_type\";s:10:\"attachment\";}i:102;a:3:{s:3:\"old\";i:102;s:3:\"new\";i:102;s:9:\"post_type\";s:10:\"attachment\";}i:852;a:3:{s:3:\"old\";i:852;s:3:\"new\";i:852;s:9:\"post_type\";s:10:\"attachment\";}i:853;a:3:{s:3:\"old\";i:853;s:3:\"new\";i:853;s:9:\"post_type\";s:10:\"attachment\";}i:854;a:3:{s:3:\"old\";i:854;s:3:\"new\";i:854;s:9:\"post_type\";s:10:\"attachment\";}i:865;a:3:{s:3:\"old\";i:865;s:3:\"new\";i:865;s:9:\"post_type\";s:10:\"attachment\";}i:866;a:3:{s:3:\"old\";i:866;s:3:\"new\";i:866;s:9:\"post_type\";s:10:\"attachment\";}i:867;a:3:{s:3:\"old\";i:867;s:3:\"new\";i:867;s:9:\"post_type\";s:10:\"attachment\";}i:868;a:3:{s:3:\"old\";i:868;s:3:\"new\";i:868;s:9:\"post_type\";s:10:\"attachment\";}i:978;a:3:{s:3:\"old\";i:978;s:3:\"new\";i:978;s:9:\"post_type\";s:10:\"attachment\";}i:991;a:3:{s:3:\"old\";i:991;s:3:\"new\";i:991;s:9:\"post_type\";s:10:\"attachment\";}i:1002;a:3:{s:3:\"old\";i:1002;s:3:\"new\";i:1002;s:9:\"post_type\";s:10:\"attachment\";}i:1008;a:3:{s:3:\"old\";i:1008;s:3:\"new\";i:1008;s:9:\"post_type\";s:10:\"attachment\";}i:769;a:3:{s:3:\"old\";i:769;s:3:\"new\";i:769;s:9:\"post_type\";s:10:\"attachment\";}i:779;a:3:{s:3:\"old\";i:779;s:3:\"new\";i:779;s:9:\"post_type\";s:10:\"attachment\";}i:780;a:3:{s:3:\"old\";i:780;s:3:\"new\";i:780;s:9:\"post_type\";s:10:\"attachment\";}i:781;a:3:{s:3:\"old\";i:781;s:3:\"new\";i:781;s:9:\"post_type\";s:10:\"attachment\";}i:782;a:3:{s:3:\"old\";i:782;s:3:\"new\";i:782;s:9:\"post_type\";s:10:\"attachment\";}i:851;a:3:{s:3:\"old\";i:851;s:3:\"new\";i:851;s:9:\"post_type\";s:10:\"attachment\";}i:21;a:4:{s:3:\"old\";i:21;s:3:\"new\";i:21;s:9:\"post_type\";s:4:\"page\";s:4:\"type\";s:9:\"elementor\";}i:23;a:4:{s:3:\"old\";i:23;s:3:\"new\";i:23;s:9:\"post_type\";s:4:\"page\";s:4:\"type\";s:9:\"elementor\";}i:498;a:4:{s:3:\"old\";i:498;s:3:\"new\";i:498;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:500;a:3:{s:3:\"old\";i:500;s:3:\"new\";i:500;s:9:\"post_type\";s:17:\"product_variation\";}i:501;a:3:{s:3:\"old\";i:501;s:3:\"new\";i:501;s:9:\"post_type\";s:17:\"product_variation\";}i:512;a:4:{s:3:\"old\";i:512;s:3:\"new\";i:512;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:515;a:4:{s:3:\"old\";i:515;s:3:\"new\";i:515;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:521;a:4:{s:3:\"old\";i:521;s:3:\"new\";i:521;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:524;a:4:{s:3:\"old\";i:524;s:3:\"new\";i:524;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:530;a:4:{s:3:\"old\";i:530;s:3:\"new\";i:530;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:533;a:4:{s:3:\"old\";i:533;s:3:\"new\";i:533;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:766;a:4:{s:3:\"old\";i:766;s:3:\"new\";i:766;s:9:\"post_type\";s:9:\"cms_block\";s:4:\"type\";s:9:\"elementor\";}i:849;a:4:{s:3:\"old\";i:849;s:3:\"new\";i:849;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:864;a:4:{s:3:\"old\";i:864;s:3:\"new\";i:864;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:976;a:4:{s:3:\"old\";i:976;s:3:\"new\";i:976;s:9:\"post_type\";s:4:\"post\";s:4:\"type\";s:9:\"elementor\";}i:990;a:4:{s:3:\"old\";i:990;s:3:\"new\";i:990;s:9:\"post_type\";s:4:\"post\";s:4:\"type\";s:9:\"elementor\";}i:1001;a:4:{s:3:\"old\";i:1001;s:3:\"new\";i:1001;s:9:\"post_type\";s:4:\"post\";s:4:\"type\";s:9:\"elementor\";}i:1007;a:4:{s:3:\"old\";i:1007;s:3:\"new\";i:1007;s:9:\"post_type\";s:4:\"post\";s:4:\"type\";s:9:\"elementor\";}i:1013;a:4:{s:3:\"old\";i:1013;s:3:\"new\";i:1013;s:9:\"post_type\";s:4:\"post\";s:4:\"type\";s:9:\"elementor\";}i:1020;a:4:{s:3:\"old\";i:1020;s:3:\"new\";i:1020;s:9:\"post_type\";s:4:\"post\";s:4:\"type\";s:9:\"elementor\";}i:395;a:4:{s:3:\"old\";i:395;s:3:\"new\";i:395;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:397;a:3:{s:3:\"old\";i:397;s:3:\"new\";i:397;s:9:\"post_type\";s:17:\"product_variation\";}i:399;a:3:{s:3:\"old\";i:399;s:3:\"new\";i:399;s:9:\"post_type\";s:17:\"product_variation\";}i:401;a:3:{s:3:\"old\";i:401;s:3:\"new\";i:401;s:9:\"post_type\";s:17:\"product_variation\";}i:403;a:3:{s:3:\"old\";i:403;s:3:\"new\";i:403;s:9:\"post_type\";s:17:\"product_variation\";}i:404;a:3:{s:3:\"old\";i:404;s:3:\"new\";i:404;s:9:\"post_type\";s:17:\"product_variation\";}i:421;a:4:{s:3:\"old\";i:421;s:3:\"new\";i:421;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:426;a:4:{s:3:\"old\";i:426;s:3:\"new\";i:426;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:429;a:4:{s:3:\"old\";i:429;s:3:\"new\";i:429;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:432;a:4:{s:3:\"old\";i:432;s:3:\"new\";i:432;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:438;a:4:{s:3:\"old\";i:438;s:3:\"new\";i:438;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:444;a:4:{s:3:\"old\";i:444;s:3:\"new\";i:444;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:447;a:4:{s:3:\"old\";i:447;s:3:\"new\";i:447;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:450;a:4:{s:3:\"old\";i:450;s:3:\"new\";i:450;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:478;a:4:{s:3:\"old\";i:478;s:3:\"new\";i:478;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:481;a:4:{s:3:\"old\";i:481;s:3:\"new\";i:481;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:483;a:3:{s:3:\"old\";i:483;s:3:\"new\";i:483;s:9:\"post_type\";s:17:\"product_variation\";}i:484;a:3:{s:3:\"old\";i:484;s:3:\"new\";i:484;s:9:\"post_type\";s:17:\"product_variation\";}i:486;a:3:{s:3:\"old\";i:486;s:3:\"new\";i:486;s:9:\"post_type\";s:17:\"product_variation\";}i:489;a:4:{s:3:\"old\";i:489;s:3:\"new\";i:489;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:285;a:4:{s:3:\"old\";i:285;s:3:\"new\";i:285;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:288;a:4:{s:3:\"old\";i:288;s:3:\"new\";i:288;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:291;a:4:{s:3:\"old\";i:291;s:3:\"new\";i:291;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:297;a:4:{s:3:\"old\";i:297;s:3:\"new\";i:297;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:299;a:3:{s:3:\"old\";i:299;s:3:\"new\";i:299;s:9:\"post_type\";s:17:\"product_variation\";}i:300;a:3:{s:3:\"old\";i:300;s:3:\"new\";i:300;s:9:\"post_type\";s:17:\"product_variation\";}i:302;a:3:{s:3:\"old\";i:302;s:3:\"new\";i:302;s:9:\"post_type\";s:17:\"product_variation\";}i:305;a:4:{s:3:\"old\";i:305;s:3:\"new\";i:305;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:308;a:4:{s:3:\"old\";i:308;s:3:\"new\";i:308;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:341;a:4:{s:3:\"old\";i:341;s:3:\"new\";i:341;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:344;a:4:{s:3:\"old\";i:344;s:3:\"new\";i:344;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:350;a:4:{s:3:\"old\";i:350;s:3:\"new\";i:350;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:353;a:4:{s:3:\"old\";i:353;s:3:\"new\";i:353;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:362;a:4:{s:3:\"old\";i:362;s:3:\"new\";i:362;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:368;a:4:{s:3:\"old\";i:368;s:3:\"new\";i:368;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:371;a:4:{s:3:\"old\";i:371;s:3:\"new\";i:371;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:374;a:4:{s:3:\"old\";i:374;s:3:\"new\";i:374;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:377;a:4:{s:3:\"old\";i:377;s:3:\"new\";i:377;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:380;a:4:{s:3:\"old\";i:380;s:3:\"new\";i:380;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:392;a:4:{s:3:\"old\";i:392;s:3:\"new\";i:392;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:6;a:3:{s:3:\"old\";i:6;s:3:\"new\";i:1021;s:9:\"post_type\";s:18:\"wpcf7_contact_form\";}i:10;a:3:{s:3:\"old\";i:10;s:3:\"new\";i:1022;s:9:\"post_type\";s:4:\"page\";}i:15;a:4:{s:3:\"old\";i:15;s:3:\"new\";i:15;s:9:\"post_type\";s:4:\"page\";s:4:\"type\";s:9:\"elementor\";}i:18;a:3:{s:3:\"old\";i:18;s:3:\"new\";i:18;s:9:\"post_type\";s:4:\"page\";}i:25;a:4:{s:3:\"old\";i:25;s:3:\"new\";i:25;s:9:\"post_type\";s:4:\"page\";s:4:\"type\";s:9:\"elementor\";}i:27;a:4:{s:3:\"old\";i:27;s:3:\"new\";i:27;s:9:\"post_type\";s:4:\"page\";s:4:\"type\";s:9:\"elementor\";}i:29;a:4:{s:3:\"old\";i:29;s:3:\"new\";i:29;s:9:\"post_type\";s:4:\"page\";s:4:\"type\";s:9:\"elementor\";}i:31;a:4:{s:3:\"old\";i:31;s:3:\"new\";i:31;s:9:\"post_type\";s:4:\"page\";s:4:\"type\";s:9:\"elementor\";}i:54;a:3:{s:3:\"old\";i:54;s:3:\"new\";i:1023;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:56;a:3:{s:3:\"old\";i:56;s:3:\"new\";i:1024;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:59;a:3:{s:3:\"old\";i:59;s:3:\"new\";i:1025;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:61;a:3:{s:3:\"old\";i:61;s:3:\"new\";i:1026;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:250;a:4:{s:3:\"old\";i:250;s:3:\"new\";i:250;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:266;a:4:{s:3:\"old\";i:266;s:3:\"new\";i:266;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:272;a:4:{s:3:\"old\";i:272;s:3:\"new\";i:272;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:275;a:4:{s:3:\"old\";i:275;s:3:\"new\";i:275;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:688;a:4:{s:3:\"old\";i:688;s:3:\"new\";i:688;s:9:\"post_type\";s:9:\"cms_block\";s:4:\"type\";s:9:\"elementor\";}i:1206;a:3:{s:3:\"old\";i:1206;s:3:\"new\";i:1027;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:1207;a:3:{s:3:\"old\";i:1207;s:3:\"new\";i:1028;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:1208;a:3:{s:3:\"old\";i:1208;s:3:\"new\";i:1029;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:77;a:3:{s:3:\"old\";i:77;s:3:\"new\";i:1030;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:78;a:3:{s:3:\"old\";i:78;s:3:\"new\";i:1031;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:79;a:3:{s:3:\"old\";i:79;s:3:\"new\";i:1032;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:80;a:3:{s:3:\"old\";i:80;s:3:\"new\";i:1033;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:81;a:3:{s:3:\"old\";i:81;s:3:\"new\";i:1034;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:82;a:3:{s:3:\"old\";i:82;s:3:\"new\";i:1035;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:83;a:3:{s:3:\"old\";i:83;s:3:\"new\";i:1036;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:84;a:3:{s:3:\"old\";i:84;s:3:\"new\";i:1037;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:85;a:3:{s:3:\"old\";i:85;s:3:\"new\";i:1038;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:1205;a:3:{s:3:\"old\";i:1205;s:3:\"new\";i:1039;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:1209;a:3:{s:3:\"old\";i:1209;s:3:\"new\";i:1040;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:1210;a:3:{s:3:\"old\";i:1210;s:3:\"new\";i:1041;s:9:\"post_type\";s:13:\"nav_menu_item\";}}s:10:\"attachment\";a:169:{i:134;a:3:{s:3:\"old\";i:134;s:3:\"new\";i:134;s:9:\"post_type\";s:10:\"attachment\";}i:254;a:3:{s:3:\"old\";i:254;s:3:\"new\";i:254;s:9:\"post_type\";s:10:\"attachment\";}i:276;a:3:{s:3:\"old\";i:276;s:3:\"new\";i:276;s:9:\"post_type\";s:10:\"attachment\";}i:282;a:3:{s:3:\"old\";i:282;s:3:\"new\";i:282;s:9:\"post_type\";s:10:\"attachment\";}i:287;a:3:{s:3:\"old\";i:287;s:3:\"new\";i:287;s:9:\"post_type\";s:10:\"attachment\";}i:289;a:3:{s:3:\"old\";i:289;s:3:\"new\";i:289;s:9:\"post_type\";s:10:\"attachment\";}i:292;a:3:{s:3:\"old\";i:292;s:3:\"new\";i:292;s:9:\"post_type\";s:10:\"attachment\";}i:298;a:3:{s:3:\"old\";i:298;s:3:\"new\";i:298;s:9:\"post_type\";s:10:\"attachment\";}i:306;a:3:{s:3:\"old\";i:306;s:3:\"new\";i:306;s:9:\"post_type\";s:10:\"attachment\";}i:345;a:3:{s:3:\"old\";i:345;s:3:\"new\";i:345;s:9:\"post_type\";s:10:\"attachment\";}i:378;a:3:{s:3:\"old\";i:378;s:3:\"new\";i:378;s:9:\"post_type\";s:10:\"attachment\";}i:381;a:3:{s:3:\"old\";i:381;s:3:\"new\";i:381;s:9:\"post_type\";s:10:\"attachment\";}i:430;a:3:{s:3:\"old\";i:430;s:3:\"new\";i:430;s:9:\"post_type\";s:10:\"attachment\";}i:445;a:3:{s:3:\"old\";i:445;s:3:\"new\";i:445;s:9:\"post_type\";s:10:\"attachment\";}i:502;a:3:{s:3:\"old\";i:502;s:3:\"new\";i:502;s:9:\"post_type\";s:10:\"attachment\";}i:534;a:3:{s:3:\"old\";i:534;s:3:\"new\";i:534;s:9:\"post_type\";s:10:\"attachment\";}i:64;a:3:{s:3:\"old\";i:64;s:3:\"new\";i:64;s:9:\"post_type\";s:10:\"attachment\";}i:94;a:3:{s:3:\"old\";i:94;s:3:\"new\";i:94;s:9:\"post_type\";s:10:\"attachment\";}i:251;a:3:{s:3:\"old\";i:251;s:3:\"new\";i:251;s:9:\"post_type\";s:10:\"attachment\";}i:267;a:3:{s:3:\"old\";i:267;s:3:\"new\";i:267;s:9:\"post_type\";s:10:\"attachment\";}i:273;a:3:{s:3:\"old\";i:273;s:3:\"new\";i:273;s:9:\"post_type\";s:10:\"attachment\";}i:448;a:3:{s:3:\"old\";i:448;s:3:\"new\";i:448;s:9:\"post_type\";s:10:\"attachment\";}i:479;a:3:{s:3:\"old\";i:479;s:3:\"new\";i:479;s:9:\"post_type\";s:10:\"attachment\";}i:499;a:3:{s:3:\"old\";i:499;s:3:\"new\";i:499;s:9:\"post_type\";s:10:\"attachment\";}i:513;a:3:{s:3:\"old\";i:513;s:3:\"new\";i:513;s:9:\"post_type\";s:10:\"attachment\";}i:522;a:3:{s:3:\"old\";i:522;s:3:\"new\";i:522;s:9:\"post_type\";s:10:\"attachment\";}i:531;a:3:{s:3:\"old\";i:531;s:3:\"new\";i:531;s:9:\"post_type\";s:10:\"attachment\";}i:95;a:3:{s:3:\"old\";i:95;s:3:\"new\";i:95;s:9:\"post_type\";s:10:\"attachment\";}i:539;a:3:{s:3:\"old\";i:539;s:3:\"new\";i:539;s:9:\"post_type\";s:10:\"attachment\";}i:552;a:3:{s:3:\"old\";i:552;s:3:\"new\";i:552;s:9:\"post_type\";s:10:\"attachment\";}i:556;a:3:{s:3:\"old\";i:556;s:3:\"new\";i:556;s:9:\"post_type\";s:10:\"attachment\";}i:563;a:3:{s:3:\"old\";i:563;s:3:\"new\";i:563;s:9:\"post_type\";s:10:\"attachment\";}i:571;a:3:{s:3:\"old\";i:571;s:3:\"new\";i:571;s:9:\"post_type\";s:10:\"attachment\";}i:572;a:3:{s:3:\"old\";i:572;s:3:\"new\";i:572;s:9:\"post_type\";s:10:\"attachment\";}i:581;a:3:{s:3:\"old\";i:581;s:3:\"new\";i:581;s:9:\"post_type\";s:10:\"attachment\";}i:582;a:3:{s:3:\"old\";i:582;s:3:\"new\";i:582;s:9:\"post_type\";s:10:\"attachment\";}i:891;a:3:{s:3:\"old\";i:891;s:3:\"new\";i:891;s:9:\"post_type\";s:10:\"attachment\";}i:893;a:3:{s:3:\"old\";i:893;s:3:\"new\";i:893;s:9:\"post_type\";s:10:\"attachment\";}i:894;a:3:{s:3:\"old\";i:894;s:3:\"new\";i:894;s:9:\"post_type\";s:10:\"attachment\";}i:895;a:3:{s:3:\"old\";i:895;s:3:\"new\";i:895;s:9:\"post_type\";s:10:\"attachment\";}i:897;a:3:{s:3:\"old\";i:897;s:3:\"new\";i:897;s:9:\"post_type\";s:10:\"attachment\";}i:1126;a:3:{s:3:\"old\";i:1126;s:3:\"new\";i:1126;s:9:\"post_type\";s:10:\"attachment\";}i:1133;a:3:{s:3:\"old\";i:1133;s:3:\"new\";i:1133;s:9:\"post_type\";s:10:\"attachment\";}i:1134;a:3:{s:3:\"old\";i:1134;s:3:\"new\";i:1134;s:9:\"post_type\";s:10:\"attachment\";}i:1135;a:3:{s:3:\"old\";i:1135;s:3:\"new\";i:1135;s:9:\"post_type\";s:10:\"attachment\";}i:1136;a:3:{s:3:\"old\";i:1136;s:3:\"new\";i:1136;s:9:\"post_type\";s:10:\"attachment\";}i:1143;a:3:{s:3:\"old\";i:1143;s:3:\"new\";i:1143;s:9:\"post_type\";s:10:\"attachment\";}i:132;a:3:{s:3:\"old\";i:132;s:3:\"new\";i:132;s:9:\"post_type\";s:10:\"attachment\";}i:567;a:3:{s:3:\"old\";i:567;s:3:\"new\";i:567;s:9:\"post_type\";s:10:\"attachment\";}i:577;a:3:{s:3:\"old\";i:577;s:3:\"new\";i:577;s:9:\"post_type\";s:10:\"attachment\";}i:625;a:3:{s:3:\"old\";i:625;s:3:\"new\";i:625;s:9:\"post_type\";s:10:\"attachment\";}i:644;a:3:{s:3:\"old\";i:644;s:3:\"new\";i:644;s:9:\"post_type\";s:10:\"attachment\";}i:892;a:3:{s:3:\"old\";i:892;s:3:\"new\";i:892;s:9:\"post_type\";s:10:\"attachment\";}i:896;a:3:{s:3:\"old\";i:896;s:3:\"new\";i:896;s:9:\"post_type\";s:10:\"attachment\";}i:927;a:3:{s:3:\"old\";i:927;s:3:\"new\";i:927;s:9:\"post_type\";s:10:\"attachment\";}i:928;a:3:{s:3:\"old\";i:928;s:3:\"new\";i:928;s:9:\"post_type\";s:10:\"attachment\";}i:941;a:3:{s:3:\"old\";i:941;s:3:\"new\";i:941;s:9:\"post_type\";s:10:\"attachment\";}i:942;a:3:{s:3:\"old\";i:942;s:3:\"new\";i:942;s:9:\"post_type\";s:10:\"attachment\";}i:943;a:3:{s:3:\"old\";i:943;s:3:\"new\";i:943;s:9:\"post_type\";s:10:\"attachment\";}i:947;a:3:{s:3:\"old\";i:947;s:3:\"new\";i:947;s:9:\"post_type\";s:10:\"attachment\";}i:957;a:3:{s:3:\"old\";i:957;s:3:\"new\";i:957;s:9:\"post_type\";s:10:\"attachment\";}i:958;a:3:{s:3:\"old\";i:958;s:3:\"new\";i:958;s:9:\"post_type\";s:10:\"attachment\";}i:1157;a:3:{s:3:\"old\";i:1157;s:3:\"new\";i:1157;s:9:\"post_type\";s:10:\"attachment\";}i:133;a:3:{s:3:\"old\";i:133;s:3:\"new\";i:133;s:9:\"post_type\";s:10:\"attachment\";}i:804;a:3:{s:3:\"old\";i:804;s:3:\"new\";i:804;s:9:\"post_type\";s:10:\"attachment\";}i:811;a:3:{s:3:\"old\";i:811;s:3:\"new\";i:811;s:9:\"post_type\";s:10:\"attachment\";}i:898;a:3:{s:3:\"old\";i:898;s:3:\"new\";i:898;s:9:\"post_type\";s:10:\"attachment\";}i:899;a:3:{s:3:\"old\";i:899;s:3:\"new\";i:899;s:9:\"post_type\";s:10:\"attachment\";}i:904;a:3:{s:3:\"old\";i:904;s:3:\"new\";i:904;s:9:\"post_type\";s:10:\"attachment\";}i:905;a:3:{s:3:\"old\";i:905;s:3:\"new\";i:905;s:9:\"post_type\";s:10:\"attachment\";}i:906;a:3:{s:3:\"old\";i:906;s:3:\"new\";i:906;s:9:\"post_type\";s:10:\"attachment\";}i:907;a:3:{s:3:\"old\";i:907;s:3:\"new\";i:907;s:9:\"post_type\";s:10:\"attachment\";}i:917;a:3:{s:3:\"old\";i:917;s:3:\"new\";i:917;s:9:\"post_type\";s:10:\"attachment\";}i:918;a:3:{s:3:\"old\";i:918;s:3:\"new\";i:918;s:9:\"post_type\";s:10:\"attachment\";}i:919;a:3:{s:3:\"old\";i:919;s:3:\"new\";i:919;s:9:\"post_type\";s:10:\"attachment\";}i:920;a:3:{s:3:\"old\";i:920;s:3:\"new\";i:920;s:9:\"post_type\";s:10:\"attachment\";}i:317;a:3:{s:3:\"old\";i:317;s:3:\"new\";i:317;s:9:\"post_type\";s:10:\"attachment\";}i:363;a:3:{s:3:\"old\";i:363;s:3:\"new\";i:363;s:9:\"post_type\";s:10:\"attachment\";}i:393;a:3:{s:3:\"old\";i:393;s:3:\"new\";i:393;s:9:\"post_type\";s:10:\"attachment\";}i:396;a:3:{s:3:\"old\";i:396;s:3:\"new\";i:396;s:9:\"post_type\";s:10:\"attachment\";}i:398;a:3:{s:3:\"old\";i:398;s:3:\"new\";i:398;s:9:\"post_type\";s:10:\"attachment\";}i:400;a:3:{s:3:\"old\";i:400;s:3:\"new\";i:400;s:9:\"post_type\";s:10:\"attachment\";}i:405;a:3:{s:3:\"old\";i:405;s:3:\"new\";i:405;s:9:\"post_type\";s:10:\"attachment\";}i:419;a:3:{s:3:\"old\";i:419;s:3:\"new\";i:419;s:9:\"post_type\";s:10:\"attachment\";}i:424;a:3:{s:3:\"old\";i:424;s:3:\"new\";i:424;s:9:\"post_type\";s:10:\"attachment\";}i:451;a:3:{s:3:\"old\";i:451;s:3:\"new\";i:451;s:9:\"post_type\";s:10:\"attachment\";}i:372;a:3:{s:3:\"old\";i:372;s:3:\"new\";i:372;s:9:\"post_type\";s:10:\"attachment\";}i:375;a:3:{s:3:\"old\";i:375;s:3:\"new\";i:375;s:9:\"post_type\";s:10:\"attachment\";}i:433;a:3:{s:3:\"old\";i:433;s:3:\"new\";i:433;s:9:\"post_type\";s:10:\"attachment\";}i:487;a:3:{s:3:\"old\";i:487;s:3:\"new\";i:487;s:9:\"post_type\";s:10:\"attachment\";}i:279;a:3:{s:3:\"old\";i:279;s:3:\"new\";i:279;s:9:\"post_type\";s:10:\"attachment\";}i:354;a:3:{s:3:\"old\";i:354;s:3:\"new\";i:354;s:9:\"post_type\";s:10:\"attachment\";}i:369;a:3:{s:3:\"old\";i:369;s:3:\"new\";i:369;s:9:\"post_type\";s:10:\"attachment\";}i:427;a:3:{s:3:\"old\";i:427;s:3:\"new\";i:427;s:9:\"post_type\";s:10:\"attachment\";}i:485;a:3:{s:3:\"old\";i:485;s:3:\"new\";i:485;s:9:\"post_type\";s:10:\"attachment\";}i:264;a:3:{s:3:\"old\";i:264;s:3:\"new\";i:264;s:9:\"post_type\";s:10:\"attachment\";}i:309;a:3:{s:3:\"old\";i:309;s:3:\"new\";i:309;s:9:\"post_type\";s:10:\"attachment\";}i:342;a:3:{s:3:\"old\";i:342;s:3:\"new\";i:342;s:9:\"post_type\";s:10:\"attachment\";}i:351;a:3:{s:3:\"old\";i:351;s:3:\"new\";i:351;s:9:\"post_type\";s:10:\"attachment\";}i:439;a:3:{s:3:\"old\";i:439;s:3:\"new\";i:439;s:9:\"post_type\";s:10:\"attachment\";}i:482;a:3:{s:3:\"old\";i:482;s:3:\"new\";i:482;s:9:\"post_type\";s:10:\"attachment\";}i:516;a:3:{s:3:\"old\";i:516;s:3:\"new\";i:516;s:9:\"post_type\";s:10:\"attachment\";}i:301;a:3:{s:3:\"old\";i:301;s:3:\"new\";i:301;s:9:\"post_type\";s:10:\"attachment\";}i:303;a:3:{s:3:\"old\";i:303;s:3:\"new\";i:303;s:9:\"post_type\";s:10:\"attachment\";}i:525;a:3:{s:3:\"old\";i:525;s:3:\"new\";i:525;s:9:\"post_type\";s:10:\"attachment\";}i:493;a:3:{s:3:\"old\";i:493;s:3:\"new\";i:493;s:9:\"post_type\";s:10:\"attachment\";}i:33;a:3:{s:3:\"old\";i:33;s:3:\"new\";i:33;s:9:\"post_type\";s:10:\"attachment\";}i:35;a:3:{s:3:\"old\";i:35;s:3:\"new\";i:35;s:9:\"post_type\";s:10:\"attachment\";}i:38;a:3:{s:3:\"old\";i:38;s:3:\"new\";i:38;s:9:\"post_type\";s:10:\"attachment\";}i:40;a:3:{s:3:\"old\";i:40;s:3:\"new\";i:40;s:9:\"post_type\";s:10:\"attachment\";}i:43;a:3:{s:3:\"old\";i:43;s:3:\"new\";i:43;s:9:\"post_type\";s:10:\"attachment\";}i:45;a:3:{s:3:\"old\";i:45;s:3:\"new\";i:45;s:9:\"post_type\";s:10:\"attachment\";}i:48;a:3:{s:3:\"old\";i:48;s:3:\"new\";i:48;s:9:\"post_type\";s:10:\"attachment\";}i:50;a:3:{s:3:\"old\";i:50;s:3:\"new\";i:50;s:9:\"post_type\";s:10:\"attachment\";}i:110;a:3:{s:3:\"old\";i:110;s:3:\"new\";i:110;s:9:\"post_type\";s:10:\"attachment\";}i:120;a:3:{s:3:\"old\";i:120;s:3:\"new\";i:120;s:9:\"post_type\";s:10:\"attachment\";}i:121;a:3:{s:3:\"old\";i:121;s:3:\"new\";i:121;s:9:\"post_type\";s:10:\"attachment\";}i:124;a:3:{s:3:\"old\";i:124;s:3:\"new\";i:124;s:9:\"post_type\";s:10:\"attachment\";}i:125;a:3:{s:3:\"old\";i:125;s:3:\"new\";i:125;s:9:\"post_type\";s:10:\"attachment\";}i:126;a:3:{s:3:\"old\";i:126;s:3:\"new\";i:126;s:9:\"post_type\";s:10:\"attachment\";}i:128;a:3:{s:3:\"old\";i:128;s:3:\"new\";i:128;s:9:\"post_type\";s:10:\"attachment\";}i:129;a:3:{s:3:\"old\";i:129;s:3:\"new\";i:129;s:9:\"post_type\";s:10:\"attachment\";}i:130;a:3:{s:3:\"old\";i:130;s:3:\"new\";i:130;s:9:\"post_type\";s:10:\"attachment\";}i:131;a:3:{s:3:\"old\";i:131;s:3:\"new\";i:131;s:9:\"post_type\";s:10:\"attachment\";}i:135;a:3:{s:3:\"old\";i:135;s:3:\"new\";i:135;s:9:\"post_type\";s:10:\"attachment\";}i:65;a:3:{s:3:\"old\";i:65;s:3:\"new\";i:65;s:9:\"post_type\";s:10:\"attachment\";}i:72;a:3:{s:3:\"old\";i:72;s:3:\"new\";i:72;s:9:\"post_type\";s:10:\"attachment\";}i:136;a:3:{s:3:\"old\";i:136;s:3:\"new\";i:136;s:9:\"post_type\";s:10:\"attachment\";}i:139;a:3:{s:3:\"old\";i:139;s:3:\"new\";i:139;s:9:\"post_type\";s:10:\"attachment\";}i:140;a:3:{s:3:\"old\";i:140;s:3:\"new\";i:140;s:9:\"post_type\";s:10:\"attachment\";}i:141;a:3:{s:3:\"old\";i:141;s:3:\"new\";i:141;s:9:\"post_type\";s:10:\"attachment\";}i:142;a:3:{s:3:\"old\";i:142;s:3:\"new\";i:142;s:9:\"post_type\";s:10:\"attachment\";}i:143;a:3:{s:3:\"old\";i:143;s:3:\"new\";i:143;s:9:\"post_type\";s:10:\"attachment\";}i:144;a:3:{s:3:\"old\";i:144;s:3:\"new\";i:144;s:9:\"post_type\";s:10:\"attachment\";}i:145;a:3:{s:3:\"old\";i:145;s:3:\"new\";i:145;s:9:\"post_type\";s:10:\"attachment\";}i:146;a:3:{s:3:\"old\";i:146;s:3:\"new\";i:146;s:9:\"post_type\";s:10:\"attachment\";}i:147;a:3:{s:3:\"old\";i:147;s:3:\"new\";i:147;s:9:\"post_type\";s:10:\"attachment\";}i:148;a:3:{s:3:\"old\";i:148;s:3:\"new\";i:148;s:9:\"post_type\";s:10:\"attachment\";}i:979;a:3:{s:3:\"old\";i:979;s:3:\"new\";i:979;s:9:\"post_type\";s:10:\"attachment\";}i:993;a:3:{s:3:\"old\";i:993;s:3:\"new\";i:993;s:9:\"post_type\";s:10:\"attachment\";}i:994;a:3:{s:3:\"old\";i:994;s:3:\"new\";i:994;s:9:\"post_type\";s:10:\"attachment\";}i:1014;a:3:{s:3:\"old\";i:1014;s:3:\"new\";i:1014;s:9:\"post_type\";s:10:\"attachment\";}i:1016;a:3:{s:3:\"old\";i:1016;s:3:\"new\";i:1016;s:9:\"post_type\";s:10:\"attachment\";}i:1021;a:3:{s:3:\"old\";i:1021;s:3:\"new\";i:1044;s:9:\"post_type\";s:10:\"attachment\";}i:1217;a:3:{s:3:\"old\";i:1217;s:3:\"new\";i:1217;s:9:\"post_type\";s:10:\"attachment\";}i:1365;a:3:{s:3:\"old\";i:1365;s:3:\"new\";i:1365;s:9:\"post_type\";s:10:\"attachment\";}i:1412;a:3:{s:3:\"old\";i:1412;s:3:\"new\";i:1412;s:9:\"post_type\";s:10:\"attachment\";}i:1413;a:3:{s:3:\"old\";i:1413;s:3:\"new\";i:1413;s:9:\"post_type\";s:10:\"attachment\";}i:1414;a:3:{s:3:\"old\";i:1414;s:3:\"new\";i:1414;s:9:\"post_type\";s:10:\"attachment\";}i:1415;a:3:{s:3:\"old\";i:1415;s:3:\"new\";i:1415;s:9:\"post_type\";s:10:\"attachment\";}i:1416;a:3:{s:3:\"old\";i:1416;s:3:\"new\";i:1416;s:9:\"post_type\";s:10:\"attachment\";}i:102;a:3:{s:3:\"old\";i:102;s:3:\"new\";i:102;s:9:\"post_type\";s:10:\"attachment\";}i:852;a:3:{s:3:\"old\";i:852;s:3:\"new\";i:852;s:9:\"post_type\";s:10:\"attachment\";}i:853;a:3:{s:3:\"old\";i:853;s:3:\"new\";i:853;s:9:\"post_type\";s:10:\"attachment\";}i:854;a:3:{s:3:\"old\";i:854;s:3:\"new\";i:854;s:9:\"post_type\";s:10:\"attachment\";}i:865;a:3:{s:3:\"old\";i:865;s:3:\"new\";i:865;s:9:\"post_type\";s:10:\"attachment\";}i:866;a:3:{s:3:\"old\";i:866;s:3:\"new\";i:866;s:9:\"post_type\";s:10:\"attachment\";}i:867;a:3:{s:3:\"old\";i:867;s:3:\"new\";i:867;s:9:\"post_type\";s:10:\"attachment\";}i:868;a:3:{s:3:\"old\";i:868;s:3:\"new\";i:868;s:9:\"post_type\";s:10:\"attachment\";}i:978;a:3:{s:3:\"old\";i:978;s:3:\"new\";i:978;s:9:\"post_type\";s:10:\"attachment\";}i:991;a:3:{s:3:\"old\";i:991;s:3:\"new\";i:991;s:9:\"post_type\";s:10:\"attachment\";}i:1002;a:3:{s:3:\"old\";i:1002;s:3:\"new\";i:1002;s:9:\"post_type\";s:10:\"attachment\";}i:1008;a:3:{s:3:\"old\";i:1008;s:3:\"new\";i:1008;s:9:\"post_type\";s:10:\"attachment\";}i:769;a:3:{s:3:\"old\";i:769;s:3:\"new\";i:769;s:9:\"post_type\";s:10:\"attachment\";}i:779;a:3:{s:3:\"old\";i:779;s:3:\"new\";i:779;s:9:\"post_type\";s:10:\"attachment\";}i:780;a:3:{s:3:\"old\";i:780;s:3:\"new\";i:780;s:9:\"post_type\";s:10:\"attachment\";}i:781;a:3:{s:3:\"old\";i:781;s:3:\"new\";i:781;s:9:\"post_type\";s:10:\"attachment\";}i:782;a:3:{s:3:\"old\";i:782;s:3:\"new\";i:782;s:9:\"post_type\";s:10:\"attachment\";}i:851;a:3:{s:3:\"old\";i:851;s:3:\"new\";i:851;s:9:\"post_type\";s:10:\"attachment\";}}s:4:\"term\";a:7:{s:8:\"category\";a:6:{i:16;a:3:{s:3:\"new\";i:16;s:3:\"old\";i:1;s:4:\"type\";s:8:\"category\";}i:17;a:3:{s:3:\"new\";i:17;s:3:\"old\";i:74;s:4:\"type\";s:8:\"category\";}i:18;a:3:{s:3:\"new\";i:18;s:3:\"old\";i:75;s:4:\"type\";s:8:\"category\";}i:19;a:3:{s:3:\"new\";i:19;s:3:\"old\";i:76;s:4:\"type\";s:8:\"category\";}i:20;a:3:{s:3:\"new\";i:20;s:3:\"old\";i:78;s:4:\"type\";s:8:\"category\";}i:21;a:3:{s:3:\"new\";i:21;s:3:\"old\";i:79;s:4:\"type\";s:8:\"category\";}}s:11:\"product_cat\";a:11:{i:90;a:3:{s:3:\"new\";i:22;s:3:\"old\";i:90;s:4:\"type\";s:11:\"product_cat\";}i:91;a:3:{s:3:\"new\";i:23;s:3:\"old\";i:91;s:4:\"type\";s:11:\"product_cat\";}i:92;a:3:{s:3:\"new\";i:24;s:3:\"old\";i:92;s:4:\"type\";s:11:\"product_cat\";}i:93;a:3:{s:3:\"new\";i:25;s:3:\"old\";i:93;s:4:\"type\";s:11:\"product_cat\";}i:94;a:3:{s:3:\"new\";i:26;s:3:\"old\";i:94;s:4:\"type\";s:11:\"product_cat\";}i:89;a:3:{s:3:\"new\";i:28;s:3:\"old\";i:89;s:4:\"type\";s:11:\"product_cat\";}i:15;a:3:{s:3:\"new\";i:29;s:3:\"old\";i:15;s:4:\"type\";s:11:\"product_cat\";}i:17;a:3:{s:3:\"new\";i:30;s:3:\"old\";i:17;s:4:\"type\";s:11:\"product_cat\";}i:19;a:3:{s:3:\"new\";i:31;s:3:\"old\";i:19;s:4:\"type\";s:11:\"product_cat\";}i:22;a:3:{s:3:\"new\";i:32;s:3:\"old\";i:22;s:4:\"type\";s:11:\"product_cat\";}i:24;a:3:{s:3:\"new\";i:33;s:3:\"old\";i:24;s:4:\"type\";s:11:\"product_cat\";}}s:8:\"wp_theme\";a:1:{i:16;a:3:{s:3:\"new\";i:27;s:3:\"old\";i:16;s:4:\"type\";s:8:\"wp_theme\";}}s:8:\"pa_color\";a:13:{i:50;a:3:{s:3:\"new\";i:34;s:3:\"old\";i:50;s:4:\"type\";s:8:\"pa_color\";}i:51;a:3:{s:3:\"new\";i:35;s:3:\"old\";i:51;s:4:\"type\";s:8:\"pa_color\";}i:52;a:3:{s:3:\"new\";i:36;s:3:\"old\";i:52;s:4:\"type\";s:8:\"pa_color\";}i:53;a:3:{s:3:\"new\";i:37;s:3:\"old\";i:53;s:4:\"type\";s:8:\"pa_color\";}i:54;a:3:{s:3:\"new\";i:38;s:3:\"old\";i:54;s:4:\"type\";s:8:\"pa_color\";}i:55;a:3:{s:3:\"new\";i:39;s:3:\"old\";i:55;s:4:\"type\";s:8:\"pa_color\";}i:56;a:3:{s:3:\"new\";i:40;s:3:\"old\";i:56;s:4:\"type\";s:8:\"pa_color\";}i:57;a:3:{s:3:\"new\";i:41;s:3:\"old\";i:57;s:4:\"type\";s:8:\"pa_color\";}i:58;a:3:{s:3:\"new\";i:42;s:3:\"old\";i:58;s:4:\"type\";s:8:\"pa_color\";}i:59;a:3:{s:3:\"new\";i:43;s:3:\"old\";i:59;s:4:\"type\";s:8:\"pa_color\";}i:60;a:3:{s:3:\"new\";i:44;s:3:\"old\";i:60;s:4:\"type\";s:8:\"pa_color\";}i:61;a:3:{s:3:\"new\";i:45;s:3:\"old\";i:61;s:4:\"type\";s:8:\"pa_color\";}i:62;a:3:{s:3:\"new\";i:46;s:3:\"old\";i:62;s:4:\"type\";s:8:\"pa_color\";}}s:8:\"pa_brand\";a:10:{i:63;a:3:{s:3:\"new\";i:47;s:3:\"old\";i:63;s:4:\"type\";s:8:\"pa_brand\";}i:64;a:3:{s:3:\"new\";i:48;s:3:\"old\";i:64;s:4:\"type\";s:8:\"pa_brand\";}i:65;a:3:{s:3:\"new\";i:49;s:3:\"old\";i:65;s:4:\"type\";s:8:\"pa_brand\";}i:66;a:3:{s:3:\"new\";i:50;s:3:\"old\";i:66;s:4:\"type\";s:8:\"pa_brand\";}i:67;a:3:{s:3:\"new\";i:51;s:3:\"old\";i:67;s:4:\"type\";s:8:\"pa_brand\";}i:68;a:3:{s:3:\"new\";i:52;s:3:\"old\";i:68;s:4:\"type\";s:8:\"pa_brand\";}i:69;a:3:{s:3:\"new\";i:53;s:3:\"old\";i:69;s:4:\"type\";s:8:\"pa_brand\";}i:70;a:3:{s:3:\"new\";i:54;s:3:\"old\";i:70;s:4:\"type\";s:8:\"pa_brand\";}i:71;a:3:{s:3:\"new\";i:55;s:3:\"old\";i:71;s:4:\"type\";s:8:\"pa_brand\";}i:72;a:3:{s:3:\"new\";i:56;s:3:\"old\";i:72;s:4:\"type\";s:8:\"pa_brand\";}}s:8:\"post_tag\";a:9:{i:80;a:3:{s:3:\"new\";i:57;s:3:\"old\";i:80;s:4:\"type\";s:8:\"post_tag\";}i:81;a:3:{s:3:\"new\";i:58;s:3:\"old\";i:81;s:4:\"type\";s:8:\"post_tag\";}i:82;a:3:{s:3:\"new\";i:59;s:3:\"old\";i:82;s:4:\"type\";s:8:\"post_tag\";}i:83;a:3:{s:3:\"new\";i:60;s:3:\"old\";i:83;s:4:\"type\";s:8:\"post_tag\";}i:84;a:3:{s:3:\"new\";i:61;s:3:\"old\";i:84;s:4:\"type\";s:8:\"post_tag\";}i:85;a:3:{s:3:\"new\";i:62;s:3:\"old\";i:85;s:4:\"type\";s:8:\"post_tag\";}i:86;a:3:{s:3:\"new\";i:63;s:3:\"old\";i:86;s:4:\"type\";s:8:\"post_tag\";}i:87;a:3:{s:3:\"new\";i:64;s:3:\"old\";i:87;s:4:\"type\";s:8:\"post_tag\";}i:88;a:3:{s:3:\"new\";i:65;s:3:\"old\";i:88;s:4:\"type\";s:8:\"post_tag\";}}s:8:\"nav_menu\";a:3:{i:27;a:3:{s:3:\"new\";i:66;s:3:\"old\";i:27;s:4:\"type\";s:8:\"nav_menu\";}i:28;a:3:{s:3:\"new\";i:67;s:3:\"old\";i:28;s:4:\"type\";s:8:\"nav_menu\";}i:29;a:3:{s:3:\"new\";i:68;s:3:\"old\";i:29;s:4:\"type\";s:8:\"nav_menu\";}}}s:4:\"page\";a:9:{i:21;a:4:{s:3:\"old\";i:21;s:3:\"new\";i:21;s:9:\"post_type\";s:4:\"page\";s:4:\"type\";s:9:\"elementor\";}i:23;a:4:{s:3:\"old\";i:23;s:3:\"new\";i:23;s:9:\"post_type\";s:4:\"page\";s:4:\"type\";s:9:\"elementor\";}i:10;a:3:{s:3:\"old\";i:10;s:3:\"new\";i:1022;s:9:\"post_type\";s:4:\"page\";}i:15;a:4:{s:3:\"old\";i:15;s:3:\"new\";i:15;s:9:\"post_type\";s:4:\"page\";s:4:\"type\";s:9:\"elementor\";}i:18;a:3:{s:3:\"old\";i:18;s:3:\"new\";i:18;s:9:\"post_type\";s:4:\"page\";}i:25;a:4:{s:3:\"old\";i:25;s:3:\"new\";i:25;s:9:\"post_type\";s:4:\"page\";s:4:\"type\";s:9:\"elementor\";}i:27;a:4:{s:3:\"old\";i:27;s:3:\"new\";i:27;s:9:\"post_type\";s:4:\"page\";s:4:\"type\";s:9:\"elementor\";}i:29;a:4:{s:3:\"old\";i:29;s:3:\"new\";i:29;s:9:\"post_type\";s:4:\"page\";s:4:\"type\";s:9:\"elementor\";}i:31;a:4:{s:3:\"old\";i:31;s:3:\"new\";i:31;s:9:\"post_type\";s:4:\"page\";s:4:\"type\";s:9:\"elementor\";}}s:7:\"product\";a:42:{i:498;a:4:{s:3:\"old\";i:498;s:3:\"new\";i:498;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:512;a:4:{s:3:\"old\";i:512;s:3:\"new\";i:512;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:515;a:4:{s:3:\"old\";i:515;s:3:\"new\";i:515;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:521;a:4:{s:3:\"old\";i:521;s:3:\"new\";i:521;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:524;a:4:{s:3:\"old\";i:524;s:3:\"new\";i:524;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:530;a:4:{s:3:\"old\";i:530;s:3:\"new\";i:530;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:533;a:4:{s:3:\"old\";i:533;s:3:\"new\";i:533;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:849;a:4:{s:3:\"old\";i:849;s:3:\"new\";i:849;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:864;a:4:{s:3:\"old\";i:864;s:3:\"new\";i:864;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:395;a:4:{s:3:\"old\";i:395;s:3:\"new\";i:395;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:421;a:4:{s:3:\"old\";i:421;s:3:\"new\";i:421;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:426;a:4:{s:3:\"old\";i:426;s:3:\"new\";i:426;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:429;a:4:{s:3:\"old\";i:429;s:3:\"new\";i:429;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:432;a:4:{s:3:\"old\";i:432;s:3:\"new\";i:432;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:438;a:4:{s:3:\"old\";i:438;s:3:\"new\";i:438;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:444;a:4:{s:3:\"old\";i:444;s:3:\"new\";i:444;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:447;a:4:{s:3:\"old\";i:447;s:3:\"new\";i:447;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:450;a:4:{s:3:\"old\";i:450;s:3:\"new\";i:450;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:478;a:4:{s:3:\"old\";i:478;s:3:\"new\";i:478;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:481;a:4:{s:3:\"old\";i:481;s:3:\"new\";i:481;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:489;a:4:{s:3:\"old\";i:489;s:3:\"new\";i:489;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:285;a:4:{s:3:\"old\";i:285;s:3:\"new\";i:285;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:288;a:4:{s:3:\"old\";i:288;s:3:\"new\";i:288;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:291;a:4:{s:3:\"old\";i:291;s:3:\"new\";i:291;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:297;a:4:{s:3:\"old\";i:297;s:3:\"new\";i:297;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:305;a:4:{s:3:\"old\";i:305;s:3:\"new\";i:305;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:308;a:4:{s:3:\"old\";i:308;s:3:\"new\";i:308;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:341;a:4:{s:3:\"old\";i:341;s:3:\"new\";i:341;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:344;a:4:{s:3:\"old\";i:344;s:3:\"new\";i:344;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:350;a:4:{s:3:\"old\";i:350;s:3:\"new\";i:350;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:353;a:4:{s:3:\"old\";i:353;s:3:\"new\";i:353;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:362;a:4:{s:3:\"old\";i:362;s:3:\"new\";i:362;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:368;a:4:{s:3:\"old\";i:368;s:3:\"new\";i:368;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:371;a:4:{s:3:\"old\";i:371;s:3:\"new\";i:371;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:374;a:4:{s:3:\"old\";i:374;s:3:\"new\";i:374;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:377;a:4:{s:3:\"old\";i:377;s:3:\"new\";i:377;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:380;a:4:{s:3:\"old\";i:380;s:3:\"new\";i:380;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:392;a:4:{s:3:\"old\";i:392;s:3:\"new\";i:392;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:250;a:4:{s:3:\"old\";i:250;s:3:\"new\";i:250;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:266;a:4:{s:3:\"old\";i:266;s:3:\"new\";i:266;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:272;a:4:{s:3:\"old\";i:272;s:3:\"new\";i:272;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}i:275;a:4:{s:3:\"old\";i:275;s:3:\"new\";i:275;s:9:\"post_type\";s:7:\"product\";s:4:\"type\";s:9:\"elementor\";}}s:17:\"product_variation\";a:13:{i:500;a:3:{s:3:\"old\";i:500;s:3:\"new\";i:500;s:9:\"post_type\";s:17:\"product_variation\";}i:501;a:3:{s:3:\"old\";i:501;s:3:\"new\";i:501;s:9:\"post_type\";s:17:\"product_variation\";}i:397;a:3:{s:3:\"old\";i:397;s:3:\"new\";i:397;s:9:\"post_type\";s:17:\"product_variation\";}i:399;a:3:{s:3:\"old\";i:399;s:3:\"new\";i:399;s:9:\"post_type\";s:17:\"product_variation\";}i:401;a:3:{s:3:\"old\";i:401;s:3:\"new\";i:401;s:9:\"post_type\";s:17:\"product_variation\";}i:403;a:3:{s:3:\"old\";i:403;s:3:\"new\";i:403;s:9:\"post_type\";s:17:\"product_variation\";}i:404;a:3:{s:3:\"old\";i:404;s:3:\"new\";i:404;s:9:\"post_type\";s:17:\"product_variation\";}i:483;a:3:{s:3:\"old\";i:483;s:3:\"new\";i:483;s:9:\"post_type\";s:17:\"product_variation\";}i:484;a:3:{s:3:\"old\";i:484;s:3:\"new\";i:484;s:9:\"post_type\";s:17:\"product_variation\";}i:486;a:3:{s:3:\"old\";i:486;s:3:\"new\";i:486;s:9:\"post_type\";s:17:\"product_variation\";}i:299;a:3:{s:3:\"old\";i:299;s:3:\"new\";i:299;s:9:\"post_type\";s:17:\"product_variation\";}i:300;a:3:{s:3:\"old\";i:300;s:3:\"new\";i:300;s:9:\"post_type\";s:17:\"product_variation\";}i:302;a:3:{s:3:\"old\";i:302;s:3:\"new\";i:302;s:9:\"post_type\";s:17:\"product_variation\";}}s:9:\"cms_block\";a:2:{i:766;a:4:{s:3:\"old\";i:766;s:3:\"new\";i:766;s:9:\"post_type\";s:9:\"cms_block\";s:4:\"type\";s:9:\"elementor\";}i:688;a:4:{s:3:\"old\";i:688;s:3:\"new\";i:688;s:9:\"post_type\";s:9:\"cms_block\";s:4:\"type\";s:9:\"elementor\";}}s:4:\"post\";a:6:{i:976;a:4:{s:3:\"old\";i:976;s:3:\"new\";i:976;s:9:\"post_type\";s:4:\"post\";s:4:\"type\";s:9:\"elementor\";}i:990;a:4:{s:3:\"old\";i:990;s:3:\"new\";i:990;s:9:\"post_type\";s:4:\"post\";s:4:\"type\";s:9:\"elementor\";}i:1001;a:4:{s:3:\"old\";i:1001;s:3:\"new\";i:1001;s:9:\"post_type\";s:4:\"post\";s:4:\"type\";s:9:\"elementor\";}i:1007;a:4:{s:3:\"old\";i:1007;s:3:\"new\";i:1007;s:9:\"post_type\";s:4:\"post\";s:4:\"type\";s:9:\"elementor\";}i:1013;a:4:{s:3:\"old\";i:1013;s:3:\"new\";i:1013;s:9:\"post_type\";s:4:\"post\";s:4:\"type\";s:9:\"elementor\";}i:1020;a:4:{s:3:\"old\";i:1020;s:3:\"new\";i:1020;s:9:\"post_type\";s:4:\"post\";s:4:\"type\";s:9:\"elementor\";}}s:18:\"wpcf7_contact_form\";a:1:{i:6;a:3:{s:3:\"old\";i:6;s:3:\"new\";i:1021;s:9:\"post_type\";s:18:\"wpcf7_contact_form\";}}s:13:\"nav_menu_item\";a:19:{i:54;a:3:{s:3:\"old\";i:54;s:3:\"new\";i:1023;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:56;a:3:{s:3:\"old\";i:56;s:3:\"new\";i:1024;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:59;a:3:{s:3:\"old\";i:59;s:3:\"new\";i:1025;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:61;a:3:{s:3:\"old\";i:61;s:3:\"new\";i:1026;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:1206;a:3:{s:3:\"old\";i:1206;s:3:\"new\";i:1027;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:1207;a:3:{s:3:\"old\";i:1207;s:3:\"new\";i:1028;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:1208;a:3:{s:3:\"old\";i:1208;s:3:\"new\";i:1029;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:77;a:3:{s:3:\"old\";i:77;s:3:\"new\";i:1030;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:78;a:3:{s:3:\"old\";i:78;s:3:\"new\";i:1031;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:79;a:3:{s:3:\"old\";i:79;s:3:\"new\";i:1032;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:80;a:3:{s:3:\"old\";i:80;s:3:\"new\";i:1033;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:81;a:3:{s:3:\"old\";i:81;s:3:\"new\";i:1034;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:82;a:3:{s:3:\"old\";i:82;s:3:\"new\";i:1035;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:83;a:3:{s:3:\"old\";i:83;s:3:\"new\";i:1036;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:84;a:3:{s:3:\"old\";i:84;s:3:\"new\";i:1037;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:85;a:3:{s:3:\"old\";i:85;s:3:\"new\";i:1038;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:1205;a:3:{s:3:\"old\";i:1205;s:3:\"new\";i:1039;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:1209;a:3:{s:3:\"old\";i:1209;s:3:\"new\";i:1040;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:1210;a:3:{s:3:\"old\";i:1210;s:3:\"new\";i:1041;s:9:\"post_type\";s:13:\"nav_menu_item\";}}s:7:\"headers\";a:1:{s:13:\"header_937146\";s:13:\"header_937146\";}}", "yes");
INSERT INTO `wp_options` VALUES("512", "wd_import_replaced_items", "a:111:{i:21;a:1:{s:12:\"post_content\";s:12:\"post_content\";}i:23;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"term_meta\";s:9:\"term_meta\";}i:498;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:512;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:515;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:521;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:524;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:530;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:533;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:766;a:1:{s:12:\"post_content\";s:12:\"post_content\";}i:976;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:990;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:1001;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:1007;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:1013;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:1020;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:395;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:421;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:426;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:429;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:432;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:438;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:444;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:447;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:450;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:478;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:481;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:489;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:285;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:288;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:291;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:297;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:305;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:308;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:341;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:344;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:350;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:353;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:362;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:368;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:371;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:374;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:377;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:380;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:392;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:15;a:1:{s:12:\"post_content\";s:12:\"post_content\";}i:25;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"term_meta\";s:9:\"term_meta\";}i:27;a:1:{s:12:\"post_content\";s:12:\"post_content\";}i:29;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"term_meta\";s:9:\"term_meta\";}i:31;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"term_meta\";s:9:\"term_meta\";}i:250;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:266;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:272;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:275;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:9:\"post_meta\";s:9:\"post_meta\";}i:688;a:1:{s:12:\"post_content\";s:12:\"post_content\";}i:22;a:1:{s:9:\"term_meta\";s:9:\"term_meta\";}i:24;a:1:{s:9:\"term_meta\";s:9:\"term_meta\";}i:26;a:1:{s:9:\"term_meta\";s:9:\"term_meta\";}i:30;a:1:{s:9:\"term_meta\";s:9:\"term_meta\";}i:32;a:1:{s:9:\"term_meta\";s:9:\"term_meta\";}i:33;a:1:{s:9:\"term_meta\";s:9:\"term_meta\";}i:47;a:1:{s:9:\"term_meta\";s:9:\"term_meta\";}i:48;a:1:{s:9:\"term_meta\";s:9:\"term_meta\";}i:49;a:1:{s:9:\"term_meta\";s:9:\"term_meta\";}i:50;a:1:{s:9:\"term_meta\";s:9:\"term_meta\";}i:51;a:1:{s:9:\"term_meta\";s:9:\"term_meta\";}i:52;a:1:{s:9:\"term_meta\";s:9:\"term_meta\";}i:53;a:1:{s:9:\"term_meta\";s:9:\"term_meta\";}i:54;a:1:{s:9:\"term_meta\";s:9:\"term_meta\";}i:55;a:1:{s:9:\"term_meta\";s:9:\"term_meta\";}i:56;a:1:{s:9:\"term_meta\";s:9:\"term_meta\";}i:849;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:864;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:1023;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:1024;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:1025;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:1026;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:1027;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:1028;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:1029;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:1039;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:1040;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:1041;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:500;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:397;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:399;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:403;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:404;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:483;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:484;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:302;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:501;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:486;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:299;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:300;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:1420;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:1421;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:1422;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:151;a:2:{s:9:\"post_meta\";s:9:\"post_meta\";s:12:\"post_content\";s:12:\"post_content\";}i:217;a:2:{s:9:\"post_meta\";s:9:\"post_meta\";s:12:\"post_content\";s:12:\"post_content\";}i:226;a:2:{s:9:\"post_meta\";s:9:\"post_meta\";s:12:\"post_content\";s:12:\"post_content\";}i:1423;a:1:{s:9:\"post_meta\";s:9:\"post_meta\";}i:758;a:2:{s:12:\"post_content\";s:12:\"post_content\";s:4:\"diff\";a:1:{i:0;a:1:{i:760;i:760;}}}i:711;a:1:{s:12:\"post_content\";s:12:\"post_content\";}i:760;a:1:{s:12:\"post_content\";s:12:\"post_content\";}i:788;a:1:{s:12:\"post_content\";s:12:\"post_content\";}i:1419;a:1:{s:12:\"post_content\";s:12:\"post_content\";}i:1066;a:1:{s:12:\"post_content\";s:12:\"post_content\";}i:1079;a:1:{s:12:\"post_content\";s:12:\"post_content\";}i:1084;a:1:{s:12:\"post_content\";s:12:\"post_content\";}i:1388;a:1:{s:12:\"post_content\";s:12:\"post_content\";}}", "yes");
INSERT INTO `wp_options` VALUES("520", "xts-default_header-css-data", ":root{\n	--wd-top-bar-h: 42px;\n	--wd-top-bar-sm-h: 40px;\n	--wd-top-bar-sticky-h: 0.001px;\n\n	--wd-header-general-h: 104px;\n	--wd-header-general-sm-h: 60px;\n	--wd-header-general-sticky-h: 0.001px;\n\n	--wd-header-bottom-h: 50px;\n	--wd-header-bottom-sm-h: 0.001px;\n	--wd-header-bottom-sticky-h: 0.001px;\n\n	--wd-header-clone-h: 0.001px;\n}\n\n.whb-top-bar .wd-dropdown {\n	margin-top: 1px;\n}\n\n.whb-top-bar .wd-dropdown:after {\n	height: 11px;\n}\n\n\n.whb-header-bottom .wd-dropdown {\n	margin-top: 5px;\n}\n\n.whb-header-bottom .wd-dropdown:after {\n	height: 15px;\n}\n\n\n.whb-header .whb-header-bottom .wd-header-cats {\n	margin-top: -1px;\n	margin-bottom: -0px;\n	height: calc(100% + 1px);\n}\n\n\n@media (min-width: 1025px) {\n		.whb-top-bar-inner {\n		height: 42px;\n		max-height: 42px;\n	}\n\n		.whb-sticked .whb-top-bar-inner {\n		height: 40px;\n		max-height: 40px;\n	}\n		\n		.whb-general-header-inner {\n		height: 104px;\n		max-height: 104px;\n	}\n\n		.whb-sticked .whb-general-header-inner {\n		height: 60px;\n		max-height: 60px;\n	}\n		\n		.whb-header-bottom-inner {\n		height: 50px;\n		max-height: 50px;\n	}\n\n		.whb-sticked .whb-header-bottom-inner {\n		height: 50px;\n		max-height: 50px;\n	}\n		\n	\n	}\n\n@media (max-width: 1024px) {\n		.whb-top-bar-inner {\n		height: 40px;\n		max-height: 40px;\n	}\n	\n		.whb-general-header-inner {\n		height: 60px;\n		max-height: 60px;\n	}\n	\n	\n	\n	}\n		\n.whb-top-bar {\n	background-color: rgba(130, 183, 53, 1);\n}\n\n.whb-general-header {\n	border-color: rgba(129, 129, 129, 0.2);border-bottom-width: 1px;border-bottom-style: solid;\n}\n", "yes");
INSERT INTO `wp_options` VALUES("521", "xts-default_header-status", "valid", "yes");
INSERT INTO `wp_options` VALUES("522", "xts-default_header-version", "7.3.0", "yes");
INSERT INTO `wp_options` VALUES("523", "xts-default_header-site-url", "df3453a0a212ae6729733a32d3776515", "yes");
INSERT INTO `wp_options` VALUES("542", "whb_saved_headers", "a:3:{s:14:\"default_header\";a:2:{s:2:\"id\";s:14:\"default_header\";s:4:\"name\";s:21:\"Default header layout\";}s:13:\"header_937146\";a:2:{s:2:\"id\";s:13:\"header_937146\";s:4:\"name\";s:18:\"Header Furniture 2\";}s:13:\"header_183299\";a:2:{s:2:\"id\";s:13:\"header_183299\";s:4:\"name\";s:27:\"Header Furniture 2 checkout\";}}", "yes");
INSERT INTO `wp_options` VALUES("544", "xts-header_937146-css-data", ":root{\n	--wd-top-bar-h: 40px;\n	--wd-top-bar-sm-h: .00001px;\n	--wd-top-bar-sticky-h: .00001px;\n	--wd-top-bar-brd-w: .00001px;\n\n	--wd-header-general-h: 64px;\n	--wd-header-general-sm-h: 50px;\n	--wd-header-general-sticky-h: 60px;\n	--wd-header-general-brd-w: .00001px;\n\n	--wd-header-bottom-h: 45px;\n	--wd-header-bottom-sm-h: .00001px;\n	--wd-header-bottom-sticky-h: 45px;\n	--wd-header-bottom-brd-w: .00001px;\n\n	--wd-header-clone-h: .00001px;\n\n	--wd-header-brd-w: calc(var(--wd-top-bar-brd-w) + var(--wd-header-general-brd-w) + var(--wd-header-bottom-brd-w));\n	--wd-header-h: calc(var(--wd-top-bar-h) + var(--wd-header-general-h) + var(--wd-header-bottom-h) + var(--wd-header-brd-w));\n	--wd-header-sticky-h: calc(var(--wd-top-bar-sticky-h) + var(--wd-header-general-sticky-h) + var(--wd-header-bottom-sticky-h) + var(--wd-header-clone-h) + var(--wd-header-brd-w));\n	--wd-header-sm-h: calc(var(--wd-top-bar-sm-h) + var(--wd-header-general-sm-h) + var(--wd-header-bottom-sm-h) + var(--wd-header-brd-w));\n}\n\n.whb-top-bar .wd-dropdown {\n	margin-top: 0px;\n}\n\n.whb-top-bar .wd-dropdown:after {\n	height: 10px;\n}\n\n\n.whb-sticked .whb-general-header .wd-dropdown:not(.sub-sub-menu) {\n	margin-top: 10px;\n}\n\n.whb-sticked .whb-general-header .wd-dropdown:not(.sub-sub-menu):after {\n	height: 20px;\n}\n\n\n\n\n.whb-header-bottom .wd-dropdown {\n	margin-top: 2.5px;\n}\n\n.whb-header-bottom .wd-dropdown:after {\n	height: 12.5px;\n}\n\n.whb-sticked .whb-header-bottom .wd-dropdown:not(.sub-sub-menu) {\n	margin-top: 2.5px;\n}\n\n.whb-sticked .whb-header-bottom .wd-dropdown:not(.sub-sub-menu):after {\n	height: 12.5px;\n}\n\n\n		\n.whb-30fubq3nvq576dnig92g.info-box-wrapper div.wd-info-box {\n	--ib-icon-sp: 10px;\n}\n.whb-30fubq3nvq576dnig92g .info-box-title {\n	color: rgba(36, 36, 36, 1);\n	font-weight: 400;\n}\n.whb-30fubq3nvq576dnig92g .wd-info-box .info-box-title {\n	font-size: 13px;\n}\n.whb-cnp9n8j9vd9piydx94j5.info-box-wrapper div.wd-info-box {\n	--ib-icon-sp: 10px;\n}\n.whb-cnp9n8j9vd9piydx94j5 .info-box-title {\n	color: rgba(36, 36, 36, 1);\n	font-weight: 400;\n}\n.whb-cnp9n8j9vd9piydx94j5 .wd-info-box .info-box-title {\n	font-size: 13px;\n}\n.whb-top-bar {\n	background-color: rgba(16, 16, 16, 0.05);\n}\n\n.whb-3dr2urezpqgndfjlfa22 form.searchform {\n	--wd-form-height: 42px;\n}\n.whb-row .whb-tu39rl1tsd8wpcxl7lnl.wd-tools-element .wd-tools-inner, .whb-row .whb-tu39rl1tsd8wpcxl7lnl.wd-tools-element > a > .wd-tools-icon {\n	color: rgba(16, 16, 16, 0.7);\n	background-color: rgba(16, 16, 16, 0.05);\n}\n.whb-row .whb-tu39rl1tsd8wpcxl7lnl.wd-tools-element:hover .wd-tools-inner, .whb-row .whb-tu39rl1tsd8wpcxl7lnl.wd-tools-element:hover > a > .wd-tools-icon {\n	color: rgba(16, 16, 16, 0.5);\n}\n.whb-row .whb-itc82qyu9f3s0tscappq.wd-tools-element .wd-tools-inner, .whb-row .whb-itc82qyu9f3s0tscappq.wd-tools-element > a > .wd-tools-icon {\n	color: rgba(16, 16, 16, 0.7);\n	background-color: rgba(16, 16, 16, 0.05);\n}\n.whb-row .whb-itc82qyu9f3s0tscappq.wd-tools-element:hover .wd-tools-inner, .whb-row .whb-itc82qyu9f3s0tscappq.wd-tools-element:hover > a > .wd-tools-icon {\n	color: rgba(16, 16, 16, 0.5);\n}\n.whb-row .whb-d3rr7l2o7d965a6qvawk.wd-tools-element .wd-tools-inner, .whb-row .whb-d3rr7l2o7d965a6qvawk.wd-tools-element > a > .wd-tools-icon {\n	color: rgba(16, 16, 16, 0.7);\n	background-color: rgba(16, 16, 16, 0.05);\n}\n.whb-row .whb-d3rr7l2o7d965a6qvawk.wd-tools-element:hover .wd-tools-inner, .whb-row .whb-d3rr7l2o7d965a6qvawk.wd-tools-element:hover > a > .wd-tools-icon {\n	color: rgba(16, 16, 16, 0.5);\n}\n.whb-general-header {\n	background-color: rgba(251, 250, 247, 1);\n}\n\n.whb-v3xalsxx5qj6k8pocye1 a:is(.btn-style-default, .btn-style-3d) {\n	background-color: rgba(224, 234, 240, 1);\n}\n.whb-v3xalsxx5qj6k8pocye1 a:is(.btn-style-bordered, .btn-style-link) {\n	border-color: rgba(224, 234, 240, 1);\n}\n.whb-v3xalsxx5qj6k8pocye1 a:is(.btn-style-bordered, .btn-style-default, .btn-style-3d):hover {\n	background-color: rgba(215, 229, 237, 1);\n}\n.whb-v3xalsxx5qj6k8pocye1 a:is(.btn-style-bordered, .btn-style-link):hover {\n	border-color: rgba(215, 229, 237, 1);\n}\n.whb-header-bottom {\n	background-color: rgba(251, 250, 247, 1);\n}\n", "on");
INSERT INTO `wp_options` VALUES("545", "xts-header_937146-status", "valid", "yes");
INSERT INTO `wp_options` VALUES("546", "xts-header_937146-version", "8.2.6", "on");
INSERT INTO `wp_options` VALUES("547", "xts-header_937146-site-url", "b8614d529e5b9d272cc48bd2fca884b4", "on");
INSERT INTO `wp_options` VALUES("548", "whb_header_937146", "a:4:{s:4:\"name\";s:18:\"Header Furniture 2\";s:2:\"id\";s:13:\"header_937146\";s:9:\"structure\";a:3:{s:2:\"id\";s:4:\"root\";s:4:\"type\";s:4:\"root\";s:7:\"content\";a:3:{i:0;a:4:{s:2:\"id\";s:7:\"top-bar\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:4:{i:0;a:3:{s:2:\"id\";s:7:\"column5\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:5:{i:0;a:3:{s:2:\"id\";s:20:\"cit1ncx70jbyuir95dfx\";s:4:\"type\";s:4:\"menu\";s:6:\"params\";a:6:{s:7:\"menu_id\";a:3:{s:2:\"id\";s:7:\"menu_id\";s:5:\"value\";s:20:\"currency-furniture-2\";s:4:\"type\";s:7:\"options\";}s:10:\"menu_style\";a:3:{s:2:\"id\";s:10:\"menu_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:10:\"menu_align\";a:3:{s:2:\"id\";s:10:\"menu_align\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:9:\"items_gap\";a:3:{s:2:\"id\";s:9:\"items_gap\";s:5:\"value\";s:1:\"s\";s:4:\"type\";s:8:\"selector\";}s:10:\"bg_overlay\";a:3:{s:2:\"id\";s:10:\"bg_overlay\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"inline\";a:3:{s:2:\"id\";s:6:\"inline\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}i:1;a:3:{s:2:\"id\";s:20:\"xvhltxkd1p6bq8g63r7w\";s:4:\"type\";s:5:\"space\";s:6:\"params\";a:2:{s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:5;s:4:\"type\";s:6:\"slider\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:2;a:3:{s:2:\"id\";s:20:\"0v44p71f3kcw817dtc83\";s:4:\"type\";s:7:\"divider\";s:6:\"params\";a:2:{s:11:\"full_height\";a:3:{s:2:\"id\";s:11:\"full_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:3;a:3:{s:2:\"id\";s:20:\"l6bd30tnw3gno0xruc2i\";s:4:\"type\";s:5:\"space\";s:6:\"params\";a:2:{s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:10;s:4:\"type\";s:6:\"slider\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:4;a:3:{s:2:\"id\";s:20:\"qzf4x22dwh663n6f0ebd\";s:4:\"type\";s:4:\"menu\";s:6:\"params\";a:6:{s:7:\"menu_id\";a:3:{s:2:\"id\";s:7:\"menu_id\";s:5:\"value\";s:24:\"top-bar-menu-furniture-2\";s:4:\"type\";s:7:\"options\";}s:10:\"menu_style\";a:3:{s:2:\"id\";s:10:\"menu_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:10:\"menu_align\";a:3:{s:2:\"id\";s:10:\"menu_align\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:9:\"items_gap\";a:3:{s:2:\"id\";s:9:\"items_gap\";s:5:\"value\";s:1:\"s\";s:4:\"type\";s:8:\"selector\";}s:10:\"bg_overlay\";a:3:{s:2:\"id\";s:10:\"bg_overlay\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"inline\";a:3:{s:2:\"id\";s:6:\"inline\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}i:1;a:3:{s:2:\"id\";s:7:\"column6\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:2;a:3:{s:2:\"id\";s:7:\"column7\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:5:{i:0;a:3:{s:2:\"id\";s:20:\"30fubq3nvq576dnig92g\";s:4:\"type\";s:7:\"infobox\";s:6:\"params\";a:61:{s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_text\";a:3:{s:2:\"id\";s:9:\"icon_text\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";a:4:{s:2:\"id\";i:72;s:3:\"url\";s:90:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-phone.svg\";s:5:\"width\";i:24;s:6:\"height\";i:24;}s:4:\"type\";s:5:\"image\";}s:8:\"img_size\";a:3:{s:2:\"id\";s:8:\"img_size\";s:5:\"value\";s:5:\"16x16\";s:4:\"type\";s:4:\"text\";}s:8:\"subtitle\";a:3:{s:2:\"id\";s:8:\"subtitle\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"textarea\";}s:5:\"title\";a:3:{s:2:\"id\";s:5:\"title\";s:5:\"value\";s:10:\"0912345678\";s:4:\"type\";s:8:\"textarea\";}s:7:\"content\";a:3:{s:2:\"id\";s:7:\"content\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"editor\";}s:8:\"btn_text\";a:3:{s:2:\"id\";s:8:\"btn_text\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:4:\"link\";a:3:{s:2:\"id\";s:4:\"link\";s:5:\"value\";a:1:{s:3:\"url\";s:18:\"tel:(686) 492-1044\";}s:4:\"type\";s:4:\"link\";}s:8:\"el_class\";a:3:{s:2:\"id\";s:8:\"el_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:4:\"base\";s:4:\"type\";s:7:\"options\";}s:21:\"woodmart_color_scheme\";a:3:{s:2:\"id\";s:21:\"woodmart_color_scheme\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"selector\";}s:27:\"woodmart_hover_color_scheme\";a:3:{s:2:\"id\";s:27:\"woodmart_hover_color_scheme\";s:5:\"value\";s:5:\"light\";s:4:\"type\";s:8:\"selector\";}s:9:\"alignment\";a:3:{s:2:\"id\";s:9:\"alignment\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:12:\"bg_image_box\";a:3:{s:2:\"id\";s:12:\"bg_image_box\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:17:\"bg_image_box_size\";a:3:{s:2:\"id\";s:17:\"bg_image_box_size\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:21:\"bg_image_box_position\";a:3:{s:2:\"id\";s:21:\"bg_image_box_position\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:19:\"bg_image_box_repeat\";a:3:{s:2:\"id\";s:19:\"bg_image_box_repeat\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:18:\"bg_image_box_sizes\";a:3:{s:2:\"id\";s:18:\"bg_image_box_sizes\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_image\";a:3:{s:2:\"id\";s:14:\"bg_hover_image\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:19:\"bg_hover_image_size\";a:3:{s:2:\"id\";s:19:\"bg_hover_image_size\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:23:\"bg_hover_image_position\";a:3:{s:2:\"id\";s:23:\"bg_hover_image_position\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:21:\"bg_hover_image_repeat\";a:3:{s:2:\"id\";s:21:\"bg_hover_image_repeat\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:20:\"bg_hover_image_sizes\";a:3:{s:2:\"id\";s:20:\"bg_hover_image_sizes\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:15:\"image_alignment\";a:3:{s:2:\"id\";s:15:\"image_alignment\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:24:\"image_vertical_alignment\";a:3:{s:2:\"id\";s:24:\"image_vertical_alignment\";s:5:\"value\";s:6:\"middle\";s:4:\"type\";s:8:\"selector\";}s:10:\"icon_style\";a:3:{s:2:\"id\";s:10:\"icon_style\";s:5:\"value\";s:6:\"simple\";s:4:\"type\";s:8:\"selector\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:17:\"icon_border_color\";a:3:{s:2:\"id\";s:17:\"icon_border_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:23:\"icon_border_hover_color\";a:3:{s:2:\"id\";s:23:\"icon_border_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"icon_text_size\";a:3:{s:2:\"id\";s:14:\"icon_text_size\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:7:\"options\";}s:15:\"icon_text_color\";a:3:{s:2:\"id\";s:15:\"icon_text_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:12:\"icon_spacing\";a:3:{s:2:\"id\";s:12:\"icon_spacing\";s:5:\"value\";i:10;s:4:\"type\";s:6:\"slider\";}s:14:\"subtitle_style\";a:3:{s:2:\"id\";s:14:\"subtitle_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:24:\"subtitle_custom_bg_color\";a:3:{s:2:\"id\";s:24:\"subtitle_custom_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:22:\"subtitle_style_divider\";a:3:{s:2:\"id\";s:22:\"subtitle_style_divider\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"divider\";}s:14:\"subtitle_color\";a:3:{s:2:\"id\";s:14:\"subtitle_color\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:7:\"options\";}s:21:\"subtitle_custom_color\";a:3:{s:2:\"id\";s:21:\"subtitle_custom_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"subtitle_font\";a:3:{s:2:\"id\";s:13:\"subtitle_font\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:20:\"subtitle_font_weight\";a:3:{s:2:\"id\";s:20:\"subtitle_font_weight\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:18:\"subtitle_font_size\";a:3:{s:2:\"id\";s:18:\"subtitle_font_size\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:20:\"subtitle_line_height\";a:3:{s:2:\"id\";s:20:\"subtitle_line_height\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:11:\"title_style\";a:3:{s:2:\"id\";s:11:\"title_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"title_color\";a:3:{s:2:\"id\";s:11:\"title_color\";s:5:\"value\";a:4:{s:1:\"r\";i:36;s:1:\"g\";i:36;s:1:\"b\";i:36;s:1:\"a\";i:1;}s:4:\"type\";s:5:\"color\";}s:10:\"title_font\";a:3:{s:2:\"id\";s:10:\"title_font\";s:5:\"value\";s:4:\"text\";s:4:\"type\";s:7:\"options\";}s:17:\"title_font_weight\";a:3:{s:2:\"id\";s:17:\"title_font_weight\";s:5:\"value\";s:3:\"400\";s:4:\"type\";s:7:\"options\";}s:10:\"title_size\";a:3:{s:2:\"id\";s:10:\"title_size\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:7:\"options\";}s:15:\"title_font_size\";a:3:{s:2:\"id\";s:15:\"title_font_size\";s:5:\"value\";s:4:\"13px\";s:4:\"type\";s:4:\"text\";}s:17:\"title_line_height\";a:3:{s:2:\"id\";s:17:\"title_line_height\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:9:\"title_tag\";a:3:{s:2:\"id\";s:9:\"title_tag\";s:5:\"value\";s:1:\"p\";s:4:\"type\";s:7:\"options\";}s:17:\"custom_text_color\";a:3:{s:2:\"id\";s:17:\"custom_text_color\";s:5:\"value\";b:0;s:4:\"type\";s:5:\"color\";}s:17:\"content_font_size\";a:3:{s:2:\"id\";s:17:\"content_font_size\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:19:\"content_line_height\";a:3:{s:2:\"id\";s:19:\"content_line_height\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:9:\"btn_style\";a:3:{s:2:\"id\";s:9:\"btn_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:9:\"btn_shape\";a:3:{s:2:\"id\";s:9:\"btn_shape\";s:5:\"value\";s:9:\"rectangle\";s:4:\"type\";s:8:\"selector\";}s:8:\"btn_size\";a:3:{s:2:\"id\";s:8:\"btn_size\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:7:\"options\";}s:9:\"btn_color\";a:3:{s:2:\"id\";s:9:\"btn_color\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:7:\"options\";}s:12:\"btn_position\";a:3:{s:2:\"id\";s:12:\"btn_position\";s:5:\"value\";s:5:\"hover\";s:4:\"type\";s:7:\"options\";}}}i:1;a:3:{s:2:\"id\";s:20:\"d67rn77wk9dizs2t1y67\";s:4:\"type\";s:5:\"space\";s:6:\"params\";a:2:{s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:10;s:4:\"type\";s:6:\"slider\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:2;a:3:{s:2:\"id\";s:20:\"760cbxbqz94esw2fooaz\";s:4:\"type\";s:7:\"divider\";s:6:\"params\";a:2:{s:11:\"full_height\";a:3:{s:2:\"id\";s:11:\"full_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:3;a:3:{s:2:\"id\";s:20:\"caxmdk1uhf53rksbrj6x\";s:4:\"type\";s:5:\"space\";s:6:\"params\";a:2:{s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:10;s:4:\"type\";s:6:\"slider\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:4;a:3:{s:2:\"id\";s:20:\"cnp9n8j9vd9piydx94j5\";s:4:\"type\";s:7:\"infobox\";s:6:\"params\";a:61:{s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_text\";a:3:{s:2:\"id\";s:9:\"icon_text\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";a:4:{s:2:\"id\";i:136;s:3:\"url\";s:99:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-contact-expert.png\";s:5:\"width\";i:142;s:6:\"height\";i:48;}s:4:\"type\";s:5:\"image\";}s:8:\"img_size\";a:3:{s:2:\"id\";s:8:\"img_size\";s:5:\"value\";s:5:\"65x22\";s:4:\"type\";s:4:\"text\";}s:8:\"subtitle\";a:3:{s:2:\"id\";s:8:\"subtitle\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"textarea\";}s:5:\"title\";a:3:{s:2:\"id\";s:5:\"title\";s:5:\"value\";s:38:\"با ما در ارتباط باشید\";s:4:\"type\";s:8:\"textarea\";}s:7:\"content\";a:3:{s:2:\"id\";s:7:\"content\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"editor\";}s:8:\"btn_text\";a:3:{s:2:\"id\";s:8:\"btn_text\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:4:\"link\";a:3:{s:2:\"id\";s:4:\"link\";s:5:\"value\";a:1:{s:3:\"url\";s:1:\"#\";}s:4:\"type\";s:4:\"link\";}s:8:\"el_class\";a:3:{s:2:\"id\";s:8:\"el_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:4:\"base\";s:4:\"type\";s:7:\"options\";}s:21:\"woodmart_color_scheme\";a:3:{s:2:\"id\";s:21:\"woodmart_color_scheme\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"selector\";}s:27:\"woodmart_hover_color_scheme\";a:3:{s:2:\"id\";s:27:\"woodmart_hover_color_scheme\";s:5:\"value\";s:5:\"light\";s:4:\"type\";s:8:\"selector\";}s:9:\"alignment\";a:3:{s:2:\"id\";s:9:\"alignment\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:12:\"bg_image_box\";a:3:{s:2:\"id\";s:12:\"bg_image_box\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:17:\"bg_image_box_size\";a:3:{s:2:\"id\";s:17:\"bg_image_box_size\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:21:\"bg_image_box_position\";a:3:{s:2:\"id\";s:21:\"bg_image_box_position\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:19:\"bg_image_box_repeat\";a:3:{s:2:\"id\";s:19:\"bg_image_box_repeat\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:18:\"bg_image_box_sizes\";a:3:{s:2:\"id\";s:18:\"bg_image_box_sizes\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_image\";a:3:{s:2:\"id\";s:14:\"bg_hover_image\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:19:\"bg_hover_image_size\";a:3:{s:2:\"id\";s:19:\"bg_hover_image_size\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:23:\"bg_hover_image_position\";a:3:{s:2:\"id\";s:23:\"bg_hover_image_position\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:21:\"bg_hover_image_repeat\";a:3:{s:2:\"id\";s:21:\"bg_hover_image_repeat\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:20:\"bg_hover_image_sizes\";a:3:{s:2:\"id\";s:20:\"bg_hover_image_sizes\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:15:\"image_alignment\";a:3:{s:2:\"id\";s:15:\"image_alignment\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:24:\"image_vertical_alignment\";a:3:{s:2:\"id\";s:24:\"image_vertical_alignment\";s:5:\"value\";s:6:\"middle\";s:4:\"type\";s:8:\"selector\";}s:10:\"icon_style\";a:3:{s:2:\"id\";s:10:\"icon_style\";s:5:\"value\";s:6:\"simple\";s:4:\"type\";s:8:\"selector\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:17:\"icon_border_color\";a:3:{s:2:\"id\";s:17:\"icon_border_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:23:\"icon_border_hover_color\";a:3:{s:2:\"id\";s:23:\"icon_border_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"icon_text_size\";a:3:{s:2:\"id\";s:14:\"icon_text_size\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:7:\"options\";}s:15:\"icon_text_color\";a:3:{s:2:\"id\";s:15:\"icon_text_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:12:\"icon_spacing\";a:3:{s:2:\"id\";s:12:\"icon_spacing\";s:5:\"value\";i:10;s:4:\"type\";s:6:\"slider\";}s:14:\"subtitle_style\";a:3:{s:2:\"id\";s:14:\"subtitle_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:24:\"subtitle_custom_bg_color\";a:3:{s:2:\"id\";s:24:\"subtitle_custom_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:22:\"subtitle_style_divider\";a:3:{s:2:\"id\";s:22:\"subtitle_style_divider\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"divider\";}s:14:\"subtitle_color\";a:3:{s:2:\"id\";s:14:\"subtitle_color\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:7:\"options\";}s:21:\"subtitle_custom_color\";a:3:{s:2:\"id\";s:21:\"subtitle_custom_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"subtitle_font\";a:3:{s:2:\"id\";s:13:\"subtitle_font\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:20:\"subtitle_font_weight\";a:3:{s:2:\"id\";s:20:\"subtitle_font_weight\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:18:\"subtitle_font_size\";a:3:{s:2:\"id\";s:18:\"subtitle_font_size\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:20:\"subtitle_line_height\";a:3:{s:2:\"id\";s:20:\"subtitle_line_height\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:11:\"title_style\";a:3:{s:2:\"id\";s:11:\"title_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"title_color\";a:3:{s:2:\"id\";s:11:\"title_color\";s:5:\"value\";a:4:{s:1:\"r\";i:36;s:1:\"g\";i:36;s:1:\"b\";i:36;s:1:\"a\";i:1;}s:4:\"type\";s:5:\"color\";}s:10:\"title_font\";a:3:{s:2:\"id\";s:10:\"title_font\";s:5:\"value\";s:4:\"text\";s:4:\"type\";s:7:\"options\";}s:17:\"title_font_weight\";a:3:{s:2:\"id\";s:17:\"title_font_weight\";s:5:\"value\";s:3:\"400\";s:4:\"type\";s:7:\"options\";}s:10:\"title_size\";a:3:{s:2:\"id\";s:10:\"title_size\";s:5:\"value\";s:5:\"small\";s:4:\"type\";s:7:\"options\";}s:15:\"title_font_size\";a:3:{s:2:\"id\";s:15:\"title_font_size\";s:5:\"value\";s:4:\"13px\";s:4:\"type\";s:4:\"text\";}s:17:\"title_line_height\";a:3:{s:2:\"id\";s:17:\"title_line_height\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:9:\"title_tag\";a:3:{s:2:\"id\";s:9:\"title_tag\";s:5:\"value\";s:1:\"p\";s:4:\"type\";s:7:\"options\";}s:17:\"custom_text_color\";a:3:{s:2:\"id\";s:17:\"custom_text_color\";s:5:\"value\";b:0;s:4:\"type\";s:5:\"color\";}s:17:\"content_font_size\";a:3:{s:2:\"id\";s:17:\"content_font_size\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:19:\"content_line_height\";a:3:{s:2:\"id\";s:19:\"content_line_height\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:9:\"btn_style\";a:3:{s:2:\"id\";s:9:\"btn_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:9:\"btn_shape\";a:3:{s:2:\"id\";s:9:\"btn_shape\";s:5:\"value\";s:9:\"rectangle\";s:4:\"type\";s:8:\"selector\";}s:8:\"btn_size\";a:3:{s:2:\"id\";s:8:\"btn_size\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:7:\"options\";}s:9:\"btn_color\";a:3:{s:2:\"id\";s:9:\"btn_color\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:7:\"options\";}s:12:\"btn_position\";a:3:{s:2:\"id\";s:12:\"btn_position\";s:5:\"value\";s:5:\"hover\";s:4:\"type\";s:7:\"options\";}}}}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile1\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}}s:6:\"params\";a:12:{s:11:\"row_columns\";a:3:{s:2:\"id\";s:11:\"row_columns\";s:5:\"value\";s:1:\"3\";s:4:\"type\";s:8:\"selector\";}s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:40;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:40;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:40;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";a:1:{s:16:\"background-color\";a:4:{s:1:\"r\";i:16;s:1:\"g\";i:16;s:1:\"b\";i:16;s:1:\"a\";d:0.05;}}s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"border\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}i:1;a:4:{s:2:\"id\";s:14:\"general-header\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:6:{i:0;a:3:{s:2:\"id\";s:7:\"column8\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"gah2zyk1x87lql1mftwr\";s:4:\"type\";s:4:\"logo\";s:6:\"params\";a:6:{s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";a:4:{s:2:\"id\";i:65;s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-logo-black.svg\";s:5:\"width\";i:210;s:6:\"height\";i:40;}s:4:\"type\";s:5:\"image\";}s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:210;s:4:\"type\";s:6:\"slider\";}s:13:\"sticky_notice\";a:3:{s:2:\"id\";s:13:\"sticky_notice\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"notice\";}s:12:\"sticky_image\";a:3:{s:2:\"id\";s:12:\"sticky_image\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:12:\"sticky_width\";a:3:{s:2:\"id\";s:12:\"sticky_width\";s:5:\"value\";i:150;s:4:\"type\";s:6:\"slider\";}s:12:\"width_height\";a:3:{s:2:\"id\";s:12:\"width_height\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}}}}}i:1;a:3:{s:2:\"id\";s:7:\"column9\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"3dr2urezpqgndfjlfa22\";s:4:\"type\";s:6:\"search\";s:6:\"params\";a:29:{s:7:\"display\";a:3:{s:2:\"id\";s:7:\"display\";s:5:\"value\";s:4:\"form\";s:4:\"type\";s:8:\"selector\";}s:16:\"popular_requests\";a:3:{s:2:\"id\";s:16:\"popular_requests\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:19:\"categories_dropdown\";a:3:{s:2:\"id\";s:19:\"categories_dropdown\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:18:\"cat_selector_style\";a:3:{s:2:\"id\";s:18:\"cat_selector_style\";s:5:\"value\";s:8:\"bordered\";s:4:\"type\";s:8:\"selector\";}s:10:\"bg_overlay\";a:3:{s:2:\"id\";s:10:\"bg_overlay\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:4:\"ajax\";a:3:{s:2:\"id\";s:4:\"ajax\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:17:\"ajax_result_count\";a:3:{s:2:\"id\";s:17:\"ajax_result_count\";s:5:\"value\";i:20;s:4:\"type\";s:6:\"slider\";}s:9:\"post_type\";a:3:{s:2:\"id\";s:9:\"post_type\";s:5:\"value\";s:7:\"product\";s:4:\"type\";s:8:\"selector\";}s:12:\"search_style\";a:3:{s:2:\"id\";s:12:\"search_style\";s:5:\"value\";s:1:\"4\";s:4:\"type\";s:8:\"selector\";}s:10:\"form_shape\";a:3:{s:2:\"id\";s:10:\"form_shape\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:11:\"form_height\";a:3:{s:2:\"id\";s:11:\"form_height\";s:5:\"value\";i:42;s:4:\"type\";s:6:\"slider\";}s:10:\"form_color\";a:3:{s:2:\"id\";s:10:\"form_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:22:\"form_placeholder_color\";a:3:{s:2:\"id\";s:22:\"form_placeholder_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"form_brd_color\";a:3:{s:2:\"id\";s:14:\"form_brd_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:20:\"form_brd_color_focus\";a:3:{s:2:\"id\";s:20:\"form_brd_color_focus\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:7:\"form_bg\";a:3:{s:2:\"id\";s:7:\"form_bg\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"wrap_type\";a:3:{s:2:\"id\";s:9:\"wrap_type\";s:5:\"value\";s:9:\"icon_only\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"hover_color\";a:3:{s:2:\"id\";s:11:\"hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:10:\"icon_color\";a:3:{s:2:\"id\";s:10:\"icon_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:16:\"icon_hover_color\";a:3:{s:2:\"id\";s:16:\"icon_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}}}i:2;a:3:{s:2:\"id\";s:8:\"column10\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:4:{i:0;a:3:{s:2:\"id\";s:20:\"tu39rl1tsd8wpcxl7lnl\";s:4:\"type\";s:7:\"compare\";s:6:\"params\";a:15:{s:6:\"design\";a:3:{s:2:\"id\";s:6:\"design\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"7\";s:4:\"type\";s:8:\"selector\";}s:9:\"wrap_type\";a:3:{s:2:\"id\";s:9:\"wrap_type\";s:5:\"value\";s:9:\"icon_only\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";a:4:{s:1:\"r\";i:16;s:1:\"g\";i:16;s:1:\"b\";i:16;s:1:\"a\";d:0.7;}s:4:\"type\";s:5:\"color\";}s:11:\"hover_color\";a:3:{s:2:\"id\";s:11:\"hover_color\";s:5:\"value\";a:4:{s:1:\"r\";i:16;s:1:\"g\";i:16;s:1:\"b\";i:16;s:1:\"a\";d:0.5;}s:4:\"type\";s:5:\"color\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";a:4:{s:1:\"r\";i:16;s:1:\"g\";i:16;s:1:\"b\";i:16;s:1:\"a\";d:0.05;}s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";b:0;s:4:\"type\";s:5:\"color\";}s:10:\"icon_color\";a:3:{s:2:\"id\";s:10:\"icon_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:16:\"icon_hover_color\";a:3:{s:2:\"id\";s:16:\"icon_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:18:\"hide_product_count\";a:3:{s:2:\"id\";s:18:\"hide_product_count\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:22:\"show_dropdown_category\";a:3:{s:2:\"id\";s:22:\"show_dropdown_category\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}i:1;a:3:{s:2:\"id\";s:20:\"itc82qyu9f3s0tscappq\";s:4:\"type\";s:8:\"wishlist\";s:6:\"params\";a:14:{s:6:\"design\";a:3:{s:2:\"id\";s:6:\"design\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"7\";s:4:\"type\";s:8:\"selector\";}s:9:\"wrap_type\";a:3:{s:2:\"id\";s:9:\"wrap_type\";s:5:\"value\";s:9:\"icon_only\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";a:4:{s:1:\"r\";i:16;s:1:\"g\";i:16;s:1:\"b\";i:16;s:1:\"a\";d:0.7;}s:4:\"type\";s:5:\"color\";}s:11:\"hover_color\";a:3:{s:2:\"id\";s:11:\"hover_color\";s:5:\"value\";a:4:{s:1:\"r\";i:16;s:1:\"g\";i:16;s:1:\"b\";i:16;s:1:\"a\";d:0.5;}s:4:\"type\";s:5:\"color\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";a:4:{s:1:\"r\";i:16;s:1:\"g\";i:16;s:1:\"b\";i:16;s:1:\"a\";d:0.05;}s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:10:\"icon_color\";a:3:{s:2:\"id\";s:10:\"icon_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:16:\"icon_hover_color\";a:3:{s:2:\"id\";s:16:\"icon_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:18:\"hide_product_count\";a:3:{s:2:\"id\";s:18:\"hide_product_count\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}}}i:2;a:3:{s:2:\"id\";s:20:\"d3rr7l2o7d965a6qvawk\";s:4:\"type\";s:7:\"account\";s:6:\"params\";a:17:{s:13:\"with_username\";a:3:{s:2:\"id\";s:13:\"with_username\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:14:\"login_dropdown\";a:3:{s:2:\"id\";s:14:\"login_dropdown\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:12:\"form_display\";a:3:{s:2:\"id\";s:12:\"form_display\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}s:7:\"display\";a:3:{s:2:\"id\";s:7:\"display\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"7\";s:4:\"type\";s:8:\"selector\";}s:9:\"wrap_type\";a:3:{s:2:\"id\";s:9:\"wrap_type\";s:5:\"value\";s:13:\"icon_and_text\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";a:4:{s:1:\"r\";i:16;s:1:\"g\";i:16;s:1:\"b\";i:16;s:1:\"a\";d:0.7;}s:4:\"type\";s:5:\"color\";}s:11:\"hover_color\";a:3:{s:2:\"id\";s:11:\"hover_color\";s:5:\"value\";a:4:{s:1:\"r\";i:16;s:1:\"g\";i:16;s:1:\"b\";i:16;s:1:\"a\";d:0.5;}s:4:\"type\";s:5:\"color\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";a:4:{s:1:\"r\";i:16;s:1:\"g\";i:16;s:1:\"b\";i:16;s:1:\"a\";d:0.05;}s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";b:0;s:4:\"type\";s:5:\"color\";}s:10:\"icon_color\";a:3:{s:2:\"id\";s:10:\"icon_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:16:\"icon_hover_color\";a:3:{s:2:\"id\";s:16:\"icon_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:10:\"bg_overlay\";a:3:{s:2:\"id\";s:10:\"bg_overlay\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}i:3;a:3:{s:2:\"id\";s:20:\"1tzj5wztzw6bwmvl2bt8\";s:4:\"type\";s:4:\"cart\";s:6:\"params\";a:15:{s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}s:10:\"bg_overlay\";a:3:{s:2:\"id\";s:10:\"bg_overlay\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"design\";a:3:{s:2:\"id\";s:6:\"design\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:1:\"4\";s:4:\"type\";s:8:\"selector\";}s:9:\"wrap_type\";a:3:{s:2:\"id\";s:9:\"wrap_type\";s:5:\"value\";s:13:\"icon_and_text\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";a:4:{s:1:\"r\";i:255;s:1:\"g\";i:255;s:1:\"b\";i:255;s:1:\"a\";i:1;}s:4:\"type\";s:5:\"color\";}s:11:\"hover_color\";a:3:{s:2:\"id\";s:11:\"hover_color\";s:5:\"value\";a:4:{s:1:\"r\";i:255;s:1:\"g\";i:255;s:1:\"b\";i:255;s:1:\"a\";d:0.9;}s:4:\"type\";s:5:\"color\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";a:4:{s:1:\"r\";i:16;s:1:\"g\";i:16;s:1:\"b\";i:16;s:1:\"a\";i:1;}s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";a:4:{s:1:\"r\";i:36;s:1:\"g\";i:36;s:1:\"b\";i:36;s:1:\"a\";i:1;}s:4:\"type\";s:5:\"color\";}s:10:\"icon_color\";a:3:{s:2:\"id\";s:10:\"icon_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:16:\"icon_hover_color\";a:3:{s:2:\"id\";s:16:\"icon_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:4:\"cart\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile2\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"xppwexc5im2rbevb30qi\";s:4:\"type\";s:6:\"burger\";s:6:\"params\";a:28:{s:9:\"close_btn\";a:3:{s:2:\"id\";s:9:\"close_btn\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"search_form\";a:3:{s:2:\"id\";s:11:\"search_form\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:9:\"post_type\";a:3:{s:2:\"id\";s:9:\"post_type\";s:5:\"value\";s:7:\"product\";s:4:\"type\";s:8:\"selector\";}s:13:\"show_wishlist\";a:3:{s:2:\"id\";s:13:\"show_wishlist\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:12:\"show_compare\";a:3:{s:2:\"id\";s:12:\"show_compare\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:12:\"show_account\";a:3:{s:2:\"id\";s:12:\"show_account\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:15:\"show_html_block\";a:3:{s:2:\"id\";s:15:\"show_html_block\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"languages\";a:3:{s:2:\"id\";s:9:\"languages\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:18:\"show_language_flag\";a:3:{s:2:\"id\";s:18:\"show_language_flag\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:15:\"categories_menu\";a:3:{s:2:\"id\";s:15:\"categories_menu\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:18:\"primary_menu_title\";a:3:{s:2:\"id\";s:18:\"primary_menu_title\";s:5:\"value\";s:4:\"Menu\";s:4:\"type\";s:4:\"text\";}s:20:\"secondary_menu_title\";a:3:{s:2:\"id\";s:20:\"secondary_menu_title\";s:5:\"value\";s:10:\"Categories\";s:4:\"type\";s:4:\"text\";}s:7:\"menu_id\";a:3:{s:2:\"id\";s:7:\"menu_id\";s:5:\"value\";s:15:\"main-navigation\";s:4:\"type\";s:7:\"options\";}s:9:\"tabs_swap\";a:3:{s:2:\"id\";s:9:\"tabs_swap\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"wrap_type\";a:3:{s:2:\"id\";s:9:\"wrap_type\";s:5:\"value\";s:9:\"icon_only\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"hover_color\";a:3:{s:2:\"id\";s:11:\"hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:10:\"icon_color\";a:3:{s:2:\"id\";s:10:\"icon_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:16:\"icon_hover_color\";a:3:{s:2:\"id\";s:16:\"icon_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}}}i:4;a:3:{s:2:\"id\";s:14:\"column_mobile3\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"yvtmdkxjypezrv8noxwa\";s:4:\"type\";s:4:\"logo\";s:6:\"params\";a:6:{s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";a:4:{s:2:\"id\";i:65;s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-logo-black.svg\";s:5:\"width\";i:210;s:6:\"height\";i:40;}s:4:\"type\";s:5:\"image\";}s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:180;s:4:\"type\";s:6:\"slider\";}s:13:\"sticky_notice\";a:3:{s:2:\"id\";s:13:\"sticky_notice\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"notice\";}s:12:\"sticky_image\";a:3:{s:2:\"id\";s:12:\"sticky_image\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:12:\"sticky_width\";a:3:{s:2:\"id\";s:12:\"sticky_width\";s:5:\"value\";i:150;s:4:\"type\";s:6:\"slider\";}s:12:\"width_height\";a:3:{s:2:\"id\";s:12:\"width_height\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}}}}}i:5;a:3:{s:2:\"id\";s:14:\"column_mobile4\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"mihkuax1jyl7xcxh2vkb\";s:4:\"type\";s:4:\"cart\";s:6:\"params\";a:15:{s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}s:10:\"bg_overlay\";a:3:{s:2:\"id\";s:10:\"bg_overlay\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"design\";a:3:{s:2:\"id\";s:6:\"design\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:1:\"2\";s:4:\"type\";s:8:\"selector\";}s:9:\"wrap_type\";a:3:{s:2:\"id\";s:9:\"wrap_type\";s:5:\"value\";s:9:\"icon_only\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"hover_color\";a:3:{s:2:\"id\";s:11:\"hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:10:\"icon_color\";a:3:{s:2:\"id\";s:10:\"icon_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:16:\"icon_hover_color\";a:3:{s:2:\"id\";s:16:\"icon_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:4:\"cart\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}}}}s:6:\"params\";a:12:{s:11:\"row_columns\";a:3:{s:2:\"id\";s:11:\"row_columns\";s:5:\"value\";s:1:\"3\";s:4:\"type\";s:8:\"selector\";}s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:64;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:60;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";a:1:{s:16:\"background-color\";a:4:{s:1:\"r\";i:251;s:1:\"g\";i:250;s:1:\"b\";i:247;s:1:\"a\";i:1;}}s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"border\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}i:2;a:4:{s:2:\"id\";s:13:\"header-bottom\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:4:{i:0;a:3:{s:2:\"id\";s:8:\"column11\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"n35jlqoy8ewgtg8zgvc5\";s:4:\"type\";s:8:\"mainmenu\";s:6:\"params\";a:20:{s:7:\"menu_id\";a:3:{s:2:\"id\";s:7:\"menu_id\";s:5:\"value\";s:15:\"main-navigation\";s:4:\"type\";s:7:\"options\";}s:11:\"full_screen\";a:3:{s:2:\"id\";s:11:\"full_screen\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:4:\"text\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"wrap_type\";a:3:{s:2:\"id\";s:9:\"wrap_type\";s:5:\"value\";s:9:\"icon_only\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"hover_color\";a:3:{s:2:\"id\";s:11:\"hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:10:\"icon_color\";a:3:{s:2:\"id\";s:10:\"icon_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:16:\"icon_hover_color\";a:3:{s:2:\"id\";s:16:\"icon_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:10:\"menu_style\";a:3:{s:2:\"id\";s:10:\"menu_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:10:\"menu_align\";a:3:{s:2:\"id\";s:10:\"menu_align\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:9:\"items_gap\";a:3:{s:2:\"id\";s:9:\"items_gap\";s:5:\"value\";s:1:\"m\";s:4:\"type\";s:8:\"selector\";}s:10:\"bg_overlay\";a:3:{s:2:\"id\";s:10:\"bg_overlay\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"inline\";a:3:{s:2:\"id\";s:6:\"inline\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}i:1;a:3:{s:2:\"id\";s:8:\"column12\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:2;a:3:{s:2:\"id\";s:8:\"column13\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"v3xalsxx5qj6k8pocye1\";s:4:\"type\";s:6:\"button\";s:6:\"params\";a:28:{s:5:\"title\";a:3:{s:2:\"id\";s:5:\"title\";s:5:\"value\";s:60:\"ارسال رایگان تا سقف 1300 هزار تومان\";s:4:\"type\";s:4:\"text\";}s:4:\"link\";a:3:{s:2:\"id\";s:4:\"link\";s:5:\"value\";a:1:{s:3:\"url\";s:0:\"\";}s:4:\"type\";s:4:\"link\";}s:20:\"button_smooth_scroll\";a:3:{s:2:\"id\";s:20:\"button_smooth_scroll\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:25:\"button_smooth_scroll_time\";a:3:{s:2:\"id\";s:25:\"button_smooth_scroll_time\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:27:\"button_smooth_scroll_offset\";a:3:{s:2:\"id\";s:27:\"button_smooth_scroll_offset\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:8:\"el_class\";a:3:{s:2:\"id\";s:8:\"el_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:5:\"shape\";a:3:{s:2:\"id\";s:5:\"shape\";s:5:\"value\";s:5:\"round\";s:4:\"type\";s:8:\"selector\";}s:4:\"size\";a:3:{s:2:\"id\";s:4:\"size\";s:5:\"value\";s:11:\"extra-small\";s:4:\"type\";s:7:\"options\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:3:\"alt\";s:4:\"type\";s:7:\"options\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";a:4:{s:1:\"r\";i:224;s:1:\"g\";i:234;s:1:\"b\";i:240;s:1:\"a\";i:1;}s:4:\"type\";s:5:\"color\";}s:14:\"bg_color_hover\";a:3:{s:2:\"id\";s:14:\"bg_color_hover\";s:5:\"value\";a:4:{s:1:\"r\";i:215;s:1:\"g\";i:229;s:1:\"b\";i:237;s:1:\"a\";i:1;}s:4:\"type\";s:5:\"color\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:19:\"custom_color_scheme\";a:3:{s:2:\"id\";s:19:\"custom_color_scheme\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:20:\"color_scheme_divider\";a:3:{s:2:\"id\";s:20:\"color_scheme_divider\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"divider\";}s:18:\"color_scheme_hover\";a:3:{s:2:\"id\";s:18:\"color_scheme_hover\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:25:\"custom_color_scheme_hover\";a:3:{s:2:\"id\";s:25:\"custom_color_scheme_hover\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:12:\"icon_library\";a:3:{s:2:\"id\";s:12:\"icon_library\";s:5:\"value\";s:11:\"fontawesome\";s:4:\"type\";s:7:\"options\";}s:16:\"icon_fontawesome\";a:3:{s:2:\"id\";s:16:\"icon_fontawesome\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:15:\"icon_openiconic\";a:3:{s:2:\"id\";s:15:\"icon_openiconic\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:13:\"icon_typicons\";a:3:{s:2:\"id\";s:13:\"icon_typicons\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:11:\"icon_entypo\";a:3:{s:2:\"id\";s:11:\"icon_entypo\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:13:\"icon_linecons\";a:3:{s:2:\"id\";s:13:\"icon_linecons\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:15:\"icon_monosocial\";a:3:{s:2:\"id\";s:15:\"icon_monosocial\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:13:\"icon_material\";a:3:{s:2:\"id\";s:13:\"icon_material\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";b:0;s:4:\"type\";s:5:\"image\";}s:8:\"img_size\";a:3:{s:2:\"id\";s:8:\"img_size\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:13:\"icon_position\";a:3:{s:2:\"id\";s:13:\"icon_position\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}}}}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile5\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}}s:6:\"params\";a:12:{s:11:\"row_columns\";a:3:{s:2:\"id\";s:11:\"row_columns\";s:5:\"value\";s:1:\"3\";s:4:\"type\";s:8:\"selector\";}s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:45;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:45;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:45;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";a:1:{s:16:\"background-color\";a:4:{s:1:\"r\";i:251;s:1:\"g\";i:250;s:1:\"b\";i:247;s:1:\"a\";i:1;}}s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"border\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}s:8:\"settings\";a:9:{s:7:\"overlap\";a:3:{s:2:\"id\";s:7:\"overlap\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:5:\"boxed\";a:3:{s:2:\"id\";s:5:\"boxed\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"full_width\";a:3:{s:2:\"id\";s:10:\"full_width\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:14:\"dropdowns_dark\";a:3:{s:2:\"id\";s:14:\"dropdowns_dark\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_shadow\";a:3:{s:2:\"id\";s:13:\"sticky_shadow\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:14:\"hide_on_scroll\";a:3:{s:2:\"id\";s:14:\"hide_on_scroll\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_effect\";a:3:{s:2:\"id\";s:13:\"sticky_effect\";s:5:\"value\";s:5:\"slide\";s:4:\"type\";s:8:\"selector\";}s:12:\"sticky_clone\";a:3:{s:2:\"id\";s:12:\"sticky_clone\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}}}", "yes");
INSERT INTO `wp_options` VALUES("549", "whb_main_header", "header_937146", "yes");
INSERT INTO `wp_options` VALUES("550", "wd_layouts_conditions", "a:5:{s:13:\"checkout_form\";a:1:{i:1084;a:1:{i:0;a:3:{s:20:\"condition_comparison\";s:7:\"include\";s:14:\"condition_type\";s:13:\"checkout_form\";s:15:\"condition_query\";s:0:\"\";}}}s:16:\"checkout_content\";a:1:{i:1079;a:1:{i:0;a:3:{s:20:\"condition_comparison\";s:7:\"include\";s:14:\"condition_type\";s:16:\"checkout_content\";s:15:\"condition_query\";s:0:\"\";}}}s:4:\"cart\";a:1:{i:1066;a:1:{i:0;a:3:{s:20:\"condition_comparison\";s:7:\"include\";s:14:\"condition_type\";s:4:\"cart\";s:15:\"condition_query\";s:0:\"\";}}}s:12:\"shop_archive\";a:1:{i:1419;a:1:{i:0;a:3:{s:20:\"condition_comparison\";s:7:\"include\";s:14:\"condition_type\";s:3:\"all\";s:15:\"condition_query\";s:0:\"\";}}}s:14:\"single_product\";a:1:{i:711;a:1:{i:0;a:3:{s:20:\"condition_comparison\";s:7:\"include\";s:14:\"condition_type\";s:3:\"all\";s:15:\"condition_query\";s:0:\"\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("551", "elementor_cpt_support", "a:7:{i:0;s:4:\"page\";i:1;s:9:\"all_posts\";i:2;s:7:\"product\";i:3;s:9:\"portfolio\";i:4;s:9:\"cms_block\";i:5;s:14:\"woodmart_slide\";i:6;s:15:\"woodmart_layout\";}", "yes");
INSERT INTO `wp_options` VALUES("552", "elementor_disable_color_schemes", "yes", "yes");
INSERT INTO `wp_options` VALUES("553", "elementor_disable_typography_schemes", "yes", "yes");
INSERT INTO `wp_options` VALUES("562", "wd_import_imported_versions", "a:2:{i:0;s:15:\"furniture2_base\";i:1;s:10:\"furniture2\";}", "yes");
INSERT INTO `wp_options` VALUES("563", "wd_import_current_base", "furniture2_base", "yes");
INSERT INTO `wp_options` VALUES("570", "elementor_library_category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("571", "cms_block_cat_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("572", "woodmart_slider_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("573", "project-cat_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("575", "wd_imported_data_furniture2", "a:10:{s:4:\"term\";a:2:{s:15:\"woodmart_slider\";a:1:{i:73;a:3:{s:3:\"new\";i:69;s:3:\"old\";i:73;s:4:\"type\";s:15:\"woodmart_slider\";}}s:8:\"nav_menu\";a:1:{i:30;a:3:{s:3:\"new\";i:70;s:3:\"old\";i:30;s:4:\"type\";s:8:\"nav_menu\";}}}s:9:\"all_posts\";a:41:{i:65;a:3:{s:3:\"old\";i:65;s:3:\"new\";i:65;s:9:\"post_type\";s:10:\"attachment\";}i:90;a:3:{s:3:\"old\";i:90;s:3:\"new\";i:90;s:9:\"post_type\";s:10:\"attachment\";}i:91;a:3:{s:3:\"old\";i:91;s:3:\"new\";i:91;s:9:\"post_type\";s:10:\"attachment\";}i:92;a:3:{s:3:\"old\";i:92;s:3:\"new\";i:92;s:9:\"post_type\";s:10:\"attachment\";}i:93;a:3:{s:3:\"old\";i:93;s:3:\"new\";i:93;s:9:\"post_type\";s:10:\"attachment\";}i:96;a:3:{s:3:\"old\";i:96;s:3:\"new\";i:96;s:9:\"post_type\";s:10:\"attachment\";}i:97;a:3:{s:3:\"old\";i:97;s:3:\"new\";i:97;s:9:\"post_type\";s:10:\"attachment\";}i:107;a:3:{s:3:\"old\";i:107;s:3:\"new\";i:107;s:9:\"post_type\";s:10:\"attachment\";}i:119;a:3:{s:3:\"old\";i:119;s:3:\"new\";i:119;s:9:\"post_type\";s:10:\"attachment\";}i:127;a:3:{s:3:\"old\";i:127;s:3:\"new\";i:127;s:9:\"post_type\";s:10:\"attachment\";}i:137;a:3:{s:3:\"old\";i:137;s:3:\"new\";i:137;s:9:\"post_type\";s:10:\"attachment\";}i:138;a:3:{s:3:\"old\";i:138;s:3:\"new\";i:138;s:9:\"post_type\";s:10:\"attachment\";}i:711;a:4:{s:3:\"old\";i:711;s:3:\"new\";i:711;s:9:\"post_type\";s:15:\"woodmart_layout\";s:4:\"type\";s:9:\"elementor\";}i:760;a:4:{s:3:\"old\";i:760;s:3:\"new\";i:760;s:9:\"post_type\";s:9:\"cms_block\";s:4:\"type\";s:9:\"elementor\";}i:788;a:4:{s:3:\"old\";i:788;s:3:\"new\";i:788;s:9:\"post_type\";s:9:\"cms_block\";s:4:\"type\";s:9:\"elementor\";}i:1034;a:4:{s:3:\"old\";i:1034;s:3:\"new\";i:1419;s:9:\"post_type\";s:15:\"woodmart_layout\";s:4:\"type\";s:9:\"elementor\";}i:1049;a:3:{s:3:\"old\";i:1049;s:3:\"new\";i:1049;s:9:\"post_type\";s:10:\"attachment\";}i:1066;a:4:{s:3:\"old\";i:1066;s:3:\"new\";i:1066;s:9:\"post_type\";s:15:\"woodmart_layout\";s:4:\"type\";s:9:\"elementor\";}i:1079;a:4:{s:3:\"old\";i:1079;s:3:\"new\";i:1079;s:9:\"post_type\";s:15:\"woodmart_layout\";s:4:\"type\";s:9:\"elementor\";}i:1084;a:4:{s:3:\"old\";i:1084;s:3:\"new\";i:1084;s:9:\"post_type\";s:15:\"woodmart_layout\";s:4:\"type\";s:9:\"elementor\";}i:86;a:3:{s:3:\"old\";i:86;s:3:\"new\";i:1420;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:87;a:3:{s:3:\"old\";i:87;s:3:\"new\";i:1421;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:88;a:3:{s:3:\"old\";i:88;s:3:\"new\";i:1422;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:118;a:3:{s:3:\"old\";i:118;s:3:\"new\";i:118;s:9:\"post_type\";s:10:\"attachment\";}i:122;a:3:{s:3:\"old\";i:122;s:3:\"new\";i:122;s:9:\"post_type\";s:10:\"attachment\";}i:123;a:3:{s:3:\"old\";i:123;s:3:\"new\";i:123;s:9:\"post_type\";s:10:\"attachment\";}i:151;a:4:{s:3:\"old\";i:151;s:3:\"new\";i:151;s:9:\"post_type\";s:14:\"woodmart_slide\";s:4:\"type\";s:9:\"elementor\";}i:152;a:3:{s:3:\"old\";i:152;s:3:\"new\";i:152;s:9:\"post_type\";s:10:\"attachment\";}i:184;a:3:{s:3:\"old\";i:184;s:3:\"new\";i:184;s:9:\"post_type\";s:10:\"attachment\";}i:217;a:4:{s:3:\"old\";i:217;s:3:\"new\";i:217;s:9:\"post_type\";s:14:\"woodmart_slide\";s:4:\"type\";s:9:\"elementor\";}i:218;a:3:{s:3:\"old\";i:218;s:3:\"new\";i:218;s:9:\"post_type\";s:10:\"attachment\";}i:226;a:4:{s:3:\"old\";i:226;s:3:\"new\";i:226;s:9:\"post_type\";s:14:\"woodmart_slide\";s:4:\"type\";s:9:\"elementor\";}i:227;a:3:{s:3:\"old\";i:227;s:3:\"new\";i:227;s:9:\"post_type\";s:10:\"attachment\";}i:229;a:3:{s:3:\"old\";i:229;s:3:\"new\";i:229;s:9:\"post_type\";s:10:\"attachment\";}i:233;a:3:{s:3:\"old\";i:233;s:3:\"new\";i:233;s:9:\"post_type\";s:10:\"attachment\";}i:758;a:3:{s:3:\"old\";i:758;s:3:\"new\";i:758;s:9:\"post_type\";s:19:\"woodmart_size_guide\";}i:762;a:3:{s:3:\"old\";i:762;s:3:\"new\";i:762;s:9:\"post_type\";s:10:\"attachment\";}i:1388;a:4:{s:3:\"old\";i:1388;s:3:\"new\";i:1388;s:9:\"post_type\";s:9:\"cms_block\";s:4:\"type\";s:9:\"elementor\";}i:1390;a:3:{s:3:\"old\";i:1390;s:3:\"new\";i:1390;s:9:\"post_type\";s:10:\"attachment\";}i:1393;a:3:{s:3:\"old\";i:1393;s:3:\"new\";i:1393;s:9:\"post_type\";s:10:\"mc4wp-form\";}i:89;a:3:{s:3:\"old\";i:89;s:3:\"new\";i:1423;s:9:\"post_type\";s:13:\"nav_menu_item\";}}s:10:\"attachment\";a:24:{i:65;a:3:{s:3:\"old\";i:65;s:3:\"new\";i:65;s:9:\"post_type\";s:10:\"attachment\";}i:90;a:3:{s:3:\"old\";i:90;s:3:\"new\";i:90;s:9:\"post_type\";s:10:\"attachment\";}i:91;a:3:{s:3:\"old\";i:91;s:3:\"new\";i:91;s:9:\"post_type\";s:10:\"attachment\";}i:92;a:3:{s:3:\"old\";i:92;s:3:\"new\";i:92;s:9:\"post_type\";s:10:\"attachment\";}i:93;a:3:{s:3:\"old\";i:93;s:3:\"new\";i:93;s:9:\"post_type\";s:10:\"attachment\";}i:96;a:3:{s:3:\"old\";i:96;s:3:\"new\";i:96;s:9:\"post_type\";s:10:\"attachment\";}i:97;a:3:{s:3:\"old\";i:97;s:3:\"new\";i:97;s:9:\"post_type\";s:10:\"attachment\";}i:107;a:3:{s:3:\"old\";i:107;s:3:\"new\";i:107;s:9:\"post_type\";s:10:\"attachment\";}i:119;a:3:{s:3:\"old\";i:119;s:3:\"new\";i:119;s:9:\"post_type\";s:10:\"attachment\";}i:127;a:3:{s:3:\"old\";i:127;s:3:\"new\";i:127;s:9:\"post_type\";s:10:\"attachment\";}i:137;a:3:{s:3:\"old\";i:137;s:3:\"new\";i:137;s:9:\"post_type\";s:10:\"attachment\";}i:138;a:3:{s:3:\"old\";i:138;s:3:\"new\";i:138;s:9:\"post_type\";s:10:\"attachment\";}i:1049;a:3:{s:3:\"old\";i:1049;s:3:\"new\";i:1049;s:9:\"post_type\";s:10:\"attachment\";}i:118;a:3:{s:3:\"old\";i:118;s:3:\"new\";i:118;s:9:\"post_type\";s:10:\"attachment\";}i:122;a:3:{s:3:\"old\";i:122;s:3:\"new\";i:122;s:9:\"post_type\";s:10:\"attachment\";}i:123;a:3:{s:3:\"old\";i:123;s:3:\"new\";i:123;s:9:\"post_type\";s:10:\"attachment\";}i:152;a:3:{s:3:\"old\";i:152;s:3:\"new\";i:152;s:9:\"post_type\";s:10:\"attachment\";}i:184;a:3:{s:3:\"old\";i:184;s:3:\"new\";i:184;s:9:\"post_type\";s:10:\"attachment\";}i:218;a:3:{s:3:\"old\";i:218;s:3:\"new\";i:218;s:9:\"post_type\";s:10:\"attachment\";}i:227;a:3:{s:3:\"old\";i:227;s:3:\"new\";i:227;s:9:\"post_type\";s:10:\"attachment\";}i:229;a:3:{s:3:\"old\";i:229;s:3:\"new\";i:229;s:9:\"post_type\";s:10:\"attachment\";}i:233;a:3:{s:3:\"old\";i:233;s:3:\"new\";i:233;s:9:\"post_type\";s:10:\"attachment\";}i:762;a:3:{s:3:\"old\";i:762;s:3:\"new\";i:762;s:9:\"post_type\";s:10:\"attachment\";}i:1390;a:3:{s:3:\"old\";i:1390;s:3:\"new\";i:1390;s:9:\"post_type\";s:10:\"attachment\";}}s:15:\"woodmart_layout\";a:5:{i:711;a:4:{s:3:\"old\";i:711;s:3:\"new\";i:711;s:9:\"post_type\";s:15:\"woodmart_layout\";s:4:\"type\";s:9:\"elementor\";}i:1034;a:4:{s:3:\"old\";i:1034;s:3:\"new\";i:1419;s:9:\"post_type\";s:15:\"woodmart_layout\";s:4:\"type\";s:9:\"elementor\";}i:1066;a:4:{s:3:\"old\";i:1066;s:3:\"new\";i:1066;s:9:\"post_type\";s:15:\"woodmart_layout\";s:4:\"type\";s:9:\"elementor\";}i:1079;a:4:{s:3:\"old\";i:1079;s:3:\"new\";i:1079;s:9:\"post_type\";s:15:\"woodmart_layout\";s:4:\"type\";s:9:\"elementor\";}i:1084;a:4:{s:3:\"old\";i:1084;s:3:\"new\";i:1084;s:9:\"post_type\";s:15:\"woodmart_layout\";s:4:\"type\";s:9:\"elementor\";}}s:9:\"cms_block\";a:3:{i:760;a:4:{s:3:\"old\";i:760;s:3:\"new\";i:760;s:9:\"post_type\";s:9:\"cms_block\";s:4:\"type\";s:9:\"elementor\";}i:788;a:4:{s:3:\"old\";i:788;s:3:\"new\";i:788;s:9:\"post_type\";s:9:\"cms_block\";s:4:\"type\";s:9:\"elementor\";}i:1388;a:4:{s:3:\"old\";i:1388;s:3:\"new\";i:1388;s:9:\"post_type\";s:9:\"cms_block\";s:4:\"type\";s:9:\"elementor\";}}s:13:\"nav_menu_item\";a:4:{i:86;a:3:{s:3:\"old\";i:86;s:3:\"new\";i:1420;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:87;a:3:{s:3:\"old\";i:87;s:3:\"new\";i:1421;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:88;a:3:{s:3:\"old\";i:88;s:3:\"new\";i:1422;s:9:\"post_type\";s:13:\"nav_menu_item\";}i:89;a:3:{s:3:\"old\";i:89;s:3:\"new\";i:1423;s:9:\"post_type\";s:13:\"nav_menu_item\";}}s:14:\"woodmart_slide\";a:3:{i:151;a:4:{s:3:\"old\";i:151;s:3:\"new\";i:151;s:9:\"post_type\";s:14:\"woodmart_slide\";s:4:\"type\";s:9:\"elementor\";}i:217;a:4:{s:3:\"old\";i:217;s:3:\"new\";i:217;s:9:\"post_type\";s:14:\"woodmart_slide\";s:4:\"type\";s:9:\"elementor\";}i:226;a:4:{s:3:\"old\";i:226;s:3:\"new\";i:226;s:9:\"post_type\";s:14:\"woodmart_slide\";s:4:\"type\";s:9:\"elementor\";}}s:19:\"woodmart_size_guide\";a:1:{i:758;a:3:{s:3:\"old\";i:758;s:3:\"new\";i:758;s:9:\"post_type\";s:19:\"woodmart_size_guide\";}}s:10:\"mc4wp-form\";a:1:{i:1393;a:3:{s:3:\"old\";i:1393;s:3:\"new\";i:1393;s:9:\"post_type\";s:10:\"mc4wp-form\";}}s:7:\"headers\";a:2:{s:13:\"header_937146\";s:13:\"header_937146\";s:13:\"header_183299\";s:13:\"header_183299\";}}", "yes");
INSERT INTO `wp_options` VALUES("579", "xts-header_183299-file-data", "a:3:{s:4:\"path\";s:41:\"/2023/09/xts-header_183299-1694017714.css\";s:13:\"theme_version\";s:5:\"7.3.0\";s:8:\"site_url\";s:32:\"df3453a0a212ae6729733a32d3776515\";}", "yes");
INSERT INTO `wp_options` VALUES("580", "xts-header_183299-css-data", ":root{\n	--wd-top-bar-h: 0.001px;\n	--wd-top-bar-sm-h: 0.001px;\n	--wd-top-bar-sticky-h: 0.001px;\n\n	--wd-header-general-h: 90px;\n	--wd-header-general-sm-h: 60px;\n	--wd-header-general-sticky-h: 0.001px;\n\n	--wd-header-bottom-h: 0.001px;\n	--wd-header-bottom-sm-h: 0.001px;\n	--wd-header-bottom-sticky-h: 0.001px;\n\n	--wd-header-clone-h: 0.001px;\n}\n\n\n\n\n\n@media (min-width: 1025px) {\n	\n		.whb-general-header-inner {\n		height: 90px;\n		max-height: 90px;\n	}\n\n		.whb-sticked .whb-general-header-inner {\n		height: 60px;\n		max-height: 60px;\n	}\n		\n	\n	\n	}\n\n@media (max-width: 1024px) {\n	\n		.whb-general-header-inner {\n		height: 60px;\n		max-height: 60px;\n	}\n	\n	\n	\n	}\n		.whb-top-bar-inner { border-color: rgba(255, 255, 255, 0.25);border-bottom-width: 1px;border-bottom-style: solid; }\n.whb-general-header {\n	border-bottom-width: 0px;border-bottom-style: solid;\n}\n\n.whb-header-bottom {\n	border-color: rgba(230, 230, 230, 1);border-bottom-width: 1px;border-bottom-style: solid;\n}\n", "yes");
INSERT INTO `wp_options` VALUES("581", "xts-header_183299-status", "valid", "yes");
INSERT INTO `wp_options` VALUES("582", "xts-header_183299-version", "7.3.0", "yes");
INSERT INTO `wp_options` VALUES("583", "xts-header_183299-site-url", "df3453a0a212ae6729733a32d3776515", "yes");
INSERT INTO `wp_options` VALUES("584", "whb_header_183299", "a:4:{s:4:\"name\";s:27:\"Header Furniture 2 checkout\";s:2:\"id\";s:13:\"header_183299\";s:9:\"structure\";a:3:{s:2:\"id\";s:4:\"root\";s:4:\"type\";s:4:\"root\";s:7:\"content\";a:3:{i:0;a:4:{s:2:\"id\";s:7:\"top-bar\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:4:{i:0;a:3:{s:2:\"id\";s:7:\"column5\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:1;a:3:{s:2:\"id\";s:7:\"column6\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:2;a:3:{s:2:\"id\";s:7:\"column7\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile1\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}}s:6:\"params\";a:11:{s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:45;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:40;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:41;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:5:\"light\";s:4:\"type\";s:8:\"selector\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";a:0:{}s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";a:4:{s:5:\"width\";s:1:\"1\";s:5:\"color\";a:4:{s:1:\"r\";i:255;s:1:\"g\";i:255;s:1:\"b\";i:255;s:1:\"a\";d:0.25;}s:5:\"sides\";a:1:{i:0;s:6:\"bottom\";}s:8:\"applyFor\";s:5:\"boxed\";}s:4:\"type\";s:6:\"border\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}i:1;a:4:{s:2:\"id\";s:14:\"general-header\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:6:{i:0;a:3:{s:2:\"id\";s:7:\"column8\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:1;a:3:{s:2:\"id\";s:7:\"column9\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"gs8bcnxektjsro21n657\";s:4:\"type\";s:4:\"logo\";s:6:\"params\";a:6:{s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";a:4:{s:2:\"id\";i:65;s:3:\"url\";s:118:\"http://dummy.xtemos.com/woodmart2/furniture2-elementor/wp-content/uploads/sites/10/2023/04/wd-furniture-logo-black.svg\";s:5:\"width\";i:210;s:6:\"height\";i:40;}s:4:\"type\";s:5:\"image\";}s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:220;s:4:\"type\";s:6:\"slider\";}s:13:\"sticky_notice\";a:3:{s:2:\"id\";s:13:\"sticky_notice\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"notice\";}s:12:\"sticky_image\";a:3:{s:2:\"id\";s:12:\"sticky_image\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:12:\"sticky_width\";a:3:{s:2:\"id\";s:12:\"sticky_width\";s:5:\"value\";i:245;s:4:\"type\";s:6:\"slider\";}s:12:\"width_height\";a:3:{s:2:\"id\";s:12:\"width_height\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}}}}}i:2;a:3:{s:2:\"id\";s:8:\"column10\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile2\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:4;a:3:{s:2:\"id\";s:14:\"column_mobile3\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"lt7vdqgaccmapftzurvt\";s:4:\"type\";s:4:\"logo\";s:6:\"params\";a:6:{s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";a:4:{s:2:\"id\";i:65;s:3:\"url\";s:118:\"http://dummy.xtemos.com/woodmart2/furniture2-elementor/wp-content/uploads/sites/10/2023/04/wd-furniture-logo-black.svg\";s:5:\"width\";i:210;s:6:\"height\";i:40;}s:4:\"type\";s:5:\"image\";}s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:179;s:4:\"type\";s:6:\"slider\";}s:13:\"sticky_notice\";a:3:{s:2:\"id\";s:13:\"sticky_notice\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"notice\";}s:12:\"sticky_image\";a:3:{s:2:\"id\";s:12:\"sticky_image\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:12:\"sticky_width\";a:3:{s:2:\"id\";s:12:\"sticky_width\";s:5:\"value\";i:179;s:4:\"type\";s:6:\"slider\";}s:12:\"width_height\";a:3:{s:2:\"id\";s:12:\"width_height\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}}}}}i:5;a:3:{s:2:\"id\";s:14:\"column_mobile4\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}}s:6:\"params\";a:11:{s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"equal-sides\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:90;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:60;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:60;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";a:0:{}s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";a:4:{s:5:\"width\";s:1:\"0\";s:8:\"applyFor\";s:9:\"fullwidth\";s:5:\"style\";s:5:\"solid\";s:5:\"sides\";a:1:{i:0;s:6:\"bottom\";}}s:4:\"type\";s:6:\"border\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}i:2;a:4:{s:2:\"id\";s:13:\"header-bottom\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:4:{i:0;a:3:{s:2:\"id\";s:8:\"column11\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:1;a:3:{s:2:\"id\";s:8:\"column12\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:2;a:3:{s:2:\"id\";s:8:\"column13\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile5\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}}s:6:\"params\";a:11:{s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";a:0:{}s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";a:5:{s:5:\"style\";s:5:\"solid\";s:8:\"applyFor\";s:9:\"fullwidth\";s:5:\"sides\";a:1:{i:0;s:6:\"bottom\";}s:5:\"width\";s:1:\"1\";s:5:\"color\";a:4:{s:1:\"r\";i:230;s:1:\"g\";i:230;s:1:\"b\";i:230;s:1:\"a\";i:1;}}s:4:\"type\";s:6:\"border\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}s:8:\"settings\";a:9:{s:7:\"overlap\";a:3:{s:2:\"id\";s:7:\"overlap\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:5:\"boxed\";a:3:{s:2:\"id\";s:5:\"boxed\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"full_width\";a:3:{s:2:\"id\";s:10:\"full_width\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:14:\"dropdowns_dark\";a:3:{s:2:\"id\";s:14:\"dropdowns_dark\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_shadow\";a:3:{s:2:\"id\";s:13:\"sticky_shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:14:\"hide_on_scroll\";a:3:{s:2:\"id\";s:14:\"hide_on_scroll\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_effect\";a:3:{s:2:\"id\";s:13:\"sticky_effect\";s:5:\"value\";s:5:\"stick\";s:4:\"type\";s:8:\"selector\";}s:12:\"sticky_clone\";a:3:{s:2:\"id\";s:12:\"sticky_clone\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:60;s:4:\"type\";s:6:\"slider\";}}}", "yes");
INSERT INTO `wp_options` VALUES("585", "xts-theme_settings_default-css-data", "@font-face {\n	font-weight: normal;\n	font-style: normal;\n	font-family: \"woodmart-font\";\n	src: url(\"//demo.iran-woodmart.ir/furniture2/wp-content/themes/woodmart/fonts/woodmart-font-2-400.woff2?v=8.2.6\") format(\"woff2\");\n}\n\n@font-face {\n	font-family: \"star\";\n	font-weight: 400;\n	font-style: normal;\n	src: url(\"//demo.iran-woodmart.ir/furniture2/wp-content/plugins/woocommerce/assets/fonts/star.eot?#iefix\") format(\"embedded-opentype\"), url(\"//demo.iran-woodmart.ir/furniture2/wp-content/plugins/woocommerce/assets/fonts/star.woff\") format(\"woff\"), url(\"//demo.iran-woodmart.ir/furniture2/wp-content/plugins/woocommerce/assets/fonts/star.ttf\") format(\"truetype\"), url(\"//demo.iran-woodmart.ir/furniture2/wp-content/plugins/woocommerce/assets/fonts/star.svg#star\") format(\"svg\");\n}\n\n@font-face {\n	font-family: \"WooCommerce\";\n	font-weight: 400;\n	font-style: normal;\n	src: url(\"//demo.iran-woodmart.ir/furniture2/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.eot?#iefix\") format(\"embedded-opentype\"), url(\"//demo.iran-woodmart.ir/furniture2/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.woff\") format(\"woff\"), url(\"//demo.iran-woodmart.ir/furniture2/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.ttf\") format(\"truetype\"), url(\"//demo.iran-woodmart.ir/furniture2/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.svg#WooCommerce\") format(\"svg\");\n}\n\n:root {\n	--wd-cat-brd-radius: 50%;\n	--wd-text-font: \"iranyekanx\", Arial, Helvetica, sans-serif;\n	--wd-text-font-weight: 400;\n	--wd-text-color: #777777;\n	--wd-text-font-size: 15px;\n	--wd-title-font: \"iranyekanx-b\", Arial, Helvetica, sans-serif;\n	--wd-title-font-weight: 900;\n	--wd-title-color: #242424;\n	--wd-entities-title-font: \"iranyekanx-b\", Arial, Helvetica, sans-serif;\n	--wd-entities-title-font-weight: 900;\n	--wd-entities-title-color: #333333;\n	--wd-entities-title-color-hover: rgb(51 51 51 / 65%);\n	--wd-alternative-font: \"iranyekanx\", Arial, Helvetica, sans-serif;\n	--wd-widget-title-font: \"iranyekanx-b\", Arial, Helvetica, sans-serif;\n	--wd-widget-title-font-weight: 900;\n	--wd-widget-title-transform: uppercase;\n	--wd-widget-title-color: #333;\n	--wd-widget-title-font-size: 16px;\n	--wd-header-el-font: \"iranyekanx-b\", Arial, Helvetica, sans-serif;\n	--wd-header-el-font-weight: 900;\n	--wd-header-el-transform: capitalize;\n	--wd-header-el-font-size: 14px;\n	--wd-brd-radius: 10px;\n	--wd-primary-color: rgb(245,154,87);\n	--wd-alternative-color: rgb(224,234,240);\n	--wd-link-color: #333333;\n	--wd-link-color-hover: #242424;\n	--btn-default-transform: none;\n	--btn-default-bgcolor: #f7f7f7;\n	--btn-default-bgcolor-hover: #efefef;\n	--btn-accented-transform: none;\n	--btn-accented-bgcolor: rgb(245,154,87);\n	--btn-accented-bgcolor-hover: rgb(223,140,79);\n	--btn-transform: none;\n	--wd-form-brd-width: 1px;\n	--notices-success-bg: #459647;\n	--notices-success-color: #fff;\n	--notices-warning-bg: #E0B252;\n	--notices-warning-color: #fff;\n}\n.wd-popup.wd-age-verify {\n	--wd-popup-width: 500px;\n}\n.wd-popup.wd-promo-popup {\n	background-color: rgb(245,154,87);\n	background-image: none;\n	background-repeat: no-repeat;\n	background-size: contain;\n	background-position: left center;\n	--wd-popup-width: 480px;\n}\n:is(.woodmart-archive-shop .wd-builder-off,.wd-wishlist-content,.related-and-upsells,.cart-collaterals,.wd-shop-product,.wd-fbt) .wd-products-with-bg, :is(.woodmart-archive-shop .wd-builder-off,.wd-wishlist-content,.related-and-upsells,.cart-collaterals,.wd-shop-product,.wd-fbt) .wd-products-with-bg :is(.wd-product,.wd-cat) {\n	--wd-prod-bg:rgb(255,255,255);\n	--wd-bordered-bg:rgb(255,255,255);\n}\n:is(.woodmart-woocommerce-layered-nav, .wd-product-category-filter) .wd-scroll-content {\n	max-height: 223px;\n}\n.wd-page-title {\n	background-color: rgb(174,182,161);\n	background-image: url(https://demo.iran-woodmart.ir/furniture2/wp-content/uploads/2023/04/wd-furniture-pt-def.jpg);\n	background-size: cover;\n	background-position: center top;\n}\n.wd-footer {\n	background-color: rgb(15,15,15);\n	background-image: none;\n}\nhtml .wd-nav-mobile > li > a {\n	font-family: \"iranyekanx\", Arial, Helvetica, sans-serif;\n	text-transform: capitalize;\n}\n.whb-top-bar .wd-nav.wd-nav-secondary > li > a {\n	font-family: \"iranyekanx\", Arial, Helvetica, sans-serif;\n	font-weight: 400;\n	font-size: 13px;\n}\nhtml .post.wd-post:not(.blog-design-small) .wd-entities-title {\n	font-family: \"iranyekanx\", Arial, Helvetica, sans-serif;\n	font-size: 18px;\n}\n.page .wd-page-content {\n	background-image: url(https://demo.iran-woodmart.ir/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg);\n	background-repeat: repeat;\n}\n.woodmart-archive-shop:not(.single-product) .wd-page-content {\n	background-image: url(https://demo.iran-woodmart.ir/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg);\n	background-repeat: repeat;\n}\n.single-product .wd-page-content {\n	background-image: url(https://demo.iran-woodmart.ir/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg);\n	background-repeat: repeat;\n}\n.woodmart-archive-blog .wd-page-content {\n	background-image: url(https://demo.iran-woodmart.ir/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg);\n	background-repeat: repeat;\n}\n.single-post .wd-page-content {\n	background-image: url(https://demo.iran-woodmart.ir/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg);\n	background-repeat: repeat;\n}\nhtml .wd-buy-now-btn {\n	color: rgb(255,255,255);\n	background: rgba(16,16,16,0.9);\n}\nhtml .wd-buy-now-btn:hover {\n	color: rgb(255,255,255);\n	background: rgb(51,51,51);\n}\nbody, [class*=color-scheme-light], [class*=color-scheme-dark], .wd-search-form[class*=\"wd-header-search-form\"] form.searchform, .wd-el-search .searchform {\n	--wd-form-color: rgb(119,119,119);\n	--wd-form-placeholder-color: rgb(119,119,119)7;\n	--wd-form-bg: rgb(255,255,255);\n}\n.wd-popup.popup-quick-view {\n	--wd-popup-width: 920px;\n}\n.woocommerce-product-gallery {\n	--wd-gallery-gap: 20px;\n}\n\n@media (max-width: 1024px) {\n	.woocommerce-product-gallery {\n		--wd-gallery-gap: 20px;\n	}\n\n}\n\n@media (max-width: 768.98px) {\n	.woocommerce-product-gallery {\n		--wd-gallery-gap: 10px;\n	}\n\n}\n:root{\n--wd-container-w: 1400px;\n--wd-form-brd-radius: 35px;\n--btn-default-color: #333;\n--btn-default-color-hover: #333;\n--btn-accented-color: #fff;\n--btn-accented-color-hover: #fff;\n--btn-default-brd-radius: 35px;\n--btn-default-box-shadow: none;\n--btn-default-box-shadow-hover: none;\n--btn-accented-brd-radius: 35px;\n--btn-accented-box-shadow: none;\n--btn-accented-box-shadow-hover: none;\n}\n\n@media (min-width: 1400px) {\nsection.elementor-section.wd-section-stretch > .elementor-container {\nmargin-left: auto;\nmargin-right: auto;\n}\n}\n\nrs-slides :is([data-type=text],[data-type=button]) {\nfont-family: iranyekanx !important;\n}\nrs-slides :is(h1,h2,h3,h4,h5,h6)[data-type=text] {\nfont-family: iranyekanx-b !important;\n}\n\n@font-face {\n	font-family: \"iranyekanx\";\n	src: url(\"//demo.iran-woodmart.ir/furniture2/wp-content/uploads/2023/09/IRANYekanXFaNum-Regular.woff2\") format(\"woff2\");\n	font-weight: 400;\n	font-style: normal;\n}\n\n@font-face {\n	font-family: \"iranyekanx-b\";\n	src: url(\"//demo.iran-woodmart.ir/furniture2/wp-content/uploads/2023/09/IRANYekanXFaNum-ExtraBold.woff2\") format(\"woff2\");\n	font-weight: 900;\n	font-style: normal;\n}\n\nspan.woocommerce-Price-currencySymbol {\r\n    margin-right: 3px;\r\n}", "on");
INSERT INTO `wp_options` VALUES("586", "xts-theme_settings_default-status", "valid", "on");
INSERT INTO `wp_options` VALUES("587", "xts-theme_settings_default-version", "8.2.6", "on");
INSERT INTO `wp_options` VALUES("588", "xts-theme_settings_default-site-url", "b8614d529e5b9d272cc48bd2fca884b4", "on");
INSERT INTO `wp_options` VALUES("589", "wd_import_current_version", "furniture2", "yes");
INSERT INTO `wp_options` VALUES("604", "recently_activated", "a:2:{s:23:\"wp-smushit/wp-smush.php\";i:1755517170;s:41:\"image-optimization/image-optimization.php\";i:1755517039;}", "off");
INSERT INTO `wp_options` VALUES("617", "duplicator_version_plugin", "1.5.13.1", "yes");
INSERT INTO `wp_options` VALUES("619", "duplicator_uninstall_package", "1", "yes");
INSERT INTO `wp_options` VALUES("620", "duplicator_uninstall_settings", "1", "yes");
INSERT INTO `wp_options` VALUES("623", "duplicator_notifications", "a:4:{s:6:\"update\";i:1755517337;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("655", "wd_page_css_files_theme_version", "8.2.6", "yes");
INSERT INTO `wp_options` VALUES("953", "new_admin_email", "info@iran-woodmart.ir", "yes");
INSERT INTO `wp_options` VALUES("954", "adminhash", "a:2:{s:4:\"hash\";s:32:\"9a3a6a1f8ecd380a2f0f48cf61701a2d\";s:8:\"newemail\";s:21:\"info@iran-woodmart.ir\";}", "off");
INSERT INTO `wp_options` VALUES("963", "woocommerce_task_list_tracked_completed_tasks", "a:3:{i:0;s:8:\"purchase\";i:1;s:8:\"products\";i:2;s:17:\"launch-your-store\";}", "yes");
INSERT INTO `wp_options` VALUES("966", "xts_backups_auto", "a:5:{i:1736075707;a:5:{s:5:\"title\";s:21:\"بکاپ خودکار\";s:4:\"date\";s:19:\"2025-01-05 11:15:07\";s:4:\"auto\";b:1;s:7:\"options\";a:648:{s:11:\"insta_token\";s:0:\"\";s:28:\"insta_delete_outdated_images\";s:1:\"0\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:6:\"before\";s:14:\"products_hover\";s:16:\"buttons-on-hover\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"0\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:1:\"1\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:16:\"rgb(255,255,255)\";}s:15:\"products_shadow\";s:1:\"0\";s:23:\"stretch_product_desktop\";s:1:\"1\";s:22:\"stretch_product_tablet\";s:1:\"1\";s:22:\"stretch_product_mobile\";s:1:\"1\";s:25:\"product_title_lines_limit\";s:4:\"none\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";s:1:\"1\";s:20:\"grid_gallery_control\";s:6:\"arrows\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:27:\"show_stock_quantity_on_grid\";s:1:\"0\";s:23:\"grid_stock_progress_bar\";s:1:\"0\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"1\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:18:\"show_reviews_count\";s:1:\"0\";s:17:\"categories_design\";s:8:\"zoom-out\";s:19:\"categories_rounding\";s:6:\"custom\";s:31:\"custom_categories_rounding_size\";s:68:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidW5pdCI6IiUiLCJ2YWx1ZSI6IjUwIn19fQ==\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"0\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:9:\"shop_view\";s:9:\"grid_list\";s:16:\"products_columns\";s:1:\"3\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:2:{i:0;s:1:\"3\";i:1;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"12\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:10:\"9,12,18,24\";s:15:\"shop_pagination\";s:10:\"pagination\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"223\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_content\";s:0:\"\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:14:\"default_header\";s:13:\"header_937146\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:157:\"<h4 class=\"text-center\">Are you over 18?</h4>\r\n<p class=\"text-center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:120:\"<h4 class=\"text-center\">Access forbidden</h4>\r\n<p class=\"text-center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"1\";s:24:\"promo_popup_content_type\";s:10:\"html_block\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:4:\"1388\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:15:\"rgb(245,154,87)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:5:\"light\";s:11:\"popup_width\";s:3:\"480\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:116:\"We use cookies to improve your experience on our website. By browsing this website, you agree to our use of cookies.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"0\";s:18:\"header_banner_link\";s:0:\"\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:0:\"\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"40\";s:27:\"header_banner_mobile_height\";s:2:\"40\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:13:\"search_by_sku\";s:1:\"1\";s:17:\"relevanssi_search\";s:1:\"0\";s:16:\"popular_requests\";s:0:\"\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:23:\"ajax_fullscreen_content\";s:1:\"1\";s:10:\"site_width\";s:6:\"custom\";s:17:\"site_custom_width\";s:4:\"1400\";s:11:\"main_layout\";s:13:\"sidebar-right\";s:13:\"sidebar_width\";s:1:\"3\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:17:\"page-title-design\";s:7:\"default\";s:15:\"page-title-size\";s:5:\"large\";s:16:\"title-background\";a:7:{s:5:\"color\";s:16:\"rgb(174,182,161)\";s:3:\"url\";s:91:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-pt-def.jpg\";s:2:\"id\";s:3:\"137\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:10:\"center top\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:10:\"html_block\";s:13:\"footer-layout\";s:2:\"13\";s:17:\"footer_html_block\";s:3:\"688\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:13:\"rgb(15,15,15)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:5:\"light\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"1\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"1\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:67:\"طراحی و توسعه توسط  تیم ایران وودمارت\";s:11:\"copyrights2\";s:114:\"<img src=\"https://iran-woodmart.ir/demo/furniture2/wp-content/themes/woodmart/images/payments.png\" alt=\"payments\">\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#777777\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:19:\"rgb(51 51 51 / 65%)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"16\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:4:\"#333\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:10:\"capitalize\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:5:{i:0;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:23:\"mobile_menu_first_level\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:10:\"capitalize\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}i:1;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:27:\"secondary_navigation_topbar\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"13\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}i:2;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"800\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}i:3;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:10:\"blog_title\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"18\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:3:{i:0;a:4:{s:9:\"font-name\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:97:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/09/IRANYekanXFaNum-Regular.woff2\";s:2:\"id\";s:4:\"1427\";}}i:1;a:4:{s:9:\"font-name\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:99:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/09/IRANYekanXFaNum-ExtraBold.woff2\";s:2:\"id\";s:4:\"1428\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"2\";s:6:\"weight\";s:3:\"400\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:6:\"custom\";s:20:\"custom_rounding_size\";s:68:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidW5pdCI6InB4IiwidmFsdWUiOiIxMCJ9fX0=\";s:12:\"dark_version\";s:1:\"0\";s:13:\"primary-color\";a:1:{s:4:\"idle\";s:15:\"rgb(245,154,87)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:16:\"rgb(224,234,240)\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:7:\"#242424\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:7:\"rounded\";s:23:\"btns_default_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:7:\"#f7f7f7\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:7:\"#efefef\";}s:25:\"btns_default_color_scheme\";s:4:\"dark\";s:31:\"btns_default_color_scheme_hover\";s:4:\"dark\";s:32:\"btns_default_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"btns_default_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"btns_shop_style\";s:7:\"rounded\";s:20:\"btns_shop_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:15:\"rgb(245,154,87)\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:15:\"rgb(223,140,79)\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:35:\"btns_shop_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"advanced_typography_button\";a:3:{i:0;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:11:\"all_buttons\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}i:1;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:14:\"single_buy_now\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:16:\"rgb(255,255,255)\";s:5:\"hover\";a:2:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:10:\"background\";s:13:\"rgb(51,51,51)\";}s:10:\"background\";s:18:\"rgba(16,16,16,0.9)\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:7:\"rounded\";s:17:\"form_border_width\";s:1:\"1\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:16:\"rgb(119,119,119)\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:17:\"rgb(119,119,119)7\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:16:\"rgb(255,255,255)\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:11:\"blog_design\";s:10:\"meta-image\";s:10:\"blog_style\";s:6:\"shadow\";s:16:\"blog_with_shadow\";s:1:\"0\";s:12:\"blog_columns\";s:1:\"4\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:15:\"blog_pagination\";s:10:\"pagination\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"100\";s:11:\"parts_title\";s:1:\"1\";s:10:\"parts_meta\";s:1:\"1\";s:10:\"parts_text\";s:1:\"1\";s:9:\"parts_btn\";s:1:\"1\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:1:\"0\";s:18:\"portoflio_per_page\";s:1:\"6\";s:20:\"portfolio_pagination\";s:9:\"load_more\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"0\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";s:1:\"0\";s:16:\"show_sku_in_cart\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"0\";s:16:\"show_sku_on_ajax\";s:1:\"0\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:1:\"0\";s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:8:\"pa_color\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"single_product_swatches_limit\";s:1:\"0\";s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"0\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"new\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:17:\"hide_larger_price\";s:1:\"0\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:10:\"rounded-sm\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:8:\"pa_brand\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:14:\"brand_tab_name\";s:1:\"0\";s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:2:\"23\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:12:\"availability\";}s:18:\"empty_compare_text\";s:150:\"No products added in the compare list. You must add some products to compare them.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:15:\"compare_on_grid\";s:1:\"1\";s:25:\"compare_save_button_state\";s:1:\"0\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:27:\"update_cart_quantity_change\";s:1:\"1\";s:15:\"empty_cart_text\";s:144:\"Before proceed to checkout you must add some products to your shopping cart.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:20:\"single_product_style\";s:1:\"2\";s:12:\"image_action\";s:5:\"popup\";s:15:\"photoswipe_icon\";s:1:\"0\";s:26:\"product_slider_auto_height\";s:1:\"0\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:13:\"bottom_column\";s:34:\"single_product_grid_column_desktop\";s:1:\"2\";s:33:\"single_product_grid_column_tablet\";s:1:\"2\";s:33:\"single_product_grid_column_mobile\";s:1:\"2\";s:31:\"single_product_grid_columns_gap\";s:164:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidW5pdCI6InB4IiwidmFsdWUiOiIyMCJ9LCJ0YWJsZXQiOnsidW5pdCI6InB4IiwidmFsdWUiOiIyMCJ9LCJtb2JpbGUiOnsidW5pdCI6InB4IiwidmFsdWUiOiIxMCJ9fX0=\";s:22:\"main_gallery_on_tablet\";s:1:\"0\";s:22:\"main_gallery_on_mobile\";s:1:\"0\";s:23:\"pagination_main_gallery\";s:1:\"0\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"0\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"0\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:7:\"default\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"0\";s:17:\"product_countdown\";s:1:\"0\";s:23:\"sale_countdown_variable\";s:1:\"0\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"4\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:20:\"additional_tab_title\";s:22:\"خرید و تحویل\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:8:\"Register\";s:8:\"reg_text\";s:258:\"Registering for this site allows you to access your order status and history. Just fill in the fields below, and we\'ll get a new account set up for you in no time. We will only ask you for information necessary to make the purchase process faster and easier.\";s:11:\"login_title\";s:5:\"Login\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:66:\"span.woocommerce-Price-currencySymbol {\r\n    margin-right: 3px;\r\n}\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:14:\"isntagram_link\";s:1:\"#\";s:14:\"pinterest_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:12:\"discord_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:8:\"share_ok\";s:1:\"0\";s:14:\"share_whatsapp\";s:1:\"0\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_tg\";s:1:\"0\";s:11:\"share_viber\";s:1:\"0\";s:11:\"share_email\";s:1:\"0\";s:19:\"mobile_optimization\";s:1:\"0\";s:16:\"load_text_domain\";s:1:\"1\";s:21:\"disable_gutenberg_css\";s:1:\"0\";s:29:\"disable_gutenberg_backend_css\";s:1:\"0\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"0\";s:21:\"remove_jquery_migrate\";s:1:\"0\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:16:\"flickity_library\";s:8:\"required\";s:21:\"flickity-fade_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:8:\"required\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:11:\"owl_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:13:\"slick_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"fade\";s:22:\"lazy_generate_previews\";s:1:\"1\";s:12:\"lazy_base_64\";s:1:\"1\";s:19:\"lazy_proprtion_size\";s:1:\"1\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";s:1:\"0\";s:26:\"rocket_delay_js_exclusions\";s:1:\"0\";s:6:\"cf7_js\";s:1:\"1\";s:28:\"load_elementor_optimized_css\";s:1:\"0\";s:20:\"elementor_animations\";s:1:\"1\";s:15:\"elementor_icons\";s:1:\"1\";s:24:\"elementor_dialog_library\";s:1:\"1\";s:18:\"elementor_frontend\";s:1:\"1\";s:14:\"swiper_library\";s:6:\"always\";s:20:\"el_waypoints_library\";s:6:\"always\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:7:\"not_use\";s:23:\"font_icon_woff2_preload\";s:1:\"0\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"0\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"1\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"1\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:16:\"maintenance_mode\";s:1:\"0\";s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";s:1:\"0\";s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"1\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:2:\"21\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:117:\"You don\'t have any products in the wishlist yet. <br> You will find a lot of interesting products on our \"Shop\" page.\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"0\";s:29:\"shipping_progress_bar_enabled\";s:1:\"1\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:4:\"1300\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"exclude\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"1\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:46:\"Add [remainder] to cart and get free shipping!\";s:37:\"shipping_progress_bar_message_success\";s:39:\"Your order qualifies for free shipping!\";s:15:\"buy_now_enabled\";s:1:\"1\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"0\";s:27:\"counter_visitor_data_source\";s:9:\"live_data\";s:38:\"counter_visitor_data_source_min_number\";s:2:\"10\";s:38:\"counter_visitor_data_source_max_number\";s:2:\"20\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:17:\"discounts_enabled\";s:1:\"0\";s:20:\"show_discounts_table\";s:1:\"0\";s:27:\"checkout_show_product_image\";s:1:\"1\";s:25:\"checkout_product_quantity\";s:1:\"1\";s:22:\"checkout_remove_button\";s:1:\"1\";s:24:\"checkout_link_to_product\";s:1:\"0\";s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"two-column\";s:15:\"reviews_columns\";s:1:\"2\";s:22:\"reviews_columns_tablet\";s:1:\"1\";s:22:\"reviews_columns_mobile\";s:1:\"1\";s:21:\"reviews_form_location\";s:6:\"before\";s:13:\"reviews_style\";s:7:\"style-2\";s:24:\"reviews_enable_pros_cons\";s:1:\"0\";s:20:\"reviews_enable_likes\";s:1:\"1\";s:32:\"show_reviews_purchased_indicator\";s:1:\"1\";s:15:\"reviews_sorting\";s:1:\"1\";s:29:\"single_product_comment_images\";s:1:\"0\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";s:1:\"0\";s:22:\"reviews_rating_summary\";s:1:\"1\";s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";s:1:\"1\";s:26:\"reviews_rating_by_criteria\";s:1:\"0\";s:32:\"reviews_criteria_rating_required\";s:1:\"0\";s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:0:\"\";s:23:\"sticky_navigation_title\";s:0:\"\";s:30:\"sticky_navigation_content_type\";s:4:\"text\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:0:\"\";s:33:\"single_product_main_gallery_video\";s:1:\"1\";s:17:\"linked_variations\";s:1:\"1\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";s:20:\"sold_counter_enabled\";s:1:\"0\";s:23:\"sold_counter_sales_type\";s:9:\"real_data\";s:24:\"sold_counter_shown_after\";s:1:\"0\";s:22:\"sold_counter_min_count\";s:2:\"10\";s:22:\"sold_counter_max_count\";s:2:\"20\";s:31:\"sold_counter_hide_on_outofstock\";s:1:\"0\";s:22:\"sold_counter_timeframe\";s:1:\"3\";s:29:\"sold_counter_timeframe_period\";s:7:\"minutes\";s:28:\"sold_counter_transient_hours\";s:2:\"24\";i:2;a:2:{s:16:\"pages-background\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:14:\"fields_to_save\";s:16:\"pages-background\";}}s:7:\"presets\";a:1:{i:2;a:4:{s:2:\"id\";i:2;s:4:\"name\";s:20:\"Checkout Furniture 2\";s:9:\"condition\";a:2:{s:8:\"relation\";s:2:\"OR\";s:5:\"rules\";a:1:{i:0;a:7:{s:4:\"type\";s:7:\"post_id\";s:10:\"comparison\";s:6:\"equals\";s:9:\"post_type\";s:4:\"post\";s:8:\"taxonomy\";s:8:\"category\";s:6:\"custom\";s:6:\"search\";s:8:\"value_id\";s:2:\"10\";s:9:\"user_role\";s:13:\"administrator\";}}}s:8:\"priority\";s:0:\"\";}}}i:1736873357;a:5:{s:5:\"title\";s:21:\"بکاپ خودکار\";s:4:\"date\";s:19:\"2025-01-14 16:49:17\";s:4:\"auto\";b:1;s:7:\"options\";a:648:{s:11:\"insta_token\";s:0:\"\";s:28:\"insta_delete_outdated_images\";s:1:\"0\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:6:\"before\";s:14:\"products_hover\";s:16:\"buttons-on-hover\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"0\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:1:\"1\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:16:\"rgb(255,255,255)\";}s:15:\"products_shadow\";s:1:\"0\";s:23:\"stretch_product_desktop\";s:1:\"1\";s:22:\"stretch_product_tablet\";s:1:\"1\";s:22:\"stretch_product_mobile\";s:1:\"1\";s:25:\"product_title_lines_limit\";s:4:\"none\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";s:1:\"1\";s:20:\"grid_gallery_control\";s:6:\"arrows\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:27:\"show_stock_quantity_on_grid\";s:1:\"0\";s:23:\"grid_stock_progress_bar\";s:1:\"0\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"1\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:18:\"show_reviews_count\";s:1:\"0\";s:17:\"categories_design\";s:8:\"zoom-out\";s:19:\"categories_rounding\";s:6:\"custom\";s:31:\"custom_categories_rounding_size\";s:68:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidW5pdCI6IiUiLCJ2YWx1ZSI6IjUwIn19fQ==\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"0\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:9:\"shop_view\";s:9:\"grid_list\";s:16:\"products_columns\";s:1:\"3\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:2:{i:0;s:1:\"3\";i:1;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"12\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:10:\"9,12,18,24\";s:15:\"shop_pagination\";s:10:\"pagination\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"223\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_content\";s:0:\"\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:14:\"default_header\";s:13:\"header_937146\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:157:\"<h4 class=\"text-center\">Are you over 18?</h4>\r\n<p class=\"text-center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:120:\"<h4 class=\"text-center\">Access forbidden</h4>\r\n<p class=\"text-center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"1\";s:24:\"promo_popup_content_type\";s:10:\"html_block\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:4:\"1388\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:15:\"rgb(245,154,87)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:5:\"light\";s:11:\"popup_width\";s:3:\"480\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:116:\"We use cookies to improve your experience on our website. By browsing this website, you agree to our use of cookies.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"0\";s:18:\"header_banner_link\";s:0:\"\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:0:\"\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"40\";s:27:\"header_banner_mobile_height\";s:2:\"40\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:13:\"search_by_sku\";s:1:\"1\";s:17:\"relevanssi_search\";s:1:\"0\";s:16:\"popular_requests\";s:0:\"\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:23:\"ajax_fullscreen_content\";s:1:\"1\";s:10:\"site_width\";s:6:\"custom\";s:17:\"site_custom_width\";s:4:\"1400\";s:11:\"main_layout\";s:13:\"sidebar-right\";s:13:\"sidebar_width\";s:1:\"3\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:17:\"page-title-design\";s:7:\"default\";s:15:\"page-title-size\";s:5:\"large\";s:16:\"title-background\";a:7:{s:5:\"color\";s:16:\"rgb(174,182,161)\";s:3:\"url\";s:91:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-pt-def.jpg\";s:2:\"id\";s:3:\"137\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:10:\"center top\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:10:\"html_block\";s:13:\"footer-layout\";s:2:\"13\";s:17:\"footer_html_block\";s:3:\"688\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:13:\"rgb(15,15,15)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:5:\"light\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"1\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"1\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:67:\"طراحی و توسعه توسط  تیم ایران وودمارت\";s:11:\"copyrights2\";s:114:\"<img src=\"https://iran-woodmart.ir/demo/furniture2/wp-content/themes/woodmart/images/payments.png\" alt=\"payments\">\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#777777\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:19:\"rgb(51 51 51 / 65%)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"16\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:4:\"#333\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:10:\"capitalize\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:5:{i:0;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:23:\"mobile_menu_first_level\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:10:\"capitalize\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}i:1;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:27:\"secondary_navigation_topbar\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"13\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}i:2;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"800\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}i:3;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:10:\"blog_title\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"18\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:3:{i:0;a:4:{s:9:\"font-name\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:97:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/09/IRANYekanXFaNum-Regular.woff2\";s:2:\"id\";s:4:\"1427\";}}i:1;a:4:{s:9:\"font-name\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:99:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/09/IRANYekanXFaNum-ExtraBold.woff2\";s:2:\"id\";s:4:\"1428\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"2\";s:6:\"weight\";s:3:\"400\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:6:\"custom\";s:20:\"custom_rounding_size\";s:68:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidW5pdCI6InB4IiwidmFsdWUiOiIxMCJ9fX0=\";s:12:\"dark_version\";s:1:\"0\";s:13:\"primary-color\";a:1:{s:4:\"idle\";s:15:\"rgb(245,154,87)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:16:\"rgb(224,234,240)\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:7:\"#242424\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:7:\"rounded\";s:23:\"btns_default_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:7:\"#f7f7f7\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:7:\"#efefef\";}s:25:\"btns_default_color_scheme\";s:4:\"dark\";s:31:\"btns_default_color_scheme_hover\";s:4:\"dark\";s:32:\"btns_default_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"btns_default_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"btns_shop_style\";s:7:\"rounded\";s:20:\"btns_shop_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:15:\"rgb(245,154,87)\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:15:\"rgb(223,140,79)\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:35:\"btns_shop_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"advanced_typography_button\";a:3:{i:0;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:11:\"all_buttons\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}i:1;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:14:\"single_buy_now\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:16:\"rgb(255,255,255)\";s:5:\"hover\";a:2:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:10:\"background\";s:13:\"rgb(51,51,51)\";}s:10:\"background\";s:18:\"rgba(16,16,16,0.9)\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:7:\"rounded\";s:17:\"form_border_width\";s:1:\"1\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:16:\"rgb(119,119,119)\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:17:\"rgb(119,119,119)7\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:16:\"rgb(255,255,255)\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:11:\"blog_design\";s:10:\"meta-image\";s:10:\"blog_style\";s:6:\"shadow\";s:16:\"blog_with_shadow\";s:1:\"0\";s:12:\"blog_columns\";s:1:\"4\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:15:\"blog_pagination\";s:10:\"pagination\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"100\";s:11:\"parts_title\";s:1:\"1\";s:10:\"parts_meta\";s:1:\"1\";s:10:\"parts_text\";s:1:\"1\";s:9:\"parts_btn\";s:1:\"1\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:1:\"0\";s:18:\"portoflio_per_page\";s:1:\"6\";s:20:\"portfolio_pagination\";s:9:\"load_more\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"0\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";s:1:\"0\";s:16:\"show_sku_in_cart\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"0\";s:16:\"show_sku_on_ajax\";s:1:\"0\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:1:\"0\";s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:8:\"pa_color\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"single_product_swatches_limit\";s:1:\"0\";s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"0\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"new\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:17:\"hide_larger_price\";s:1:\"0\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:10:\"rounded-sm\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:8:\"pa_brand\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:14:\"brand_tab_name\";s:1:\"0\";s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:2:\"23\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:12:\"availability\";}s:18:\"empty_compare_text\";s:150:\"No products added in the compare list. You must add some products to compare them.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:15:\"compare_on_grid\";s:1:\"1\";s:25:\"compare_save_button_state\";s:1:\"0\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:27:\"update_cart_quantity_change\";s:1:\"1\";s:15:\"empty_cart_text\";s:144:\"Before proceed to checkout you must add some products to your shopping cart.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:20:\"single_product_style\";s:1:\"2\";s:12:\"image_action\";s:5:\"popup\";s:15:\"photoswipe_icon\";s:1:\"0\";s:26:\"product_slider_auto_height\";s:1:\"0\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:13:\"bottom_column\";s:34:\"single_product_grid_column_desktop\";s:1:\"2\";s:33:\"single_product_grid_column_tablet\";s:1:\"2\";s:33:\"single_product_grid_column_mobile\";s:1:\"2\";s:31:\"single_product_grid_columns_gap\";s:164:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidW5pdCI6InB4IiwidmFsdWUiOiIyMCJ9LCJ0YWJsZXQiOnsidW5pdCI6InB4IiwidmFsdWUiOiIyMCJ9LCJtb2JpbGUiOnsidW5pdCI6InB4IiwidmFsdWUiOiIxMCJ9fX0=\";s:22:\"main_gallery_on_tablet\";s:1:\"0\";s:22:\"main_gallery_on_mobile\";s:1:\"0\";s:23:\"pagination_main_gallery\";s:1:\"0\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"0\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"0\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:7:\"default\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"0\";s:17:\"product_countdown\";s:1:\"0\";s:23:\"sale_countdown_variable\";s:1:\"0\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"4\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:20:\"additional_tab_title\";s:22:\"خرید و تحویل\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:8:\"Register\";s:8:\"reg_text\";s:258:\"Registering for this site allows you to access your order status and history. Just fill in the fields below, and we\'ll get a new account set up for you in no time. We will only ask you for information necessary to make the purchase process faster and easier.\";s:11:\"login_title\";s:5:\"Login\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:66:\"span.woocommerce-Price-currencySymbol {\r\n    margin-right: 3px;\r\n}\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:14:\"isntagram_link\";s:1:\"#\";s:14:\"pinterest_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:12:\"discord_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:8:\"share_ok\";s:1:\"0\";s:14:\"share_whatsapp\";s:1:\"0\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_tg\";s:1:\"0\";s:11:\"share_viber\";s:1:\"0\";s:11:\"share_email\";s:1:\"0\";s:19:\"mobile_optimization\";s:1:\"0\";s:16:\"load_text_domain\";s:1:\"1\";s:21:\"disable_gutenberg_css\";s:1:\"0\";s:29:\"disable_gutenberg_backend_css\";s:1:\"0\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"0\";s:21:\"remove_jquery_migrate\";s:1:\"0\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:16:\"flickity_library\";s:8:\"required\";s:21:\"flickity-fade_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:8:\"required\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:11:\"owl_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:13:\"slick_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"fade\";s:22:\"lazy_generate_previews\";s:1:\"1\";s:12:\"lazy_base_64\";s:1:\"1\";s:19:\"lazy_proprtion_size\";s:1:\"1\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";s:1:\"0\";s:26:\"rocket_delay_js_exclusions\";s:1:\"0\";s:6:\"cf7_js\";s:1:\"1\";s:28:\"load_elementor_optimized_css\";s:1:\"0\";s:20:\"elementor_animations\";s:1:\"1\";s:15:\"elementor_icons\";s:1:\"1\";s:24:\"elementor_dialog_library\";s:1:\"1\";s:18:\"elementor_frontend\";s:1:\"1\";s:14:\"swiper_library\";s:6:\"always\";s:20:\"el_waypoints_library\";s:6:\"always\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:7:\"not_use\";s:23:\"font_icon_woff2_preload\";s:1:\"0\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"0\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"1\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"1\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:16:\"maintenance_mode\";s:1:\"0\";s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";s:1:\"0\";s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"1\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:2:\"21\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:117:\"You don\'t have any products in the wishlist yet. <br> You will find a lot of interesting products on our \"Shop\" page.\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"0\";s:29:\"shipping_progress_bar_enabled\";s:1:\"1\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:4:\"1300\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"exclude\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"1\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:46:\"Add [remainder] to cart and get free shipping!\";s:37:\"shipping_progress_bar_message_success\";s:39:\"Your order qualifies for free shipping!\";s:15:\"buy_now_enabled\";s:1:\"1\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"0\";s:27:\"counter_visitor_data_source\";s:9:\"live_data\";s:38:\"counter_visitor_data_source_min_number\";s:2:\"10\";s:38:\"counter_visitor_data_source_max_number\";s:2:\"20\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:17:\"discounts_enabled\";s:1:\"0\";s:20:\"show_discounts_table\";s:1:\"0\";s:27:\"checkout_show_product_image\";s:1:\"1\";s:25:\"checkout_product_quantity\";s:1:\"1\";s:22:\"checkout_remove_button\";s:1:\"1\";s:24:\"checkout_link_to_product\";s:1:\"0\";s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"two-column\";s:15:\"reviews_columns\";s:1:\"2\";s:22:\"reviews_columns_tablet\";s:1:\"1\";s:22:\"reviews_columns_mobile\";s:1:\"1\";s:21:\"reviews_form_location\";s:6:\"before\";s:13:\"reviews_style\";s:7:\"style-2\";s:24:\"reviews_enable_pros_cons\";s:1:\"0\";s:20:\"reviews_enable_likes\";s:1:\"1\";s:32:\"show_reviews_purchased_indicator\";s:1:\"1\";s:15:\"reviews_sorting\";s:1:\"1\";s:29:\"single_product_comment_images\";s:1:\"0\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";s:1:\"0\";s:22:\"reviews_rating_summary\";s:1:\"1\";s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";s:1:\"1\";s:26:\"reviews_rating_by_criteria\";s:1:\"0\";s:32:\"reviews_criteria_rating_required\";s:1:\"0\";s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:0:\"\";s:23:\"sticky_navigation_title\";s:0:\"\";s:30:\"sticky_navigation_content_type\";s:4:\"text\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:0:\"\";s:33:\"single_product_main_gallery_video\";s:1:\"1\";s:17:\"linked_variations\";s:1:\"1\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";s:20:\"sold_counter_enabled\";s:1:\"0\";s:23:\"sold_counter_sales_type\";s:9:\"real_data\";s:24:\"sold_counter_shown_after\";s:1:\"0\";s:22:\"sold_counter_min_count\";s:2:\"10\";s:22:\"sold_counter_max_count\";s:2:\"20\";s:31:\"sold_counter_hide_on_outofstock\";s:1:\"0\";s:22:\"sold_counter_timeframe\";s:1:\"3\";s:29:\"sold_counter_timeframe_period\";s:7:\"minutes\";s:28:\"sold_counter_transient_hours\";s:2:\"24\";i:2;a:2:{s:16:\"pages-background\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:14:\"fields_to_save\";s:16:\"pages-background\";}}s:7:\"presets\";a:1:{i:2;a:4:{s:2:\"id\";i:2;s:4:\"name\";s:20:\"Checkout Furniture 2\";s:9:\"condition\";a:2:{s:8:\"relation\";s:2:\"OR\";s:5:\"rules\";a:1:{i:0;a:7:{s:4:\"type\";s:7:\"post_id\";s:10:\"comparison\";s:6:\"equals\";s:9:\"post_type\";s:4:\"post\";s:8:\"taxonomy\";s:8:\"category\";s:6:\"custom\";s:6:\"search\";s:8:\"value_id\";s:2:\"10\";s:9:\"user_role\";s:13:\"administrator\";}}}s:8:\"priority\";s:0:\"\";}}}i:1737462320;a:5:{s:5:\"title\";s:21:\"بکاپ خودکار\";s:4:\"date\";s:19:\"2025-01-21 12:25:20\";s:4:\"auto\";b:1;s:7:\"options\";a:648:{s:11:\"insta_token\";s:0:\"\";s:28:\"insta_delete_outdated_images\";s:1:\"0\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:6:\"before\";s:14:\"products_hover\";s:16:\"buttons-on-hover\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"0\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:1:\"1\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:16:\"rgb(255,255,255)\";}s:15:\"products_shadow\";s:1:\"0\";s:23:\"stretch_product_desktop\";s:1:\"1\";s:22:\"stretch_product_tablet\";s:1:\"1\";s:22:\"stretch_product_mobile\";s:1:\"1\";s:25:\"product_title_lines_limit\";s:4:\"none\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";s:1:\"1\";s:20:\"grid_gallery_control\";s:6:\"arrows\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:27:\"show_stock_quantity_on_grid\";s:1:\"0\";s:23:\"grid_stock_progress_bar\";s:1:\"0\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"1\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:18:\"show_reviews_count\";s:1:\"0\";s:17:\"categories_design\";s:8:\"zoom-out\";s:19:\"categories_rounding\";s:6:\"custom\";s:31:\"custom_categories_rounding_size\";s:68:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidW5pdCI6IiUiLCJ2YWx1ZSI6IjUwIn19fQ==\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"0\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:9:\"shop_view\";s:9:\"grid_list\";s:16:\"products_columns\";s:1:\"3\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:2:{i:0;s:1:\"3\";i:1;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"12\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:10:\"9,12,18,24\";s:15:\"shop_pagination\";s:10:\"pagination\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"223\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_content\";s:0:\"\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:14:\"default_header\";s:13:\"header_937146\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:157:\"<h4 class=\"text-center\">Are you over 18?</h4>\r\n<p class=\"text-center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:120:\"<h4 class=\"text-center\">Access forbidden</h4>\r\n<p class=\"text-center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"1\";s:24:\"promo_popup_content_type\";s:10:\"html_block\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:4:\"1388\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:15:\"rgb(245,154,87)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:5:\"light\";s:11:\"popup_width\";s:3:\"480\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:116:\"We use cookies to improve your experience on our website. By browsing this website, you agree to our use of cookies.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"0\";s:18:\"header_banner_link\";s:0:\"\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:0:\"\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"40\";s:27:\"header_banner_mobile_height\";s:2:\"40\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:13:\"search_by_sku\";s:1:\"1\";s:17:\"relevanssi_search\";s:1:\"0\";s:16:\"popular_requests\";s:0:\"\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:23:\"ajax_fullscreen_content\";s:1:\"1\";s:10:\"site_width\";s:6:\"custom\";s:17:\"site_custom_width\";s:4:\"1400\";s:11:\"main_layout\";s:13:\"sidebar-right\";s:13:\"sidebar_width\";s:1:\"3\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:17:\"page-title-design\";s:7:\"default\";s:15:\"page-title-size\";s:5:\"large\";s:16:\"title-background\";a:7:{s:5:\"color\";s:16:\"rgb(174,182,161)\";s:3:\"url\";s:91:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-pt-def.jpg\";s:2:\"id\";s:3:\"137\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:10:\"center top\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:10:\"html_block\";s:13:\"footer-layout\";s:2:\"13\";s:17:\"footer_html_block\";s:3:\"688\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:13:\"rgb(15,15,15)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:5:\"light\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"1\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"1\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:67:\"طراحی و توسعه توسط  تیم ایران وودمارت\";s:11:\"copyrights2\";s:114:\"<img src=\"https://iran-woodmart.ir/demo/furniture2/wp-content/themes/woodmart/images/payments.png\" alt=\"payments\">\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#777777\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:19:\"rgb(51 51 51 / 65%)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"16\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:4:\"#333\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:10:\"capitalize\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:5:{i:0;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:23:\"mobile_menu_first_level\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:10:\"capitalize\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}i:1;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:27:\"secondary_navigation_topbar\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"13\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}i:2;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"800\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}i:3;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:10:\"blog_title\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"18\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:3:{i:0;a:4:{s:9:\"font-name\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:97:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/09/IRANYekanXFaNum-Regular.woff2\";s:2:\"id\";s:4:\"1427\";}}i:1;a:4:{s:9:\"font-name\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:99:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/09/IRANYekanXFaNum-ExtraBold.woff2\";s:2:\"id\";s:4:\"1428\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"2\";s:6:\"weight\";s:3:\"400\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:6:\"custom\";s:20:\"custom_rounding_size\";s:68:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidW5pdCI6InB4IiwidmFsdWUiOiIxMCJ9fX0=\";s:12:\"dark_version\";s:1:\"0\";s:13:\"primary-color\";a:1:{s:4:\"idle\";s:15:\"rgb(245,154,87)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:16:\"rgb(224,234,240)\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:7:\"#242424\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:7:\"rounded\";s:23:\"btns_default_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:7:\"#f7f7f7\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:7:\"#efefef\";}s:25:\"btns_default_color_scheme\";s:4:\"dark\";s:31:\"btns_default_color_scheme_hover\";s:4:\"dark\";s:32:\"btns_default_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"btns_default_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"btns_shop_style\";s:7:\"rounded\";s:20:\"btns_shop_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:15:\"rgb(245,154,87)\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:15:\"rgb(223,140,79)\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:35:\"btns_shop_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"advanced_typography_button\";a:3:{i:0;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:11:\"all_buttons\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}i:1;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:14:\"single_buy_now\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:16:\"rgb(255,255,255)\";s:5:\"hover\";a:2:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:10:\"background\";s:13:\"rgb(51,51,51)\";}s:10:\"background\";s:18:\"rgba(16,16,16,0.9)\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:7:\"rounded\";s:17:\"form_border_width\";s:1:\"1\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:16:\"rgb(119,119,119)\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:17:\"rgb(119,119,119)7\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:16:\"rgb(255,255,255)\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:11:\"blog_design\";s:10:\"meta-image\";s:10:\"blog_style\";s:6:\"shadow\";s:16:\"blog_with_shadow\";s:1:\"0\";s:12:\"blog_columns\";s:1:\"4\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:15:\"blog_pagination\";s:10:\"pagination\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"100\";s:11:\"parts_title\";s:1:\"1\";s:10:\"parts_meta\";s:1:\"1\";s:10:\"parts_text\";s:1:\"1\";s:9:\"parts_btn\";s:1:\"1\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:1:\"0\";s:18:\"portoflio_per_page\";s:1:\"6\";s:20:\"portfolio_pagination\";s:9:\"load_more\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"0\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";s:1:\"0\";s:16:\"show_sku_in_cart\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"0\";s:16:\"show_sku_on_ajax\";s:1:\"0\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:1:\"0\";s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:8:\"pa_color\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"single_product_swatches_limit\";s:1:\"0\";s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"0\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"new\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:17:\"hide_larger_price\";s:1:\"0\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:10:\"rounded-sm\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:8:\"pa_brand\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:14:\"brand_tab_name\";s:1:\"0\";s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:2:\"23\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:12:\"availability\";}s:18:\"empty_compare_text\";s:150:\"No products added in the compare list. You must add some products to compare them.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:15:\"compare_on_grid\";s:1:\"1\";s:25:\"compare_save_button_state\";s:1:\"0\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:27:\"update_cart_quantity_change\";s:1:\"1\";s:15:\"empty_cart_text\";s:144:\"Before proceed to checkout you must add some products to your shopping cart.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:20:\"single_product_style\";s:1:\"2\";s:12:\"image_action\";s:5:\"popup\";s:15:\"photoswipe_icon\";s:1:\"0\";s:26:\"product_slider_auto_height\";s:1:\"0\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:13:\"bottom_column\";s:34:\"single_product_grid_column_desktop\";s:1:\"2\";s:33:\"single_product_grid_column_tablet\";s:1:\"2\";s:33:\"single_product_grid_column_mobile\";s:1:\"2\";s:31:\"single_product_grid_columns_gap\";s:164:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidW5pdCI6InB4IiwidmFsdWUiOiIyMCJ9LCJ0YWJsZXQiOnsidW5pdCI6InB4IiwidmFsdWUiOiIyMCJ9LCJtb2JpbGUiOnsidW5pdCI6InB4IiwidmFsdWUiOiIxMCJ9fX0=\";s:22:\"main_gallery_on_tablet\";s:1:\"0\";s:22:\"main_gallery_on_mobile\";s:1:\"0\";s:23:\"pagination_main_gallery\";s:1:\"0\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"0\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"0\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:7:\"default\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"0\";s:17:\"product_countdown\";s:1:\"0\";s:23:\"sale_countdown_variable\";s:1:\"0\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"4\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:20:\"additional_tab_title\";s:22:\"خرید و تحویل\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:8:\"Register\";s:8:\"reg_text\";s:258:\"Registering for this site allows you to access your order status and history. Just fill in the fields below, and we\'ll get a new account set up for you in no time. We will only ask you for information necessary to make the purchase process faster and easier.\";s:11:\"login_title\";s:5:\"Login\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:66:\"span.woocommerce-Price-currencySymbol {\r\n    margin-right: 3px;\r\n}\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:14:\"isntagram_link\";s:1:\"#\";s:14:\"pinterest_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:12:\"discord_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:8:\"share_ok\";s:1:\"0\";s:14:\"share_whatsapp\";s:1:\"0\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_tg\";s:1:\"0\";s:11:\"share_viber\";s:1:\"0\";s:11:\"share_email\";s:1:\"0\";s:19:\"mobile_optimization\";s:1:\"0\";s:16:\"load_text_domain\";s:1:\"1\";s:21:\"disable_gutenberg_css\";s:1:\"0\";s:29:\"disable_gutenberg_backend_css\";s:1:\"0\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"0\";s:21:\"remove_jquery_migrate\";s:1:\"0\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:16:\"flickity_library\";s:8:\"required\";s:21:\"flickity-fade_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:8:\"required\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:11:\"owl_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:13:\"slick_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"fade\";s:22:\"lazy_generate_previews\";s:1:\"1\";s:12:\"lazy_base_64\";s:1:\"1\";s:19:\"lazy_proprtion_size\";s:1:\"1\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";s:1:\"0\";s:26:\"rocket_delay_js_exclusions\";s:1:\"0\";s:6:\"cf7_js\";s:1:\"1\";s:28:\"load_elementor_optimized_css\";s:1:\"0\";s:20:\"elementor_animations\";s:1:\"1\";s:15:\"elementor_icons\";s:1:\"1\";s:24:\"elementor_dialog_library\";s:1:\"1\";s:18:\"elementor_frontend\";s:1:\"1\";s:14:\"swiper_library\";s:6:\"always\";s:20:\"el_waypoints_library\";s:6:\"always\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:7:\"not_use\";s:23:\"font_icon_woff2_preload\";s:1:\"0\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"0\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"1\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"1\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:16:\"maintenance_mode\";s:1:\"0\";s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";s:1:\"0\";s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"1\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:2:\"21\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:117:\"You don\'t have any products in the wishlist yet. <br> You will find a lot of interesting products on our \"Shop\" page.\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"0\";s:29:\"shipping_progress_bar_enabled\";s:1:\"1\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:4:\"1300\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"exclude\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"1\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:46:\"Add [remainder] to cart and get free shipping!\";s:37:\"shipping_progress_bar_message_success\";s:39:\"Your order qualifies for free shipping!\";s:15:\"buy_now_enabled\";s:1:\"1\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"0\";s:27:\"counter_visitor_data_source\";s:9:\"live_data\";s:38:\"counter_visitor_data_source_min_number\";s:2:\"10\";s:38:\"counter_visitor_data_source_max_number\";s:2:\"20\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:17:\"discounts_enabled\";s:1:\"0\";s:20:\"show_discounts_table\";s:1:\"0\";s:27:\"checkout_show_product_image\";s:1:\"1\";s:25:\"checkout_product_quantity\";s:1:\"1\";s:22:\"checkout_remove_button\";s:1:\"1\";s:24:\"checkout_link_to_product\";s:1:\"0\";s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"two-column\";s:15:\"reviews_columns\";s:1:\"2\";s:22:\"reviews_columns_tablet\";s:1:\"1\";s:22:\"reviews_columns_mobile\";s:1:\"1\";s:21:\"reviews_form_location\";s:6:\"before\";s:13:\"reviews_style\";s:7:\"style-2\";s:24:\"reviews_enable_pros_cons\";s:1:\"0\";s:20:\"reviews_enable_likes\";s:1:\"1\";s:32:\"show_reviews_purchased_indicator\";s:1:\"1\";s:15:\"reviews_sorting\";s:1:\"1\";s:29:\"single_product_comment_images\";s:1:\"0\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";s:1:\"0\";s:22:\"reviews_rating_summary\";s:1:\"1\";s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";s:1:\"1\";s:26:\"reviews_rating_by_criteria\";s:1:\"0\";s:32:\"reviews_criteria_rating_required\";s:1:\"0\";s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:0:\"\";s:23:\"sticky_navigation_title\";s:0:\"\";s:30:\"sticky_navigation_content_type\";s:4:\"text\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:0:\"\";s:33:\"single_product_main_gallery_video\";s:1:\"1\";s:17:\"linked_variations\";s:1:\"1\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";s:20:\"sold_counter_enabled\";s:1:\"0\";s:23:\"sold_counter_sales_type\";s:9:\"real_data\";s:24:\"sold_counter_shown_after\";s:1:\"0\";s:22:\"sold_counter_min_count\";s:2:\"10\";s:22:\"sold_counter_max_count\";s:2:\"20\";s:31:\"sold_counter_hide_on_outofstock\";s:1:\"0\";s:22:\"sold_counter_timeframe\";s:1:\"3\";s:29:\"sold_counter_timeframe_period\";s:7:\"minutes\";s:28:\"sold_counter_transient_hours\";s:2:\"24\";i:2;a:2:{s:16:\"pages-background\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:14:\"fields_to_save\";s:16:\"pages-background\";}}s:7:\"presets\";a:1:{i:2;a:4:{s:2:\"id\";i:2;s:4:\"name\";s:20:\"Checkout Furniture 2\";s:9:\"condition\";a:2:{s:8:\"relation\";s:2:\"OR\";s:5:\"rules\";a:1:{i:0;a:7:{s:4:\"type\";s:7:\"post_id\";s:10:\"comparison\";s:6:\"equals\";s:9:\"post_type\";s:4:\"post\";s:8:\"taxonomy\";s:8:\"category\";s:6:\"custom\";s:6:\"search\";s:8:\"value_id\";s:2:\"10\";s:9:\"user_role\";s:13:\"administrator\";}}}s:8:\"priority\";s:0:\"\";}}}i:1751362707;a:5:{s:5:\"title\";s:21:\"بکاپ خودکار\";s:4:\"date\";s:19:\"2025-07-01 09:38:27\";s:4:\"auto\";b:1;s:7:\"options\";a:648:{s:11:\"insta_token\";s:0:\"\";s:28:\"insta_delete_outdated_images\";s:1:\"0\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:6:\"before\";s:14:\"products_hover\";s:16:\"buttons-on-hover\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"0\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:1:\"1\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:16:\"rgb(255,255,255)\";}s:15:\"products_shadow\";s:1:\"0\";s:23:\"stretch_product_desktop\";s:1:\"1\";s:22:\"stretch_product_tablet\";s:1:\"1\";s:22:\"stretch_product_mobile\";s:1:\"1\";s:25:\"product_title_lines_limit\";s:4:\"none\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";s:1:\"1\";s:20:\"grid_gallery_control\";s:6:\"arrows\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:27:\"show_stock_quantity_on_grid\";s:1:\"0\";s:23:\"grid_stock_progress_bar\";s:1:\"0\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"1\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:18:\"show_reviews_count\";s:1:\"0\";s:17:\"categories_design\";s:8:\"zoom-out\";s:19:\"categories_rounding\";s:6:\"custom\";s:31:\"custom_categories_rounding_size\";s:68:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidW5pdCI6IiUiLCJ2YWx1ZSI6IjUwIn19fQ==\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"0\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:9:\"shop_view\";s:9:\"grid_list\";s:16:\"products_columns\";s:1:\"3\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:2:{i:0;s:1:\"3\";i:1;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"12\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:10:\"9,12,18,24\";s:15:\"shop_pagination\";s:10:\"pagination\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"223\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_content\";s:0:\"\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:14:\"default_header\";s:13:\"header_937146\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:157:\"<h4 class=\"text-center\">Are you over 18?</h4>\r\n<p class=\"text-center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:120:\"<h4 class=\"text-center\">Access forbidden</h4>\r\n<p class=\"text-center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"1\";s:24:\"promo_popup_content_type\";s:10:\"html_block\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:4:\"1388\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:15:\"rgb(245,154,87)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:5:\"light\";s:11:\"popup_width\";s:3:\"480\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:116:\"We use cookies to improve your experience on our website. By browsing this website, you agree to our use of cookies.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"0\";s:18:\"header_banner_link\";s:0:\"\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:0:\"\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"40\";s:27:\"header_banner_mobile_height\";s:2:\"40\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:13:\"search_by_sku\";s:1:\"1\";s:17:\"relevanssi_search\";s:1:\"0\";s:16:\"popular_requests\";s:0:\"\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:23:\"ajax_fullscreen_content\";s:1:\"1\";s:10:\"site_width\";s:6:\"custom\";s:17:\"site_custom_width\";s:4:\"1400\";s:11:\"main_layout\";s:13:\"sidebar-right\";s:13:\"sidebar_width\";s:1:\"3\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:17:\"page-title-design\";s:7:\"default\";s:15:\"page-title-size\";s:5:\"large\";s:16:\"title-background\";a:7:{s:5:\"color\";s:16:\"rgb(174,182,161)\";s:3:\"url\";s:91:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-pt-def.jpg\";s:2:\"id\";s:3:\"137\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:10:\"center top\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:10:\"html_block\";s:13:\"footer-layout\";s:2:\"13\";s:17:\"footer_html_block\";s:3:\"688\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:13:\"rgb(15,15,15)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:5:\"light\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"1\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"1\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:67:\"طراحی و توسعه توسط  تیم ایران وودمارت\";s:11:\"copyrights2\";s:114:\"<img src=\"https://iran-woodmart.ir/demo/furniture2/wp-content/themes/woodmart/images/payments.png\" alt=\"payments\">\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#777777\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:19:\"rgb(51 51 51 / 65%)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"16\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:4:\"#333\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:10:\"capitalize\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:5:{i:0;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:23:\"mobile_menu_first_level\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:10:\"capitalize\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}i:1;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:27:\"secondary_navigation_topbar\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"13\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}i:2;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"800\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}i:3;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:10:\"blog_title\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"18\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:3:{i:0;a:4:{s:9:\"font-name\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:97:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/09/IRANYekanXFaNum-Regular.woff2\";s:2:\"id\";s:4:\"1427\";}}i:1;a:4:{s:9:\"font-name\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:99:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/09/IRANYekanXFaNum-ExtraBold.woff2\";s:2:\"id\";s:4:\"1428\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"2\";s:6:\"weight\";s:3:\"400\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:6:\"custom\";s:20:\"custom_rounding_size\";s:68:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidW5pdCI6InB4IiwidmFsdWUiOiIxMCJ9fX0=\";s:12:\"dark_version\";s:1:\"0\";s:13:\"primary-color\";a:1:{s:4:\"idle\";s:15:\"rgb(245,154,87)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:16:\"rgb(224,234,240)\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:7:\"#242424\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:7:\"rounded\";s:23:\"btns_default_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:7:\"#f7f7f7\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:7:\"#efefef\";}s:25:\"btns_default_color_scheme\";s:4:\"dark\";s:31:\"btns_default_color_scheme_hover\";s:4:\"dark\";s:32:\"btns_default_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"btns_default_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"btns_shop_style\";s:7:\"rounded\";s:20:\"btns_shop_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:15:\"rgb(245,154,87)\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:15:\"rgb(223,140,79)\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:35:\"btns_shop_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"advanced_typography_button\";a:3:{i:0;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:11:\"all_buttons\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}i:1;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:14:\"single_buy_now\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:16:\"rgb(255,255,255)\";s:5:\"hover\";a:2:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:10:\"background\";s:13:\"rgb(51,51,51)\";}s:10:\"background\";s:18:\"rgba(16,16,16,0.9)\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:7:\"rounded\";s:17:\"form_border_width\";s:1:\"1\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:16:\"rgb(119,119,119)\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:17:\"rgb(119,119,119)7\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:16:\"rgb(255,255,255)\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:11:\"blog_design\";s:10:\"meta-image\";s:10:\"blog_style\";s:6:\"shadow\";s:16:\"blog_with_shadow\";s:1:\"0\";s:12:\"blog_columns\";s:1:\"4\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:15:\"blog_pagination\";s:10:\"pagination\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"100\";s:11:\"parts_title\";s:1:\"1\";s:10:\"parts_meta\";s:1:\"1\";s:10:\"parts_text\";s:1:\"1\";s:9:\"parts_btn\";s:1:\"1\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:1:\"0\";s:18:\"portoflio_per_page\";s:1:\"6\";s:20:\"portfolio_pagination\";s:9:\"load_more\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"0\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";s:1:\"0\";s:16:\"show_sku_in_cart\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"0\";s:16:\"show_sku_on_ajax\";s:1:\"0\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:1:\"0\";s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:8:\"pa_color\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"single_product_swatches_limit\";s:1:\"0\";s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"0\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"new\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:17:\"hide_larger_price\";s:1:\"0\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:10:\"rounded-sm\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:8:\"pa_brand\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:14:\"brand_tab_name\";s:1:\"0\";s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:2:\"23\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:12:\"availability\";}s:18:\"empty_compare_text\";s:150:\"No products added in the compare list. You must add some products to compare them.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:15:\"compare_on_grid\";s:1:\"1\";s:25:\"compare_save_button_state\";s:1:\"0\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:27:\"update_cart_quantity_change\";s:1:\"1\";s:15:\"empty_cart_text\";s:144:\"Before proceed to checkout you must add some products to your shopping cart.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:20:\"single_product_style\";s:1:\"2\";s:12:\"image_action\";s:5:\"popup\";s:15:\"photoswipe_icon\";s:1:\"0\";s:26:\"product_slider_auto_height\";s:1:\"0\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:13:\"bottom_column\";s:34:\"single_product_grid_column_desktop\";s:1:\"2\";s:33:\"single_product_grid_column_tablet\";s:1:\"2\";s:33:\"single_product_grid_column_mobile\";s:1:\"2\";s:31:\"single_product_grid_columns_gap\";s:164:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidW5pdCI6InB4IiwidmFsdWUiOiIyMCJ9LCJ0YWJsZXQiOnsidW5pdCI6InB4IiwidmFsdWUiOiIyMCJ9LCJtb2JpbGUiOnsidW5pdCI6InB4IiwidmFsdWUiOiIxMCJ9fX0=\";s:22:\"main_gallery_on_tablet\";s:1:\"0\";s:22:\"main_gallery_on_mobile\";s:1:\"0\";s:23:\"pagination_main_gallery\";s:1:\"0\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"0\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"0\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:7:\"default\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"0\";s:17:\"product_countdown\";s:1:\"0\";s:23:\"sale_countdown_variable\";s:1:\"0\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"4\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:20:\"additional_tab_title\";s:22:\"خرید و تحویل\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:8:\"Register\";s:8:\"reg_text\";s:258:\"Registering for this site allows you to access your order status and history. Just fill in the fields below, and we\'ll get a new account set up for you in no time. We will only ask you for information necessary to make the purchase process faster and easier.\";s:11:\"login_title\";s:5:\"Login\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:66:\"span.woocommerce-Price-currencySymbol {\r\n    margin-right: 3px;\r\n}\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:14:\"isntagram_link\";s:1:\"#\";s:14:\"pinterest_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:12:\"discord_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:8:\"share_ok\";s:1:\"0\";s:14:\"share_whatsapp\";s:1:\"0\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_tg\";s:1:\"0\";s:11:\"share_viber\";s:1:\"0\";s:11:\"share_email\";s:1:\"0\";s:19:\"mobile_optimization\";s:1:\"0\";s:16:\"load_text_domain\";s:1:\"1\";s:21:\"disable_gutenberg_css\";s:1:\"0\";s:29:\"disable_gutenberg_backend_css\";s:1:\"0\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"0\";s:21:\"remove_jquery_migrate\";s:1:\"0\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:16:\"flickity_library\";s:8:\"required\";s:21:\"flickity-fade_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:8:\"required\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:11:\"owl_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:13:\"slick_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"fade\";s:22:\"lazy_generate_previews\";s:1:\"1\";s:12:\"lazy_base_64\";s:1:\"1\";s:19:\"lazy_proprtion_size\";s:1:\"1\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";s:1:\"0\";s:26:\"rocket_delay_js_exclusions\";s:1:\"0\";s:6:\"cf7_js\";s:1:\"1\";s:28:\"load_elementor_optimized_css\";s:1:\"0\";s:20:\"elementor_animations\";s:1:\"1\";s:15:\"elementor_icons\";s:1:\"1\";s:24:\"elementor_dialog_library\";s:1:\"1\";s:18:\"elementor_frontend\";s:1:\"1\";s:14:\"swiper_library\";s:6:\"always\";s:20:\"el_waypoints_library\";s:6:\"always\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:7:\"not_use\";s:23:\"font_icon_woff2_preload\";s:1:\"0\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"0\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"1\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"1\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:16:\"maintenance_mode\";s:1:\"0\";s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";s:1:\"0\";s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"1\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:2:\"21\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:117:\"You don\'t have any products in the wishlist yet. <br> You will find a lot of interesting products on our \"Shop\" page.\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"0\";s:29:\"shipping_progress_bar_enabled\";s:1:\"1\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:4:\"1300\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"exclude\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"1\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:46:\"Add [remainder] to cart and get free shipping!\";s:37:\"shipping_progress_bar_message_success\";s:39:\"Your order qualifies for free shipping!\";s:15:\"buy_now_enabled\";s:1:\"1\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"0\";s:27:\"counter_visitor_data_source\";s:9:\"live_data\";s:38:\"counter_visitor_data_source_min_number\";s:2:\"10\";s:38:\"counter_visitor_data_source_max_number\";s:2:\"20\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:17:\"discounts_enabled\";s:1:\"0\";s:20:\"show_discounts_table\";s:1:\"0\";s:27:\"checkout_show_product_image\";s:1:\"1\";s:25:\"checkout_product_quantity\";s:1:\"1\";s:22:\"checkout_remove_button\";s:1:\"1\";s:24:\"checkout_link_to_product\";s:1:\"0\";s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"two-column\";s:15:\"reviews_columns\";s:1:\"2\";s:22:\"reviews_columns_tablet\";s:1:\"1\";s:22:\"reviews_columns_mobile\";s:1:\"1\";s:21:\"reviews_form_location\";s:6:\"before\";s:13:\"reviews_style\";s:7:\"style-2\";s:24:\"reviews_enable_pros_cons\";s:1:\"0\";s:20:\"reviews_enable_likes\";s:1:\"1\";s:32:\"show_reviews_purchased_indicator\";s:1:\"1\";s:15:\"reviews_sorting\";s:1:\"1\";s:29:\"single_product_comment_images\";s:1:\"0\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";s:1:\"0\";s:22:\"reviews_rating_summary\";s:1:\"1\";s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";s:1:\"1\";s:26:\"reviews_rating_by_criteria\";s:1:\"0\";s:32:\"reviews_criteria_rating_required\";s:1:\"0\";s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:0:\"\";s:23:\"sticky_navigation_title\";s:0:\"\";s:30:\"sticky_navigation_content_type\";s:4:\"text\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:0:\"\";s:33:\"single_product_main_gallery_video\";s:1:\"1\";s:17:\"linked_variations\";s:1:\"1\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";s:20:\"sold_counter_enabled\";s:1:\"0\";s:23:\"sold_counter_sales_type\";s:9:\"real_data\";s:24:\"sold_counter_shown_after\";s:1:\"0\";s:22:\"sold_counter_min_count\";s:2:\"10\";s:22:\"sold_counter_max_count\";s:2:\"20\";s:31:\"sold_counter_hide_on_outofstock\";s:1:\"0\";s:22:\"sold_counter_timeframe\";s:1:\"3\";s:29:\"sold_counter_timeframe_period\";s:7:\"minutes\";s:28:\"sold_counter_transient_hours\";s:2:\"24\";i:2;a:2:{s:16:\"pages-background\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:14:\"fields_to_save\";s:16:\"pages-background\";}}s:7:\"presets\";a:1:{i:2;a:4:{s:2:\"id\";i:2;s:4:\"name\";s:20:\"Checkout Furniture 2\";s:9:\"condition\";a:2:{s:8:\"relation\";s:2:\"OR\";s:5:\"rules\";a:1:{i:0;a:7:{s:4:\"type\";s:7:\"post_id\";s:10:\"comparison\";s:6:\"equals\";s:9:\"post_type\";s:4:\"post\";s:8:\"taxonomy\";s:8:\"category\";s:6:\"custom\";s:6:\"search\";s:8:\"value_id\";s:2:\"10\";s:9:\"user_role\";s:13:\"administrator\";}}}s:8:\"priority\";s:0:\"\";}}}i:1752759453;a:5:{s:5:\"title\";s:21:\"بکاپ خودکار\";s:4:\"date\";s:19:\"2025-07-17 13:37:33\";s:4:\"auto\";b:1;s:7:\"options\";a:798:{s:14:\"default_header\";s:13:\"header_937146\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:157:\"<h4 class=\"text-center\">Are you over 18?</h4>\r\n<p class=\"text-center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:120:\"<h4 class=\"text-center\">Access forbidden</h4>\r\n<p class=\"text-center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"1\";s:24:\"promo_popup_content_type\";s:10:\"html_block\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:4:\"1388\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:15:\"rgb(245,154,87)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:5:\"light\";s:11:\"popup_width\";s:3:\"480\";s:13:\"popup_padding\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:116:\"We use cookies to improve your experience on our website. By browsing this website, you agree to our use of cookies.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"0\";s:18:\"header_banner_link\";s:0:\"\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:0:\"\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"40\";s:27:\"header_banner_mobile_height\";s:2:\"40\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:13:\"search_by_sku\";s:1:\"1\";s:17:\"relevanssi_search\";s:1:\"0\";s:16:\"popular_requests\";s:0:\"\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:23:\"ajax_fullscreen_content\";s:1:\"1\";s:10:\"site_width\";s:6:\"custom\";s:17:\"site_custom_width\";s:4:\"1400\";s:11:\"main_layout\";s:13:\"sidebar-right\";s:13:\"sidebar_width\";s:1:\"3\";s:17:\"hide_main_sidebar\";s:1:\"0\";s:24:\"hide_main_sidebar_tablet\";s:1:\"1\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:11:\"insta_token\";s:0:\"\";s:28:\"insta_delete_outdated_images\";s:1:\"0\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:5:\"after\";s:14:\"products_hover\";s:16:\"buttons-on-hover\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"0\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:1:\"1\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:16:\"rgb(255,255,255)\";}s:15:\"products_shadow\";s:1:\"0\";s:23:\"stretch_product_desktop\";s:1:\"1\";s:22:\"stretch_product_tablet\";s:1:\"1\";s:22:\"stretch_product_mobile\";s:1:\"1\";s:25:\"product_title_lines_limit\";s:4:\"none\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";s:1:\"1\";s:20:\"grid_gallery_control\";s:6:\"arrows\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:27:\"show_stock_quantity_on_grid\";s:1:\"0\";s:23:\"grid_stock_progress_bar\";s:1:\"0\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"1\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:18:\"show_reviews_count\";s:1:\"0\";s:17:\"categories_design\";s:8:\"zoom-out\";s:19:\"categories_rounding\";s:6:\"custom\";s:31:\"custom_categories_rounding_size\";s:68:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidW5pdCI6IiUiLCJ2YWx1ZSI6IjUwIn19fQ==\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_subcategories\";s:1:\"0\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"0\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:24:\"mobile_categories_layout\";s:9:\"accordion\";s:29:\"mobile_categories_menu_layout\";s:8:\"dropdown\";s:37:\"mobile_categories_drilldown_animation\";s:5:\"slide\";s:40:\"mobile_categories_submenu_opening_action\";s:10:\"only_arrow\";s:26:\"mobile_categories_position\";s:4:\"left\";s:30:\"mobile_categories_color_scheme\";s:7:\"default\";s:27:\"mobile_categories_close_btn\";s:1:\"0\";s:9:\"shop_view\";s:9:\"grid_list\";s:16:\"products_columns\";s:1:\"3\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:23:\"products_spacing_tablet\";s:0:\"\";s:23:\"products_spacing_mobile\";s:0:\"\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:2:{i:0;s:1:\"3\";i:1;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"12\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:10:\"9,12,18,24\";s:15:\"shop_pagination\";s:10:\"pagination\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"223\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_columns\";s:0:\"\";s:27:\"shop_filters_columns_tablet\";s:4:\"auto\";s:27:\"shop_filters_columns_mobile\";s:4:\"auto\";s:20:\"shop_filters_spacing\";s:2:\"30\";s:27:\"shop_filters_spacing_tablet\";s:0:\"\";s:27:\"shop_filters_spacing_mobile\";s:0:\"\";s:12:\"hide_sort_by\";s:1:\"0\";s:17:\"hide_price_filter\";s:1:\"0\";s:20:\"shop_filters_content\";s:0:\"\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:17:\"page-title-design\";s:7:\"default\";s:15:\"page-title-size\";s:5:\"large\";s:16:\"title-background\";a:7:{s:5:\"color\";s:16:\"rgb(174,182,161)\";s:3:\"url\";s:91:\"https://demo.iran-woodmart.ir/furniture2/wp-content/uploads/2023/04/wd-furniture-pt-def.jpg\";s:2:\"id\";s:3:\"137\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:10:\"center top\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:10:\"html_block\";s:13:\"footer-layout\";s:2:\"13\";s:17:\"footer_html_block\";s:3:\"688\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:13:\"rgb(15,15,15)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:5:\"light\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"1\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"1\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:67:\"طراحی و توسعه توسط  تیم ایران وودمارت\";s:11:\"copyrights2\";s:114:\"<img src=\"https://iran-woodmart.ir/demo/furniture2/wp-content/themes/woodmart/images/payments.png\" alt=\"payments\">\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#777777\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:19:\"rgb(51 51 51 / 65%)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"16\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:4:\"#333\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:10:\"capitalize\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:5:{i:0;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:23:\"mobile_menu_first_level\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:10:\"capitalize\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}i:1;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:27:\"secondary_navigation_topbar\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"13\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}i:2;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"800\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}i:3;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:10:\"blog_title\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"18\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:3:{i:0;a:4:{s:9:\"font-name\";s:10:\"iranyekanx\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:97:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/09/IRANYekanXFaNum-Regular.woff2\";s:2:\"id\";s:4:\"1427\";}}i:1;a:4:{s:9:\"font-name\";s:12:\"iranyekanx-b\";s:11:\"font-weight\";s:3:\"900\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:99:\"https://iran-woodmart.ir/demo/furniture2/wp-content/uploads/2023/09/IRANYekanXFaNum-ExtraBold.woff2\";s:2:\"id\";s:4:\"1428\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"2\";s:6:\"weight\";s:3:\"400\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:6:\"custom\";s:20:\"custom_rounding_size\";s:68:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidW5pdCI6InB4IiwidmFsdWUiOiIxMCJ9fX0=\";s:12:\"dark_version\";s:1:\"0\";s:13:\"primary-color\";a:1:{s:4:\"idle\";s:15:\"rgb(245,154,87)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:16:\"rgb(224,234,240)\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:7:\"#242424\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://demo.iran-woodmart.ir/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://demo.iran-woodmart.ir/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://demo.iran-woodmart.ir/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://demo.iran-woodmart.ir/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:95:\"https://demo.iran-woodmart.ir/furniture2/wp-content/uploads/2023/04/wd-furniture-background.jpg\";s:2:\"id\";s:3:\"138\";s:6:\"repeat\";s:6:\"repeat\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:7:\"rounded\";s:23:\"btns_default_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:7:\"#f7f7f7\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:7:\"#efefef\";}s:25:\"btns_default_color_scheme\";s:4:\"dark\";s:31:\"btns_default_color_scheme_hover\";s:4:\"dark\";s:32:\"btns_default_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"btns_default_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"btns_shop_style\";s:7:\"rounded\";s:20:\"btns_shop_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:15:\"rgb(245,154,87)\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:15:\"rgb(223,140,79)\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:35:\"btns_shop_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"advanced_typography_button\";a:3:{i:0;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:11:\"all_buttons\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}i:1;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:14:\"single_buy_now\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:16:\"rgb(255,255,255)\";s:5:\"hover\";a:2:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:10:\"background\";s:13:\"rgb(51,51,51)\";}s:10:\"background\";s:18:\"rgba(16,16,16,0.9)\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:7:\"rounded\";s:17:\"form_border_width\";s:1:\"1\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:16:\"rgb(119,119,119)\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:17:\"rgb(119,119,119)7\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:16:\"rgb(255,255,255)\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:24:\"carousel_arrows_position\";s:3:\"sep\";s:25:\"carousel_arrows_icon_type\";s:1:\"1\";s:27:\"carousel_arrows_hover_style\";s:1:\"1\";s:24:\"carousel_arrows_sep_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:29:\"carousel_arrows_sep_icon_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:28:\"carousel_arrows_sep_offset_h\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:28:\"carousel_arrows_sep_offset_v\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:25:\"carousel_arrows_sep_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:31:\"carousel_arrows_sep_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:29:\"carousel_arrows_sep_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:28:\"carousel_arrows_sep_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_arrows_sep_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:32:\"carousel_arrows_sep_bg_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_arrows_sep_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:32:\"carousel_arrows_sep_border_style\";s:0:\"\";s:32:\"carousel_arrows_sep_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:32:\"carousel_arrows_sep_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_arrows_sep_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_sep_border_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_sep_box_shadow_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:39:\"carousel_arrows_sep_box_shadow_offset_x\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:39:\"carousel_arrows_sep_box_shadow_offset_y\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:35:\"carousel_arrows_sep_box_shadow_blur\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_sep_box_shadow_spread\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:28:\"carousel_arrows_together_gap\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:29:\"carousel_arrows_together_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:34:\"carousel_arrows_together_icon_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:33:\"carousel_arrows_together_offset_h\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:33:\"carousel_arrows_together_offset_v\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:30:\"carousel_arrows_together_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_together_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_arrows_together_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_arrows_together_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:39:\"carousel_arrows_together_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:37:\"carousel_arrows_together_bg_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_arrows_together_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_together_border_style\";s:0:\"\";s:37:\"carousel_arrows_together_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_together_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:43:\"carousel_arrows_together_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:41:\"carousel_arrows_together_border_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:41:\"carousel_arrows_together_box_shadow_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:44:\"carousel_arrows_together_box_shadow_offset_x\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:44:\"carousel_arrows_together_box_shadow_offset_y\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:40:\"carousel_arrows_together_box_shadow_blur\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:42:\"carousel_arrows_together_box_shadow_spread\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:19:\"carousel_pagin_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:23:\"carousel_pagin_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:29:\"carousel_pagin_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:30:\"carousel_pagin_bg_color_active\";a:1:{s:4:\"idle\";s:0:\"\";}s:28:\"carousel_pagin_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"carousel_pagin_border_style\";s:0:\"\";s:27:\"carousel_pagin_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"carousel_pagin_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_pagin_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_pagin_border_color_active\";a:1:{s:4:\"idle\";s:0:\"\";}s:25:\"carousel_scrollbar_height\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:24:\"carousel_scrollbar_width\";s:152:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9LCJ0YWJsZXQiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9LCJtb2JpbGUiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9fX0=\";s:27:\"carousel_scrollbar_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:32:\"carousel_scrollbar_drag_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_scrollbar_drag_bg_hover_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:17:\"blog_hide_sidebar\";s:1:\"0\";s:24:\"blog_hide_sidebar_tablet\";s:1:\"1\";s:24:\"blog_hide_sidebar_mobile\";s:1:\"1\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:11:\"blog_design\";s:10:\"meta-image\";s:10:\"blog_style\";s:6:\"shadow\";s:16:\"blog_with_shadow\";s:1:\"0\";s:12:\"blog_columns\";s:1:\"4\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:19:\"blog_spacing_tablet\";s:0:\"\";s:19:\"blog_spacing_mobile\";s:0:\"\";s:15:\"blog_pagination\";s:10:\"pagination\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"100\";s:11:\"parts_title\";s:1:\"1\";s:10:\"parts_meta\";s:1:\"1\";s:10:\"parts_text\";s:1:\"1\";s:9:\"parts_btn\";s:1:\"1\";s:20:\"parts_published_date\";s:1:\"1\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:19:\"blog_published_date\";s:1:\"1\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:1:\"0\";s:24:\"portfolio_spacing_tablet\";s:0:\"\";s:24:\"portfolio_spacing_mobile\";s:0:\"\";s:18:\"portoflio_per_page\";s:1:\"6\";s:20:\"portfolio_pagination\";s:9:\"load_more\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"0\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";s:1:\"0\";s:16:\"show_sku_in_cart\";s:1:\"0\";s:25:\"show_sku_in_checkout_page\";s:1:\"0\";s:26:\"show_sku_in_thank_you_page\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"0\";s:16:\"show_sku_on_ajax\";s:1:\"0\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:1:\"0\";s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:8:\"pa_color\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"single_product_swatches_limit\";s:1:\"0\";s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"0\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"new\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:29:\"show_filtered_variation_image\";s:1:\"0\";s:17:\"hide_larger_price\";s:1:\"0\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:10:\"rounded-sm\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:8:\"pa_brand\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:14:\"brand_tab_name\";s:1:\"0\";s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:2:\"23\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:12:\"availability\";}s:18:\"empty_compare_text\";s:150:\"No products added in the compare list. You must add some products to compare them.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:15:\"compare_on_grid\";s:1:\"1\";s:25:\"compare_save_button_state\";s:1:\"0\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:18:\"cart_totals_layout\";s:8:\"layout-1\";s:27:\"update_cart_quantity_change\";s:1:\"1\";s:15:\"empty_cart_text\";s:144:\"Before proceed to checkout you must add some products to your shopping cart.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:27:\"single_product_hide_sidebar\";s:1:\"0\";s:34:\"single_product_hide_sidebar_tablet\";s:1:\"1\";s:34:\"single_product_hide_sidebar_mobile\";s:1:\"1\";s:20:\"single_product_style\";s:1:\"2\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:12:\"image_action\";s:5:\"popup\";s:15:\"photoswipe_icon\";s:1:\"0\";s:26:\"product_slider_auto_height\";s:1:\"0\";s:23:\"pagination_main_gallery\";s:1:\"0\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:13:\"bottom_column\";s:31:\"single_product_grid_columns_gap\";s:164:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidW5pdCI6InB4IiwidmFsdWUiOiIyMCJ9LCJ0YWJsZXQiOnsidW5pdCI6InB4IiwidmFsdWUiOiIyMCJ9LCJtb2JpbGUiOnsidW5pdCI6InB4IiwidmFsdWUiOiIxMCJ9fX0=\";s:34:\"single_product_grid_column_desktop\";s:1:\"2\";s:33:\"single_product_grid_column_tablet\";s:1:\"2\";s:33:\"single_product_grid_column_mobile\";s:1:\"2\";s:37:\"single_product_gallery_column_desktop\";s:1:\"1\";s:36:\"single_product_gallery_column_tablet\";s:0:\"\";s:36:\"single_product_gallery_column_mobile\";s:0:\"\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:22:\"main_gallery_on_tablet\";s:1:\"0\";s:22:\"main_gallery_on_mobile\";s:1:\"0\";s:24:\"main_gallery_center_mode\";s:1:\"0\";s:48:\"single_product_thumbnails_wrap_in_mobile_devices\";s:1:\"1\";s:39:\"single_product_thumbnails_gallery_width\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:40:\"single_product_thumbnails_gallery_height\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"0\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"0\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:7:\"default\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"0\";s:17:\"product_countdown\";s:1:\"0\";s:23:\"sale_countdown_variable\";s:1:\"0\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:18:\"show_product_brand\";s:1:\"0\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"4\";s:30:\"related_product_columns_tablet\";s:4:\"auto\";s:30:\"related_product_columns_mobile\";s:4:\"auto\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:20:\"additional_tab_title\";s:22:\"خرید و تحویل\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:8:\"Register\";s:8:\"reg_text\";s:258:\"Registering for this site allows you to access your order status and history. Just fill in the fields below, and we\'ll get a new account set up for you in no time. We will only ask you for information necessary to make the purchase process faster and easier.\";s:11:\"login_title\";s:5:\"Login\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:66:\"span.woocommerce-Price-currencySymbol {\r\n    margin-right: 3px;\r\n}\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:12:\"bluesky_link\";s:0:\"\";s:14:\"isntagram_link\";s:1:\"#\";s:12:\"threads_link\";s:0:\"\";s:14:\"pinterest_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:10:\"skype_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:10:\"viber_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:12:\"discord_link\";s:0:\"\";s:9:\"yelp_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:14:\"share_whatsapp\";s:1:\"0\";s:8:\"share_tg\";s:1:\"0\";s:11:\"share_viber\";s:1:\"0\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_ok\";s:1:\"0\";s:11:\"share_email\";s:1:\"0\";s:19:\"mobile_optimization\";s:1:\"0\";s:16:\"load_text_domain\";s:1:\"1\";s:21:\"disable_gutenberg_css\";s:1:\"0\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"0\";s:21:\"remove_jquery_migrate\";s:1:\"0\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:8:\"required\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:17:\"wd_swiper_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:22:\"lazy_loading_bg_images\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"fade\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";s:1:\"0\";s:26:\"rocket_delay_js_exclusions\";s:1:\"0\";s:6:\"cf7_js\";s:1:\"1\";s:20:\"elementor_animations\";s:1:\"1\";s:15:\"elementor_icons\";s:1:\"1\";s:24:\"elementor_dialog_library\";s:1:\"1\";s:18:\"elementor_frontend\";s:1:\"1\";s:14:\"swiper_library\";s:6:\"always\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:7:\"not_use\";s:23:\"font_icon_woff2_preload\";s:1:\"0\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:15:\"current_builder\";s:8:\"external\";s:16:\"gutenberg_blocks\";s:1:\"0\";s:29:\"enable_gutenberg_for_products\";s:1:\"0\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"0\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"1\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"1\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:16:\"maintenance_mode\";s:1:\"0\";s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";s:1:\"0\";s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"1\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:2:\"21\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:117:\"You don\'t have any products in the wishlist yet. <br> You will find a lot of interesting products on our \"Shop\" page.\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"0\";s:27:\"checkout_show_product_image\";s:1:\"1\";s:25:\"checkout_product_quantity\";s:1:\"1\";s:22:\"checkout_remove_button\";s:1:\"1\";s:24:\"checkout_link_to_product\";s:1:\"0\";s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"two-column\";s:21:\"reviews_form_location\";s:6:\"before\";s:13:\"reviews_style\";s:7:\"style-2\";s:15:\"reviews_columns\";s:1:\"2\";s:22:\"reviews_columns_tablet\";s:1:\"1\";s:22:\"reviews_columns_mobile\";s:1:\"1\";s:24:\"reviews_enable_pros_cons\";s:1:\"0\";s:20:\"reviews_enable_likes\";s:1:\"1\";s:32:\"show_reviews_purchased_indicator\";s:1:\"1\";s:15:\"reviews_sorting\";s:1:\"1\";s:29:\"single_product_comment_images\";s:1:\"0\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";s:1:\"0\";s:22:\"reviews_rating_summary\";s:1:\"1\";s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";s:1:\"1\";s:26:\"reviews_rating_by_criteria\";s:1:\"0\";s:32:\"reviews_criteria_rating_required\";s:1:\"0\";s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:0:\"\";s:23:\"sticky_navigation_title\";s:0:\"\";s:30:\"sticky_navigation_content_type\";s:4:\"text\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:0:\"\";s:33:\"single_product_main_gallery_video\";s:1:\"1\";s:23:\"checkout_fields_enabled\";s:1:\"0\";s:29:\"shipping_progress_bar_enabled\";s:1:\"1\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:4:\"1300\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"exclude\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"1\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:46:\"Add [remainder] to cart and get free shipping!\";s:37:\"shipping_progress_bar_message_success\";s:39:\"Your order qualifies for free shipping!\";s:15:\"buy_now_enabled\";s:1:\"1\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"0\";s:27:\"counter_visitor_data_source\";s:9:\"live_data\";s:38:\"counter_visitor_data_source_min_number\";s:2:\"10\";s:38:\"counter_visitor_data_source_max_number\";s:2:\"20\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:17:\"linked_variations\";s:1:\"1\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJk