<?php
/**
 * Dummy content template.
 *
 * @package woodmart
 */

use XTS\Import\Remove;
use XTS\Import\Import;

$wrapper_classes = '';

if ( Import::get_instance()->is_imported( 'base' ) && Remove::get_instance()->has_data_to_remove() ) {
	$wrapper_classes .= ' imported-base';
}
?>

<div class="xts-wizard-content-inner xts-wizard-dummy<?php echo esc_attr( $wrapper_classes ); ?>">
	<h3>
		<?php esc_html_e( 'Dummy content', 'woodmart' ); ?>
	</h3>

	<?php Import::get_instance()->interface(); ?>

	<p class="xts-wizard-note">
		<?php
		echo wp_kses(
			'در این بخش می توانید هر یک از دموها را بر روی سایت تان درون ریزی کنید، دموها ممکن است شامل : تصاویر، متون، برگه، نوشته، نمونه کار، اسلایدر و... باشند. می توانید دمو درون ریزی کرده یا از این مرحله رد شوید.',
			woodmart_get_allowed_html()
		);
		?>
	</p>
</div>

<div class="xts-wizard-footer">
	<?php $this->get_prev_button( 'plugins' ); ?>
	<div>
		<?php $this->get_next_button( 'done' ); ?>
		<?php $this->get_skip_button( 'done' ); ?>
	</div>
</div>


<div class="xts-wizard-content-inner xts-wizard-done">
	<div class="xts-wizard-logo">
		<img src="<?php echo esc_url( $this->get_image_url( 'logo.svg' ) ); ?>" alt="logo">
	</div>

	<h3>
		<?php esc_html_e( 'همه چیز آماده است!', 'woodmart' ); ?>
	</h3>

	<p>
		<?php
		esc_html_e(
			'Congratulations! You have successfully installed our theme. Now you can start creating your amazing website with a help of our theme. It provides you with a full control on your website layout style.',
			'woodmart'
		);
		?>
	</p>

	<div class="xts-wizard-buttons">
		<a class="xts-btn xts-btn-alt" href="<?php echo esc_url( get_home_url() ); ?>">
			<?php esc_html_e( 'مشاهده صفحه سالی', 'woodmart' ); ?>
		</a>

		<a class="xts-inline-btn" href="<?php echo esc_url( wc_admin_url( '&path=/setup-wizard' ) ); ?>">
			<?php esc_html_e( 'نصب ووکامرس', 'woodmart' ); ?>
		</a>

		<a class="xts-inline-btn" href="<?php echo esc_url( admin_url( 'admin.php?page=xtemos_options' ) ); ?>">
			<?php esc_html_e( 'تنظیمات قالب', 'woodmart' ); ?>
		</a>

		<a class="xts-inline-btn" href="<?php echo esc_url( admin_url( 'admin.php?page=woodmart_dashboard&tab=builder' ) ); ?>">
			<?php esc_html_e( 'سربرگ ساز', 'woodmart' ); ?>
		</a>
	</div>
</div>